/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.openapi.util;

import com.gentleware.openapi.util.BuildPropertiesBasic;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.Strings;
import com.gentleware.openapi.util.ThrowableRenderer;
import com.gentleware.openapi.util.TopLevelDomain;
import com.gentleware.util.B;
import com.gentleware.util.R;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.server.UID;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.xml.DOMConfigurator;

public class Utils {
    private static Logger F;
    private static final double K = 1.0E-10;
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int MILLISECONDS_PER_MINUTE = 60000;
    public static final int MILLISECONDS_PER_HOUR = 3600000;
    public static final int MILLISECONDS_PER_DAY = 86400000;
    private static PrintStream H;
    private static PrintStream B;
    public static final String GENTLEWARE_CONFIGURATION_DIRECTORY_PROPERTY_NAME = "gw.config.dir";
    private static String G;
    private static R J;
    private static boolean D;
    private static final String M = "com/gentleware/util/logging.xml";
    public static final String GW_SYSTEM_DIR_KEY = "gw.system.dir";
    public static final String POSEIDON_USER_DIR_KEY_PREFIX = "poseidon.user.dir.";
    private static _B C;
    private static boolean A;
    private static Class class$com$gentleware$openapi$util$Utils;
    private static Class L;
    private static Class I;

    private Utils() {
    }

    public static String makeDateString(Date date) {
        return Utils.makeDateString(date, 3, 2);
    }

    public static String makeDateString(Date date, int n, int n2) {
        DateFormat dateFormat = DateFormat.getDateInstance(n, Locale.getDefault());
        DateFormat dateFormat2 = DateFormat.getTimeInstance(n2, Locale.getDefault());
        String string = dateFormat.format(date);
        String string2 = dateFormat2.format(date);
        String string3 = string + "  " + string2;
        return string3;
    }

    public static void addDaysToDate(Date date, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.add(5, n);
        date.setTime(gregorianCalendar.getTime().getTime());
    }

    public static int getDateDifferenceInDays(Date date, Date date2) {
        long l = date.getTime();
        long l2 = date2.getTime();
        long l3 = l2 - l;
        int n = (int)(l3 / 86400000L);
        return n;
    }

    public static boolean checkEmail(String string) {
        int n = string.indexOf(64);
        if (n < 0) {
            return false;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 < 0 || n2 < n + 2 || n2 > string.length() - 3) {
            return false;
        }
        String string2 = string.substring(n2 + 1);
        boolean bl = TopLevelDomain.isValidDomainName(string2);
        return bl;
    }

    public static boolean isWindowsOs() {
        String string = System.getProperty("os.name");
        boolean bl = string.toLowerCase().startsWith("windows");
        return bl;
    }

    public static boolean isMacOs() {
        String string = System.getProperty("mrj.version");
        boolean bl = string != null;
        return bl;
    }

    public static boolean isLinuxOs() {
        String string = System.getProperty("os.name");
        boolean bl = string.toLowerCase().startsWith("linux");
        return bl;
    }

    public static void setupWebstartDesktopIntegrationFix() {
        if (J == null) {
            J = new R();
        }
    }

    public static void shutdownWebstartDesktopIntegrationFix() {
        if (J != null) {
            J.A();
            J = null;
        }
    }

    public static String filenameToUri(String string) {
        int n;
        string = string.replace(File.separatorChar, '/');
        if ((string = string.replaceAll(" ", "%20")).length() >= 2 && string.charAt(1) == ':' && (n = (int)Character.toUpperCase(string.charAt(0))) >= 65 && n <= 90) {
            string = '/' + string;
        }
        if ((n = string.indexOf("://")) >= 0) {
            n += string.startsWith("file://") ? 3 : 2;
        }
        n = string.indexOf("//", n);
        while (n >= 0) {
            string = string.substring(0, n) + string.substring(n + 1);
            n = string.indexOf("//", n);
        }
        return string;
    }

    public static String stripJunk(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2 && Character.isJavaIdentifierPart(string.charAt(n4))) {
            ++n4;
            ++n3;
        }
        if (n3 == n2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (n = 0; n < n3; ++n) {
            stringBuffer.append(string.charAt(n));
        }
        for (n = n3 + 1; n < n2; ++n) {
            char c = string.charAt(n);
            if (!Character.isJavaIdentifierPart(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getPathToContainingJar(Class clazz) {
        String string = clazz.getName();
        string = string.replace('.', '/');
        URL uRL = clazz.getClassLoader().getResource(string + ".class");
        String string2 = uRL.toString();
        int n = string2.indexOf(33);
        if (n > 0) {
            string2 = string2.substring(0, n);
        } else {
            String string3 = '/' + string + ".class";
            if (string2.endsWith(string3)) {
                string2 = string2.substring(0, string2.length() - string3.length());
            }
        }
        return string2;
    }

    public static URL fileToUrl(File file) throws MalformedURLException, IOException {
        String string = file.getCanonicalPath();
        String string2 = Utils.filenameToUri(string);
        URL uRL = new URL("file", "", string2);
        return uRL;
    }

    public static URL exchangeUrlExtension(URL uRL, String string) throws MalformedURLException {
        if (!uRL.getFile().endsWith(string)) {
            uRL = Utils.fixUrlExtension(uRL, string);
        }
        return Utils.stripUrlExtension(uRL);
    }

    public static URL stripUrlExtension(URL uRL) throws MalformedURLException {
        String string = uRL.getFile();
        string = string.substring(0, string.lastIndexOf(46));
        uRL = new URL(uRL, string);
        return uRL;
    }

    public static URL fixUrlExtension(URL uRL, String string) throws MalformedURLException {
        String string2 = uRL.getFile();
        if (!string2.endsWith(string)) {
            int n = string2.lastIndexOf(File.pathSeparatorChar);
            int n2 = string2.lastIndexOf(".", n);
            uRL = n2 >= 0 ? new URL(uRL, string2.substring(0, n2) + string) : new URL(uRL, string2 + string);
        }
        return uRL;
    }

    public static String removeDots(String string) {
        if (string.lastIndexOf(46) <= 0) {
            return string;
        }
        int n = string.indexOf(46);
        String string2 = string.substring(0, n) + Utils.removeDots(string.substring(n + 1));
        return string2;
    }

    public static float getFileIncrementor(File file) {
        int n = 0;
        n = file.isDirectory() ? (n += Utils.getFileCount(file)) : ++n;
        return 100 / n;
    }

    public static int getFileCount(File file) {
        int n = 0;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return 0;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    n += Utils.getFileCount(fileArray[i]);
                    continue;
                }
                if (!fileArray[i].isFile() || !fileArray[i].getName().endsWith(".java")) continue;
                ++n;
            }
        }
        return n;
    }

    public static List getAllFilenames(File file, String string) {
        List list = CollectionFactory.createArrayList();
        if (!string.startsWith(".")) {
            string = '.' + string;
        }
        Utils.A(file, list, string);
        return list;
    }

    public static List getJavaFilenames(File file) {
        List list = CollectionFactory.createArrayList();
        Utils.A(file, list, ".java");
        return list;
    }

    private static boolean A(File file, List list, String string) {
        if (file == null) {
            return false;
        }
        List list2 = CollectionFactory.createArrayList();
        boolean bl = true;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].isDirectory()) {
                        bl &= Utils.A(fileArray[i], list, string);
                        continue;
                    }
                    if (fileArray[i].isFile() && fileArray[i].getName().endsWith(string)) {
                        list2.add(fileArray[i].getPath());
                        continue;
                    }
                    bl = false;
                }
                if (bl) {
                    list.add(file.getPath());
                } else if (list2.size() > 0) {
                    list.addAll(list2);
                }
            } else {
                list.add(file.getPath());
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean canWriteImage(String string) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        return iterator != null && iterator.hasNext();
    }

    public static void writeImage(RenderedImage renderedImage, String string, OutputStream outputStream) throws IOException, IllegalArgumentException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("Unsupported image format: " + string);
        }
        ImageWriter imageWriter = iterator.next();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(renderedImage);
        imageOutputStream.close();
        imageWriter.dispose();
    }

    public static BufferedImage readImage(URL uRL) throws IOException, IllegalArgumentException {
        String string = uRL.getPath();
        int n = string.lastIndexOf(".");
        if (n <= 0) {
            throw new IllegalArgumentException("[Utils] readImage(): Cannot get format from url suffix" + uRL);
        }
        String string2 = string.substring(n + 1);
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string2);
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("Unsupported image format: " + string2);
        }
        ImageReader imageReader = iterator.next();
        InputStream inputStream = uRL.openStream();
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        imageReader.setInput(imageInputStream);
        BufferedImage bufferedImage = imageReader.read(0);
        inputStream.close();
        imageInputStream.close();
        imageReader.dispose();
        return bufferedImage;
    }

    public static BufferedImage readImageFromBuffer(URL uRL, byte[] byArray) throws IOException, IllegalArgumentException {
        String string = uRL.getPath();
        int n = string.lastIndexOf(".");
        if (n <= 0) {
            throw new IllegalArgumentException("[Utils] readImage(): Cannot get format from url suffix" + uRL);
        }
        String string2 = string.substring(n + 1);
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string2);
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("Unsupported image format: " + string2);
        }
        ImageReader imageReader = iterator.next();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
        imageReader.setInput(imageInputStream);
        BufferedImage bufferedImage = imageReader.read(0);
        byteArrayInputStream.close();
        imageInputStream.close();
        imageReader.dispose();
        return bufferedImage;
    }

    public static int getSign(double d) {
        return d < 0.0 ? -1 : (d == 0.0 ? 0 : 1);
    }

    public static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static int compare(long l, long l2) {
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    public static int compare(double d, double d2) {
        return Utils.compare(d, d2, 1.0E-10);
    }

    public static int compare(double d, double d2, double d3) {
        double d4 = d - d2;
        if (Math.abs(d4) < d3) {
            return 0;
        }
        return d < d2 ? -1 : 1;
    }

    public static boolean equals(double d, double d2) {
        return Utils.equals(d, d2, 1.0E-10);
    }

    public static boolean equals(double d, double d2, double d3) {
        double d4 = d - d2;
        boolean bl = Math.abs(d4) < d3;
        return bl;
    }

    public static File urlToFile(URL uRL) {
        File file;
        boolean bl;
        String string = uRL.toExternalForm();
        boolean bl2 = string.indexOf(32) >= 0;
        boolean bl3 = bl = string.indexOf("%20") >= 0;
        if (bl2) {
            int n;
            file = new File(uRL.getFile());
            String string2 = file.getPath();
            if (bl) {
                string2 = Strings.replaceAll(string2, "%20", " ");
            }
            if ((n = string2.indexOf(".jar!")) > 0) {
                string2 = string2.substring(0, n + 4);
            }
            if (string2.startsWith("file:")) {
                string2 = string2.substring("file:".length());
            }
            file = new File(string2);
        } else {
            int n;
            String string3 = uRL.toExternalForm();
            if (string3.startsWith("jar:") && (n = string3.lastIndexOf(33)) > 4) {
                string3 = string3.substring(4, n);
            }
            if (Utils.isWindowsOs()) {
                string3 = string3.replace('\\', '/');
            }
            if (string3.startsWith("file:")) {
                if (Utils.D(string3)) {
                    String string4 = "\\\\" + string3.substring("file://".length());
                    File file2 = new File(string4);
                    return file2;
                }
                if (!string3.startsWith("file:/")) {
                    string3 = "file:///" + string3.substring("file:".length());
                }
            }
            try {
                URI uRI = new URI(string3);
                file = new File(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                F.error((Object)"URL to File Error", (Throwable)uRISyntaxException);
                file = null;
            }
        }
        return file;
    }

    private static boolean D(String string) {
        boolean bl = string.indexOf(58, 7) >= 0;
        return Utils.isWindowsOs() && string.startsWith("file://") && !bl;
    }

    public static float getColorSimilarity(Color color, Color color2) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
        Utils.A(fArray);
        Utils.A(fArray2);
        float f = fArray[0] - fArray2[0];
        float f2 = fArray[1] - fArray2[1];
        float f3 = fArray[2] - fArray2[2];
        float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        return f4;
    }

    private static void A(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = (float)((double)f * 2.0 * Math.PI);
        double d = 0.5 * (double)f2 * (double)f3;
        fArray[0] = (float)(d * Math.cos(f4));
        fArray[1] = (float)(d * Math.sin(f4));
        fArray[2] = (float)((double)fArray[2] / Math.sqrt(0.75));
    }

    public static String createUniqueId() {
        return new UID().toString();
    }

    public static Object findFirstCommonObject(Collection collection, Collection collection2) throws IllegalArgumentException {
        int n;
        int n2 = collection.size();
        if (n2 != (n = collection2.size())) {
            throw new IllegalArgumentException("Collections must not differ in size (" + n2 + " != " + n + ").");
        }
        Object var4_4 = null;
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            Object e;
            Object e2 = iterator.next();
            if (!e2.equals(e = iterator2.next())) continue;
            var4_4 = e2;
        }
        return var4_4;
    }

    public static short getUnsignedByte(byte by) {
        short s = by;
        if (s < 0) {
            s = (short)(s + 256);
        }
        return s;
    }

    public static byte getSignedByte(short s) {
        byte by = s > 127 ? (byte)(s - 256) : (byte)s;
        return by;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        boolean bl = object.equals(object2);
        return bl;
    }

    public static File getInstallationDirectory(Class clazz) {
        String string = System.getProperty("poseidon.inst.dir");
        if (string != null && !"".equals(string)) {
            File file = new File(string);
            return file;
        }
        String string2 = clazz.getName();
        String string3 = string2.replace('.', '/') + ".class";
        int n = string3.lastIndexOf(47);
        URL uRL = clazz.getClassLoader().getResource(string3);
        File file = null;
        File file2 = Utils.urlToFile(uRL);
        if (file2 != null) {
            File file3;
            Object object;
            int n2;
            String string4 = file2.getPath();
            if (Utils.isWindowsOs()) {
                string4 = string4.replace('\\', '/');
            }
            String string5 = null;
            if (string4.endsWith(".jar")) {
                file2 = file2.getParentFile();
                string4 = file2.getPath();
                if (Utils.isWindowsOs()) {
                    string4 = string4.replace('\\', '/');
                }
                if (string4.endsWith("/")) {
                    string4 = string4.substring(0, string4.length() - "/".length());
                }
                if (string4.endsWith("/build/lib")) {
                    string4 = string4.substring(0, string4.length() - "/build/lib".length());
                }
                if (string4.endsWith("/lib")) {
                    string4 = string4.substring(0, string4.length() - "/lib".length());
                }
                if (string4.endsWith("/lib_build")) {
                    string4 = string4.substring(0, string4.length() - "/lib_build".length());
                }
                string5 = string4;
            } else if (string4.endsWith(".class")) {
                n2 = string4.lastIndexOf(47);
                string5 = string4.substring(0, n2);
                if (n > 0 && string5.endsWith((String)(object = string3.substring(0, n)))) {
                    string5 = string5.substring(0, string5.length() - ((String)object).length());
                }
                if (string5.endsWith("/build/classes/")) {
                    string5 = string5.substring(0, string5.length() - "/build/classes/".length());
                }
            }
            if (string5 != null) {
                if (Utils.isWindowsOs()) {
                    if (string5.startsWith("/")) {
                        string5 = string5.substring("/".length());
                    }
                    if ((string5 = string5.replace('/', File.separatorChar)).endsWith("\\")) {
                        string5 = string5.substring(0, string5.length() - "\\".length()) + '/';
                    }
                }
                file = new File(string5);
            }
            n2 = 1;
            if (file != null) {
                object = new File(file, "lib_build" + File.separator + "poseidon2.jar");
                file3 = new File(file, "build/lib" + File.separator + "poseidon2.jar");
                File file4 = new File(file, "lib" + File.separator + "poseidon2.jar");
                int n3 = n2 = !file4.exists() && !((File)object).exists() && !file3.exists() ? 1 : 0;
            }
            if (n2 != 0 && (object = System.getProperty("poseidon.lib")) != null) {
                file3 = new File((String)object);
                file = file3.getParentFile();
            }
            try {
                if (file != null) {
                    file = file.getCanonicalFile();
                }
            }
            catch (IOException iOException) {
                F.info((Object)"Ignoring exception.", (Throwable)iOException);
            }
        }
        if (file == null || !file.exists()) {
            // empty if block
        }
        return file;
    }

    public static File getSystemDir() {
        File file = Utils.getConfigDir();
        String string = file + File.separator + "system";
        File file2 = Utils.getDirectoryFromSystemProperty(GW_SYSTEM_DIR_KEY, string);
        return file2;
    }

    public static File getProjectCachesDir() {
        return new File(Utils.getSystemDir().getPath() + System.getProperty("file.separator") + G);
    }

    public static boolean clearProjectCaches() {
        File file = Utils.getProjectCachesDir();
        return Utils.clearDir(file);
    }

    public static boolean clearDir(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    Utils.deleteDir(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
        }
        return file.listFiles().length == 0;
    }

    public static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    Utils.deleteDir(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
            return file.delete();
        }
        return false;
    }

    public static File getConfigDir() {
        String string = BuildPropertiesBasic.getEditionShort();
        String string2 = POSEIDON_USER_DIR_KEY_PREFIX + string;
        String string3 = Utils.getConfigDir(string);
        File file = Utils.getDirectoryFromSystemProperty(string2, string3);
        return file;
    }

    public static File getDirectoryFromSystemProperty(String string, String string2) {
        String string3 = System.getProperty(string);
        if (Strings.isEmpty(string3)) {
            string3 = string2;
        }
        String string4 = Utils.resolveUserHomePath(string3);
        File file = new File(string4);
        return file;
    }

    public static String resolveUserHomePath(String string) {
        if (Utils.isWindowsOs()) {
            String string2 = System.getProperty("user.home");
            String string3 = Strings.replaceFirst(string, "~", string2 + File.separator);
            return string3;
        }
        return string;
    }

    public static String getConfigDir(String string) {
        return Utils.getConfigDir(".poseidon", string, true);
    }

    public static String getConfigDir(String string, String string2) {
        return Utils.getConfigDir(string, string2, true);
    }

    public static String getPoseidon2ConfigDir(String string) {
        return Utils.getConfigDir("poseidon2", string, false);
    }

    public static String getConfigDir(String string, String string2, boolean bl) {
        File file;
        String string3 = System.getProperty("user.home") + File.separatorChar + string + File.separatorChar + string2;
        String string4 = System.getProperty(POSEIDON_USER_DIR_KEY_PREFIX + string2);
        String string5 = string4 != null && !"".equals(string4) ? string4 : string3;
        if (bl && !(file = new File(string5)).exists()) {
            file.mkdirs();
        }
        return string5;
    }

    public static Date installationDate(int n, Class clazz) {
        File file = Utils.getInstallationDirectory(clazz);
        long l = file.lastModified();
        Date date = new Date(l);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.add(5, n);
        Date date2 = gregorianCalendar.getTime();
        return date2;
    }

    public static void intersect(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection2.contains(e)) continue;
            iterator.remove();
        }
    }

    public static Collection intersection(Collection collection, Collection collection2) {
        if (collection.size() == 0 || collection2.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList(collection);
        Utils.intersect(arrayList, collection2);
        return arrayList;
    }

    public static void addAtIndex(Collection collection, int n, Object object) {
        int n2;
        if (collection instanceof List) {
            List list = (List)collection;
            list.add(n, object);
            return;
        }
        int n3 = collection.size();
        if (n == n3) {
            collection.add(object);
            return;
        }
        List list = CollectionFactory.createArrayList(n3 - n);
        Iterator iterator = collection.iterator();
        for (n2 = 0; n2 < n; ++n2) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            list.add(e);
            iterator.remove();
        }
        collection.add(object);
        int n4 = list.size();
        for (n2 = 0; n2 < n4; ++n2) {
            Object e = list.get(n2);
            collection.add(e);
        }
    }

    public static Object removeAtIndex(Collection collection, int n) {
        if (collection instanceof List) {
            List list = (List)collection;
            Object e = list.remove(n);
            return e;
        }
        Iterator iterator = collection.iterator();
        Object var3_5 = null;
        for (int i = 0; i <= n; ++i) {
            var3_5 = iterator.next();
        }
        iterator.remove();
        return var3_5;
    }

    public static Object getAtIndex(Collection collection, int n) {
        if (collection instanceof List) {
            List list = (List)collection;
            Object e = list.get(n);
            return e;
        }
        Iterator iterator = collection.iterator();
        Object var3_5 = null;
        for (int i = 0; i <= n; ++i) {
            var3_5 = iterator.next();
        }
        return var3_5;
    }

    public static int indexOf(Collection collection, Object object) {
        if (collection instanceof List) {
            List list = (List)collection;
            int n = list.indexOf(object);
            return n;
        }
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (object == e) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean isValidLocaleSpec(String string) {
        String[] stringArray = string.split("_", 3);
        if (stringArray.length == 0) {
            return true;
        }
        if (!Utils.B(stringArray[0])) {
            return false;
        }
        return stringArray.length <= 1 || Utils.A(stringArray[1]);
    }

    public static Locale createLocale(String string) {
        if (string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split("_", 3);
        String string2 = stringArray[0];
        String string3 = stringArray.length > 1 ? stringArray[1] : "";
        String string4 = stringArray.length > 2 ? stringArray[2] : "";
        Locale locale = new Locale(string2, string3, string4);
        return locale;
    }

    public static String getLocaleSpec(Locale locale, boolean bl) {
        if (locale == null) {
            return "";
        }
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = locale.getVariant();
        StringBuffer stringBuffer = new StringBuffer();
        if (!Strings.isEmpty(string)) {
            if (bl) {
                stringBuffer.append('_');
            }
            stringBuffer.append(string);
            if (!Strings.isEmpty(string2)) {
                stringBuffer.append('_');
                stringBuffer.append(string2);
                if (!Strings.isEmpty(string3)) {
                    stringBuffer.append('_');
                    stringBuffer.append(string3);
                }
            }
        }
        return new String(stringBuffer);
    }

    private static boolean B(String string) {
        return string.length() == 2 && string.equals(string.toLowerCase());
    }

    private static boolean A(String string) {
        return string.length() == 2 && string.equals(string.toUpperCase());
    }

    public static boolean validPathnameForOperatingSystem(String string) {
        File file = new File(string);
        String string2 = file.getName();
        boolean bl = string2.equals(string);
        return !bl;
    }

    public static String getExceptionFullDescription(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(exception.getMessage());
        exception.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    public static String getFilenameFromUrl(URL uRL, int n, boolean bl, String string) {
        String string2;
        if (uRL == null) {
            string2 = string;
        } else {
            String string3;
            String string4;
            String string5;
            Comparable<File> comparable;
            String string6 = uRL.toExternalForm();
            String string7 = System.getProperty("file.separator");
            String string8 = uRL.getProtocol();
            if ("file".equals(string8)) {
                comparable = Utils.urlToFile(uRL);
                string5 = ((File)comparable).getName();
                string4 = Strings.noNull(((File)comparable).getParent());
                string3 = string4.equals(string7) ? "" : string4;
            } else {
                int n2 = string6.lastIndexOf(47);
                if (n2 > 0) {
                    string7 = "/";
                } else {
                    n2 = string6.lastIndexOf(string7);
                }
                if (n2 <= 0) {
                    string5 = string6;
                    string3 = "";
                } else {
                    string5 = string6.substring(n2 + 1);
                    string3 = string6.substring(0, n2);
                }
            }
            if (bl) {
                boolean bl2;
                comparable = new StringBuffer();
                string4 = "...";
                int n3 = "...".length();
                int n4 = string5.length();
                int n5 = string7.length();
                int n6 = string3.length();
                int n7 = n6 + n5 + n4;
                int n8 = n3 + n5;
                boolean bl3 = bl2 = n > 0 && n7 > n;
                if (bl2) {
                    boolean bl4;
                    int n9 = n - n4 - n8;
                    boolean bl5 = bl4 = n9 <= 0;
                    if (bl4) {
                        ((StringBuffer)comparable).append("...");
                    } else {
                        boolean bl6;
                        boolean bl7 = bl6 = n9 < n6;
                        if (bl6) {
                            ((StringBuffer)comparable).append(string3.substring(0, n9));
                            ((StringBuffer)comparable).append("...");
                        } else {
                            ((StringBuffer)comparable).append(string3);
                        }
                    }
                    ((StringBuffer)comparable).append(string7);
                    ((StringBuffer)comparable).append(string5);
                } else {
                    ((StringBuffer)comparable).append(string3);
                    ((StringBuffer)comparable).append(string7);
                    ((StringBuffer)comparable).append(string5);
                }
                string2 = ((StringBuffer)comparable).toString();
            } else {
                string2 = string5;
            }
        }
        return string2;
    }

    public static synchronized boolean initializeLogging() throws IOException {
        return Utils.initializeLogging(M);
    }

    public static synchronized boolean shutdownLogging() {
        if (D) {
            LogManager.shutdown();
            D = false;
            return true;
        }
        return false;
    }

    public static synchronized boolean initializeLogging(String string) throws IOException {
        return Utils.initializeLogging(string, (class$com$gentleware$openapi$util$Utils == null ? (class$com$gentleware$openapi$util$Utils = Utils.C("com.gentleware.openapi.util.Utils")) : class$com$gentleware$openapi$util$Utils).getClassLoader());
    }

    public static synchronized boolean reinitializeLogging(File file) throws IOException {
        D = true;
        try {
            C.A(file);
            Utils.E();
        }
        catch (IOException iOException) {
            F.error((Object)("Attempt to reconfigure logging failed " + iOException));
            throw iOException;
        }
        return true;
    }

    public static synchronized boolean initializeLogging(String string, ClassLoader classLoader) throws IOException {
        _B _B2;
        if (D) {
            F.debug((Object)"Ignoring repeated call to initialize logging. Logging already initialized:");
            Utils.E();
            return false;
        }
        D = true;
        File file = Utils.getConfigDir();
        int n = string.lastIndexOf("/");
        String string2 = n > -1 && n < string.length() - 1 ? string.substring(n + 1) : "logging.xml";
        File file2 = Utils.getOrRestoreConfigurationFile(file, string2, string, classLoader);
        Utils.loadLoggingConfiguration(file2);
        F = Logger.getLogger((String)"com.gentleware.openapi.util.Utils");
        Utils.E();
        F.info((Object)("Logging configured from " + Utils.A(file2)));
        Utils.B();
        C = _B2 = new _B(file2, classLoader);
        C.start();
        return true;
    }

    public static File getOrRestoreConfigurationFile(File file, String string, String string2, ClassLoader classLoader) throws IOException {
        File file2 = new File(file, string);
        if (!file2.exists()) {
            Utils.A(file2, string2, classLoader);
        }
        return file2;
    }

    public static File restoreAndGetConfigurationFile(File file, String string, String string2) throws IOException {
        File file2 = new File(file, string);
        Utils.A(file2, string2, (class$com$gentleware$openapi$util$Utils == null ? (class$com$gentleware$openapi$util$Utils = Utils.C("com.gentleware.openapi.util.Utils")) : class$com$gentleware$openapi$util$Utils).getClassLoader());
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void A(File file, String string, ClassLoader classLoader) throws IOException {
        if (file.exists()) {
            Files.createBackup(file);
        }
        URL uRL = classLoader.getResource(string);
        try {
            InputStream inputStream = uRL.openStream();
            try {
                Files.copyToFile(inputStream, file);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static String A(File file) {
        String string = file.getPath();
        String string2 = file.getAbsolutePath();
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + 3);
        stringBuffer.append(string);
        if (!file.isAbsolute()) {
            stringBuffer.append(" (");
            stringBuffer.append(string2);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public static void loadLoggingConfiguration(File file) throws IOException {
        File file2 = Utils.getConfigDir();
        StringBuffer stringBuffer = new StringBuffer(Files.readUtf8TextFile(file));
        String string = Strings.replaceAll(file2.getPath(), '\\', '/');
        String string2 = Strings.replaceAll(System.getProperty("user.home"), '\\', '/');
        String string3 = Strings.replaceAll(Files.getTmpDirectory().getAbsolutePath(), '\\', '/');
        String string4 = System.getProperty("user.name");
        Strings.replaceAll(stringBuffer, "${gw.config.dir}", string);
        Strings.replaceAll(stringBuffer, "${tmp.dir}", string3);
        Strings.replaceAll(stringBuffer, "${user.name}", string4);
        Strings.replaceAll(stringBuffer, "~", string2);
        StringReader stringReader = new StringReader(new String(stringBuffer));
        DOMConfigurator dOMConfigurator = new DOMConfigurator();
        LoggerRepository loggerRepository = LogManager.getLoggerRepository();
        dOMConfigurator.doConfigure((Reader)stringReader, loggerRepository);
        if (loggerRepository instanceof Hierarchy) {
            Hierarchy hierarchy = (Hierarchy)loggerRepository;
            hierarchy.addRenderer(L == null ? (L = Utils.C("java.lang.Throwable")) : L, (ObjectRenderer)new ThrowableRenderer());
        }
    }

    private static void E() {
        Package package_ = (I == null ? (I = Utils.C("org.apache.log4j.Layout")) : I).getPackage();
        Utils.dumpPackageInformation(package_);
        Logger logger = LogManager.getRootLogger();
        String string = logger.getName();
        F.debug((Object)("Logger: " + string));
        Enumeration enumeration = logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Appender appender = (Appender)enumeration.nextElement();
            String string2 = appender.getName();
            F.debug((Object)("\tAppender: " + string2));
            if (!(appender instanceof FileAppender)) continue;
            FileAppender fileAppender = (FileAppender)appender;
            String string3 = fileAppender.getFile();
            F.debug((Object)("\t\tappending to: \"" + string3 + '\"'));
        }
    }

    public static void dumpPackageInformation(Package package_) {
        F.info((Object)package_.getName());
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("Specification title", package_.getSpecificationTitle());
        linkedHashMap.put("Specification vendor", package_.getSpecificationVendor());
        linkedHashMap.put("Specification version", package_.getSpecificationVersion());
        linkedHashMap.put("Implementation title", package_.getImplementationTitle());
        linkedHashMap.put("Implementation vendor", package_.getImplementationVendor());
        linkedHashMap.put("Implementation version", package_.getImplementationVersion());
        String[] stringArray = Strings.getPaddedKeyValueList(linkedHashMap, '.', true, false);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            F.info((Object)('\t' + string));
        }
    }

    public static Object getValueFromSingleElementCollection(Collection collection) {
        Iterator iterator = collection.iterator();
        Object var2_2 = iterator.hasNext() ? iterator.next() : null;
        return var2_2;
    }

    public static void initializeConfigDirsForEdition(String string) {
        String string2 = System.getProperty("user.home");
        if (Strings.isEmpty(System.getProperty(GENTLEWARE_CONFIGURATION_DIRECTORY_PROPERTY_NAME))) {
            System.setProperty(GENTLEWARE_CONFIGURATION_DIRECTORY_PROPERTY_NAME, string2 + File.separator + ".poseidon" + File.separator + string);
        }
        if (Strings.isEmpty(System.getProperty(GW_SYSTEM_DIR_KEY))) {
            System.setProperty(GW_SYSTEM_DIR_KEY, string2 + File.separator + ".poseidon" + File.separator + string + File.separator + "system");
        }
    }

    public static PrintStream getStandardOut() {
        return H;
    }

    private static synchronized void B() {
        if (H != null || B != null) {
            Utils.C();
        }
        H = System.out;
        B = System.err;
        B b = new B(F, Level.ERROR);
        B b2 = new B(F, Level.INFO);
        System.setErr(new PrintStream(b));
        System.setOut(new PrintStream(b2));
        System.out.println("System.out/err redirected to logging.");
    }

    private static void C() {
        System.setOut(H);
        H = null;
        System.setErr(B);
        B = null;
    }

    public static void logErrorOrThrow(Logger logger, Object object) {
        Utils.logErrorOrThrow(logger, object, null);
    }

    public static void logErrorOrThrow(Logger logger, Object object, Throwable throwable) {
        if (throwable == null) {
            throwable = object == null ? new _A() : new _A(object.toString());
        }
        logger.log((Priority)Level.ERROR, object, throwable);
        boolean bl = Utils.D();
        if (bl) {
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            throw new _A(throwable);
        }
    }

    private static boolean D() {
        return A;
    }

    private static void A() {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string = stackTraceElement.getClassName();
            String string2 = stackTraceElement.getMethodName();
            if ((!"junit.framework.TestCase".equals(string) || !"runTest".equals(string2)) && (!"junit.framework.TestSuite".equals(string) || !"runTest".equals(string2))) continue;
            A = true;
            break;
        }
    }

    static {
        G = "project_caches";
        try {
            Utils.initializeLogging();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Utils.A();
    }

    private static Class C(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private static class _A
    extends RuntimeException {
        private _A() {
        }

        private _A(Throwable throwable) {
            super(throwable);
        }

        private _A(String string) {
            super(string);
        }
    }

    private static class _B
    extends Thread {
        private File B;
        private long C;
        private final ClassLoader A;

        private _B(File file, ClassLoader classLoader) {
            super("CheckLoggingConfigurationThread");
            this.B = file;
            this.C = this.B.lastModified();
            this.A = classLoader;
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        long l;
                        _B.sleep(30000L);
                        if (!this.B.exists()) {
                            Utils.A(this.B, Utils.M, this.A);
                        }
                        if (this.C == (l = this.B.lastModified())) continue;
                        this.C = l;
                        String string = Utils.A(this.B);
                        F.info((Object)("Reloading log configuration from " + string));
                        this.A();
                        F.info((Object)("Logging reconfigured from " + string));
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (IOException iOException) {
                    F.error((Object)"Logging reconfiguration failed", (Throwable)iOException);
                    continue;
                }
                break;
            }
        }

        public void A(File file) throws IOException {
            this.B = file;
            this.C = file.lastModified();
            this.A();
        }

        private void A() throws IOException {
            Utils.C();
            Utils.loadLoggingConfiguration(this.B);
            Utils.B();
        }
    }
}

