/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.util;

import com.gentleware.openapi.util.ProductVersion;
import com.gentleware.openapi.util.Strings;
import java.io.Serializable;
import java.util.StringTokenizer;

public class ProductVersionImpl
extends ProductVersion
implements Serializable {
    static final long serialVersionUID = 6723963943143611837L;
    private Long B;
    private Integer D;
    private Integer A;
    private Integer E;
    private String C;

    private ProductVersionImpl() {
    }

    public ProductVersionImpl(String string) throws IllegalArgumentException {
        String string2;
        int n = string.indexOf(45);
        if (n >= 0) {
            if (n == string.length() - 1) {
                throw new IllegalArgumentException("Must not add dash at end of version: \"" + string + "\"");
            }
            this.C = string.substring(n + 1);
            if (this.C.indexOf(45) >= 0) {
                throw new IllegalArgumentException("Beta-version-information must not contain a dash: \"" + string + "\"");
            }
            string2 = string.substring(0, n);
        } else {
            this.C = "";
            string2 = string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        int n2 = stringTokenizer.countTokens();
        if (n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("Version-information must contain at least 2 and at most 3 parts: \"" + string + "\"");
        }
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = n2 == 3 ? stringTokenizer.nextToken() : "0";
        try {
            this.D = new Integer(string3);
            this.A = new Integer(string4);
            this.E = new Integer(string5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Parts in version-information are no valid numbers: \"" + string + "\"");
        }
    }

    public ProductVersionImpl(int n, int n2, int n3, String string) throws IllegalArgumentException {
        this(new Integer(n), new Integer(n2), new Integer(n3), string);
    }

    public ProductVersionImpl(Integer n, Integer n2, Integer n3, String string) {
        if (n == null && n2 == null && n3 == null) {
            this.D = new Integer(-1);
            this.E = new Integer(-1);
            this.A = new Integer(-1);
            this.C = null;
            System.out.println("No specified release number.");
        }
        this.D = n;
        this.E = n3;
        this.A = n2;
        this.C = string;
    }

    private static int A(int n, Integer n2, Integer n3, boolean bl) {
        int n4 = n == 0 ? (n2 == null ? (bl ? 0 : (n3 == null ? 0 : 1)) : (n3 == null ? (bl ? 0 : -1) : n2.compareTo(n3))) : n;
        return n4;
    }

    private int A(int n, ProductVersion productVersion, boolean bl) {
        String string = this.C;
        String string2 = productVersion.getBeta();
        int n2 = n == 0 ? (string == null ? (bl ? 0 : (string2 == null ? 0 : 1)) : (string2 == null ? (bl ? 0 : -1) : (this.isFinalVersion() && productVersion.isBetaVersion() ? 1 : (this.isBetaVersion() && productVersion.isFinalVersion() ? -1 : Strings.compare(this.C, productVersion.getBeta(), false))))) : n;
        return n2;
    }

    public int compareTo(ProductVersion productVersion) {
        return this.compareTo(productVersion, false);
    }

    public int compareTo(ProductVersion productVersion, boolean bl) {
        int n = ProductVersionImpl.A(0, this.D, productVersion.getMajor(), bl);
        n = ProductVersionImpl.A(n, this.A, productVersion.getMinor(), bl);
        n = ProductVersionImpl.A(n, this.E, productVersion.getMicro(), bl);
        n = this.A(n, productVersion, bl);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.D == null) {
            stringBuffer.append("x");
        } else {
            stringBuffer.append(this.D);
        }
        stringBuffer.append(".");
        if (this.A == null) {
            stringBuffer.append("x");
        } else {
            stringBuffer.append(this.A);
        }
        if (this.E != null && this.E != 0) {
            stringBuffer.append(".");
            stringBuffer.append(this.E);
        }
        if (!Strings.isEmpty(this.C)) {
            stringBuffer.append("-");
            stringBuffer.append(this.C);
        }
        String string = new String(stringBuffer);
        return string;
    }

    public Integer getMajor() {
        return this.D;
    }

    public Integer getMinor() {
        return this.A;
    }

    public Integer getMicro() {
        return this.E;
    }

    public String getBeta() {
        return this.C;
    }

    public boolean isBetaVersion() {
        return !Strings.isEmpty(this.C);
    }

    public boolean isFinalVersion() {
        return Strings.isEmpty(this.C);
    }

    public Long getId() {
        return this.B;
    }

    private void A(Long l) {
        this.B = l;
    }

    private void B(Integer n) {
        this.D = n;
    }

    private void A(Integer n) {
        this.A = n;
    }

    private void C(Integer n) {
        this.E = n;
    }

    private void A(String string) {
        this.C = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProductVersion)) {
            return false;
        }
        boolean bl = this.compareTo((ProductVersion)object) == 0;
        return bl;
    }

    public int hashCode() {
        int n = this.D != null ? this.D.hashCode() : 0;
        n = 29 * n + (this.A != null ? this.A.hashCode() : 0);
        n = 29 * n + (this.E != null ? this.E.hashCode() : 0);
        n = 29 * n + (this.C != null ? this.C.toLowerCase().hashCode() : 0);
        return n;
    }

    public int compareTo(Object object) {
        return this.compareTo((ProductVersion)object);
    }
}

