/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Encoders;

import Acme.JPM.Encoders.A;
import Acme.JPM.Encoders.B;
import Acme.JPM.Encoders.C;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;

public class GifEncoder
extends C {
    private boolean L;
    int width;
    int height;
    int[][] rgbPixels;
    Acme.A colorHash;
    int Width;
    int Height;
    boolean Interlace;
    int curx;
    int cury;
    int CountDown;
    int Pass;
    static final int EOF = -1;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent;
    boolean clear_flg;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum;
    int cur_bits;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];

    public GifEncoder(Image image, OutputStream outputStream) throws IOException {
        super(image, outputStream);
    }

    public GifEncoder(Image image, OutputStream outputStream, boolean bl) throws IOException {
        super(image, outputStream);
        this.L = bl;
    }

    public GifEncoder(ImageProducer imageProducer, OutputStream outputStream) throws IOException {
        super(imageProducer, outputStream);
    }

    public GifEncoder(ImageProducer imageProducer, OutputStream outputStream, boolean bl) throws IOException {
        super(imageProducer, outputStream);
        this.L = bl;
    }

    void encodeStart(int n2, int n3) throws IOException {
        this.width = n2;
        this.height = n3;
        this.rgbPixels = new int[n3][n2];
    }

    void encodePixels(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) throws IOException {
        for (int i2 = 0; i2 < n5; ++i2) {
            System.arraycopy(nArray, i2 * n7 + n6, this.rgbPixels[n3 + i2], n2, n4);
        }
    }

    void encodeDone() throws IOException {
        Object object;
        int n2;
        int n3;
        int n4 = -1;
        int n5 = -1;
        int[] nArray = B.A(this.rgbPixels, 252);
        int n6 = this.rgbPixels.length;
        int n7 = this.rgbPixels[0].length;
        int n8 = n6;
        while (n8-- > 0) {
            n3 = n7;
            while (n3-- > 0) {
                this.rgbPixels[n8][n3] = nArray[this.rgbPixels[n8][n3]];
            }
        }
        this.colorHash = new Acme.A();
        n8 = 0;
        for (n3 = 0; n3 < this.height; ++n3) {
            n2 = n3 * this.width;
            for (int i2 = 0; i2 < this.width; ++i2) {
                boolean bl;
                int n9 = this.rgbPixels[n3][i2];
                boolean bl2 = bl = n9 >>> 24 < 128;
                if (bl) {
                    if (n4 < 0) {
                        n4 = n8;
                        n5 = n9;
                    } else if (n9 != n5) {
                        this.rgbPixels[n3][i2] = n9 = n5;
                    }
                }
                if ((object = (A)this.colorHash.B(n9)) == null) {
                    if (n8 >= 256) {
                        throw new IOException("too many colors for a GIF");
                    }
                    object = new A(n9, 1, n8, bl);
                    ++n8;
                    this.colorHash.A(n9, object);
                    continue;
                }
                ++((A)object).D;
            }
        }
        n3 = n8 <= 2 ? 1 : (n8 <= 4 ? 2 : (n8 <= 16 ? 4 : 8));
        n2 = 1 << n3;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        object = this.colorHash.elements();
        while (object.hasMoreElements()) {
            A a2 = (A)object.nextElement();
            byArray[a2.A] = (byte)(a2.B >> 16 & 0xFF);
            byArray2[a2.A] = (byte)(a2.B >> 8 & 0xFF);
            byArray3[a2.A] = (byte)(a2.B & 0xFF);
        }
        this.GIFEncode(this.out, this.width, this.height, this.L, (byte)0, n4, n3, byArray, byArray2, byArray3);
    }

    byte GetPixel(int n2, int n3) throws IOException {
        A a2 = (A)this.colorHash.B(this.rgbPixels[n3][n2]);
        if (a2 == null) {
            throw new IOException("color not found");
        }
        return (byte)a2.A;
    }

    static void writeString(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes();
        outputStream.write(byArray);
    }

    void GIFEncode(OutputStream outputStream, int n2, int n3, boolean bl, byte by, int n4, int n5, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        this.Width = n2;
        this.Height = n3;
        this.Interlace = bl;
        int n6 = 1 << n5;
        int n7 = 0;
        int n8 = 0;
        this.CountDown = n2 * n3;
        this.Pass = 0;
        int n9 = n5 <= 1 ? 2 : n5;
        this.curx = 0;
        this.cury = 0;
        GifEncoder.writeString(outputStream, "GIF89a");
        this.Putword(n2, outputStream);
        this.Putword(n3, outputStream);
        byte by2 = -128;
        by2 = (byte)(by2 | 0x70);
        by2 = (byte)(by2 | (byte)(n5 - 1));
        this.Putbyte(by2, outputStream);
        this.Putbyte(by, outputStream);
        this.Putbyte((byte)0, outputStream);
        for (int i2 = 0; i2 < n6; ++i2) {
            this.Putbyte(byArray[i2], outputStream);
            this.Putbyte(byArray2[i2], outputStream);
            this.Putbyte(byArray3[i2], outputStream);
        }
        if (n4 != -1) {
            this.Putbyte((byte)33, outputStream);
            this.Putbyte((byte)-7, outputStream);
            this.Putbyte((byte)4, outputStream);
            this.Putbyte((byte)1, outputStream);
            this.Putbyte((byte)0, outputStream);
            this.Putbyte((byte)0, outputStream);
            this.Putbyte((byte)n4, outputStream);
            this.Putbyte((byte)0, outputStream);
        }
        this.Putbyte((byte)44, outputStream);
        this.Putword(n8, outputStream);
        this.Putword(n7, outputStream);
        this.Putword(n2, outputStream);
        this.Putword(n3, outputStream);
        if (bl) {
            this.Putbyte((byte)64, outputStream);
        } else {
            this.Putbyte((byte)0, outputStream);
        }
        this.Putbyte((byte)n9, outputStream);
        this.compress(n9 + 1, outputStream);
        this.Putbyte((byte)0, outputStream);
        this.Putbyte((byte)59, outputStream);
    }

    void BumpPixel() {
        ++this.curx;
        if (this.curx == this.Width) {
            this.curx = 0;
            if (!this.Interlace) {
                ++this.cury;
            } else {
                switch (this.Pass) {
                    case 0: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 4;
                        break;
                    }
                    case 1: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 2;
                        break;
                    }
                    case 2: {
                        this.cury += 4;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 1;
                        break;
                    }
                    case 3: {
                        this.cury += 2;
                    }
                }
            }
        }
    }

    int GIFNextPixel() throws IOException {
        if (this.CountDown == 0) {
            return -1;
        }
        --this.CountDown;
        byte by = this.GetPixel(this.curx, this.cury);
        this.BumpPixel();
        return by & 0xFF;
    }

    void Putword(int n2, OutputStream outputStream) throws IOException {
        this.Putbyte((byte)(n2 & 0xFF), outputStream);
        this.Putbyte((byte)(n2 >> 8 & 0xFF), outputStream);
    }

    void Putbyte(byte by, OutputStream outputStream) throws IOException {
        outputStream.write(by);
    }

    final int MAXCODE(int n2) {
        return (1 << n2) - 1;
    }

    void compress(int n2, OutputStream outputStream) throws IOException {
        int n3;
        int n4;
        this.g_init_bits = n2;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << n2 - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.char_init();
        int n5 = this.GIFNextPixel();
        int n6 = 0;
        for (n4 = this.hsize; n4 < 65536; n4 *= 2) {
            ++n6;
        }
        n6 = 8 - n6;
        int n7 = this.hsize;
        this.cl_hash(n7);
        this.output(this.ClearCode, outputStream);
        block1: while ((n3 = this.GIFNextPixel()) != -1) {
            int n8 = n3 << n6 ^ n5;
            n4 = (n3 << this.maxbits) + n5;
            if (this.htab[n8] == n4) {
                n5 = this.codetab[n8];
                continue;
            }
            if (this.htab[n8] >= 0) {
                int n9 = n7 - n8;
                if (n8 == 0) {
                    n9 = 1;
                }
                do {
                    if ((n8 -= n9) < 0) {
                        n8 += n7;
                    }
                    if (this.htab[n8] != n4) continue;
                    n5 = this.codetab[n8];
                    continue block1;
                } while (this.htab[n8] >= 0);
            }
            this.output(n5, outputStream);
            n5 = n3;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[n8] = n4;
                continue;
            }
            this.cl_block(outputStream);
        }
        this.output(n5, outputStream);
        this.output(this.EOFCode, outputStream);
    }

    void output(int n2, OutputStream outputStream) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= n2 << this.cur_bits) : n2;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (n2 == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outputStream);
        }
    }

    void cl_block(OutputStream outputStream) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outputStream);
    }

    void cl_hash(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.htab[i2] = -1;
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte by, OutputStream outputStream) throws IOException {
        this.accum[this.a_count++] = by;
        if (this.a_count >= 254) {
            this.flush_char(outputStream);
        }
    }

    void flush_char(OutputStream outputStream) throws IOException {
        if (this.a_count > 0) {
            outputStream.write(this.a_count);
            outputStream.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }
}

