/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.controller;

import com.gentleware.jboogie.controller.EditorHandler;
import com.gentleware.jboogie.kernel.JBoogieConfiguration;
import com.gentleware.jboogie.piccolo.nodes.L;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.Strings;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Point2D;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.GraphNodeImpl;

public class InlineEditor {
    private static final Logger J = Logger.getLogger((String)"com.gentleware.jboogie.controller.InlineEditor");
    private final JTextComponent E;
    private final DocumentListener C;
    private final Project H;
    private EditorHandler L;
    private boolean G;
    private PCanvas F;
    private GraphNodeImpl I;
    private boolean K;
    private final Action B = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            InlineEditor.this.handleCommitKeyStroke();
        }
    };
    private final Action A = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            InlineEditor.this.handleCancelKeyStroke();
        }
    };
    private JScrollPane D;

    public InlineEditor(Project project) {
        this.H = project;
        this.E = this.C();
        this.C = this.D();
    }

    protected Project getProject() {
        return this.H;
    }

    protected void handleCommitKeyStroke() {
        this.commitEditing();
    }

    protected void handleCancelKeyStroke() {
        this.cancelEditing();
    }

    private DocumentListener D() {
        DocumentListener documentListener = new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                InlineEditor.this.A();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                InlineEditor.this.A();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                InlineEditor.this.A();
            }
        };
        return documentListener;
    }

    private JTextComponent C() {
        JTextArea jTextArea = new JTextArea(){

            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                super.paint(graphics);
            }
        };
        jTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jTextArea.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                InlineEditor.this.K = false;
            }

            public void focusLost(FocusEvent focusEvent) {
                if (!InlineEditor.this.K) {
                    InlineEditor.this.commitEditing();
                }
            }
        });
        return jTextArea;
    }

    private void A() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InlineEditor.this.B();
            }
        });
    }

    private void B() {
        Rectangle rectangle = this.F.getVisibleRect();
        Dimension dimension = this.D.getPreferredSize();
        int n2 = 0;
        if (dimension.width > rectangle.width) {
            dimension.width = rectangle.width;
            JScrollBar jScrollBar = this.D.getHorizontalScrollBar();
            Dimension dimension2 = jScrollBar.getPreferredSize();
            n2 = dimension2.height;
        }
        dimension.height += n2;
        if (dimension.height > rectangle.height) {
            dimension.height = rectangle.height;
            dimension.width += this.D.getVerticalScrollBar().getPreferredSize().width;
            if (dimension.width > rectangle.width) {
                dimension.width = rectangle.width;
            }
        }
        int n3 = Math.min(this.D.getX(), rectangle.x + rectangle.width - dimension.width);
        n3 = Math.max(n3, rectangle.x);
        int n4 = Math.min(this.D.getY(), rectangle.y + rectangle.height - dimension.height);
        n4 = Math.max(n4, rectangle.y);
        this.D.setLocation(n3, n4);
        this.D.setSize(dimension);
        this.D.invalidate();
        this.D.validate();
    }

    public void startEditing(PCanvas pCanvas, EditorHandler editorHandler, GraphNodeImpl graphNodeImpl) {
        Dimension dimension;
        Point2D point2D;
        Object object;
        this.F = pCanvas;
        this.L = editorHandler;
        this.I = graphNodeImpl;
        this.E.getDocument().addDocumentListener(this.C);
        this.D = new JScrollPane(this.E);
        this.D.setBorder(BorderFactory.createEmptyBorder());
        String string = this.L.getText(this.I);
        PNode pNode = this.I.getPNode();
        Font font = this.H.getModelMapper().getRenderer(this.I).getFont(this.I);
        this.E.setFont(font);
        if (pNode instanceof L) {
            object = (L)pNode;
            object.setEditing(true);
            point2D = object.getEditorPosition();
            dimension = object.getEditorDimension();
        } else {
            pNode.setVisible(false);
            point2D = new Point2D.Double(pNode.getX(), pNode.getY());
            dimension = new Dimension((int)pNode.getWidth(), (int)pNode.getHeight());
        }
        pNode.localToGlobal(point2D);
        pCanvas.getCamera().viewToLocal(point2D);
        object = this.E.getInsets();
        dimension.width += ((Insets)object).left + ((Insets)object).right;
        dimension.height += ((Insets)object).top + ((Insets)object).bottom;
        this.D.setLocation((int)(point2D.getX() - (double)((Insets)object).left), (int)(point2D.getY() - (double)((Insets)object).top));
        this.E.setText(string);
        if (string != null) {
            this.E.setCaretPosition(string.length());
        }
        this.installKeyBindings();
        this.E.selectAll();
        pCanvas.setLayout(null);
        pCanvas.add((Component)this.D);
        Dimension dimension2 = this.D.getPreferredSize();
        int n2 = Math.max(dimension2.width, dimension.width);
        int n3 = Math.max(dimension2.height, dimension.height);
        this.D.setSize(n2, n3);
        pCanvas.repaint();
        this.E.requestFocusInWindow();
        this.G = true;
        this.E.revalidate();
    }

    protected void installKeyBindings() {
        InputMap inputMap = this.E.getInputMap();
        inputMap.put(JBoogieConfiguration.getCommitKeyStroke(), "notify-field-accept");
        KeyStroke keyStroke = JBoogieConfiguration.getNewLineKeyStroke();
        if (this.L.isMultiLine(this.I)) {
            inputMap.put(keyStroke, "insert-break");
        } else {
            inputMap.put(keyStroke, "notify-field-accept");
        }
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel-editing");
        ActionMap actionMap = this.E.getActionMap();
        actionMap.put("notify-field-accept", this.B);
        actionMap.put("cancel-editing", this.A);
    }

    public void commitEditing() {
        try {
            if (this.G) {
                String string = this.E.getText();
                boolean bl = this.L.isValidText(this.I, string);
                if (!bl) {
                    Toolkit.getDefaultToolkit().beep();
                    this.cancelEditing();
                } else {
                    if (!Strings.equals((String)Strings.noNull((String)string), (String)Strings.noNull((String)this.L.getText(this.I)))) {
                        this.L.setText(this.I, string);
                    }
                    this.cancelEditing();
                }
            }
        }
        catch (Exception exception) {
            J.error((Object)exception);
            this.cancelEditing();
        }
    }

    public void cancelEditing() {
        if (!this.G) {
            return;
        }
        if (this.F != null) {
            this.F.remove((Component)this.D);
            this.F.repaint();
        }
        this.E.getDocument().removeDocumentListener(this.C);
        PNode pNode = (PNode)this.I.getPiccoloElement();
        if (pNode instanceof L) {
            L l2 = (L)pNode;
            l2.setEditing(false);
        } else {
            pNode.setVisible(true);
        }
        this.G = false;
        this.I = null;
    }

    protected JTextComponent getEditorComponent() {
        return this.E;
    }

    protected DocumentListener getEditorDocumentListener() {
        return this.C;
    }

    protected EditorHandler getEditorHandler() {
        return this.L;
    }

    protected boolean isEditing() {
        return this.G;
    }

    protected PCanvas getCanvas() {
        return this.F;
    }

    protected void setCanvas(PCanvas pCanvas) {
        this.F = pCanvas;
    }

    protected GraphNodeImpl getEditedNode() {
        return this.I;
    }

    protected void setIgnoreFocusChanged(boolean bl) {
        this.K = bl;
    }
}

