/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.layout;

import com.gentleware.jboogie.layout.B;
import com.gentleware.jboogie.layout.LayoutStrategy;
import com.gentleware.jboogie.layout.LayoutableEdge;
import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.layout.LayoutableElements;
import com.gentleware.jboogie.layout.LayoutableNode;
import com.gentleware.jboogie.style.Style;
import com.gentleware.jboogie.util.DiMacroMemento;
import com.gentleware.jboogie.util.PointOnEdge;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.Geometry;
import com.gentleware.openapi.util.Utils;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Point2D;
import org.apache.log4j.Logger;

public class EdgeAdornmentShape
extends B {
    private static final Logger F = Logger.getLogger((String)"com.gentleware.jboogie.layout.EdgeAdornmentShape");
    private static final double G = 1.0E8;

    public EdgeAdornmentShape(Project project) {
        super(project);
    }

    public void reshapeElement(LayoutableElement layoutableElement, DiMacroMemento diMacroMemento) {
        if (!(layoutableElement instanceof LayoutableNode)) {
            throw new IllegalArgumentException("shape can only be applied to nodes");
        }
        LayoutableNode layoutableNode = (LayoutableNode)layoutableElement;
        Project project = this.getProject();
        Style style = project.getStyle();
        double d2 = style.getAdornmentAngle().get(layoutableElement);
        double d3 = style.getAdornmentDistance().get(layoutableElement);
        PointOnEdge pointOnEdge = this.getPointOnEdge(project, layoutableNode);
        this.A(layoutableNode, pointOnEdge, d3, d2, diMacroMemento);
    }

    public LayoutableEdge getEdge(LayoutableNode layoutableNode) {
        LayoutableElement layoutableElement;
        for (layoutableElement = layoutableNode; layoutableElement != null && !(layoutableElement instanceof LayoutableEdge); layoutableElement = layoutableElement.getContainerElement()) {
        }
        LayoutableEdge layoutableEdge = (LayoutableEdge)layoutableElement;
        return layoutableEdge;
    }

    public PointOnEdge getPointOnEdge(Project project, LayoutableNode layoutableNode) {
        LayoutableEdge layoutableEdge = this.getEdge(layoutableNode);
        if (layoutableEdge == null) {
            return null;
        }
        int n2 = layoutableEdge.getWaypointCount();
        Style style = this.getProject().getStyle();
        int n3 = style.getAdornmentWaypointIndex().get(layoutableNode);
        int n4 = Math.min(n3, n2 - 1);
        if ((n4 = Math.max(n4, -n2)) != n3) {
            F.warn((Object)("Edge adornment has wrong waypoint index: " + n3 + "/" + n2));
        }
        double d2 = style.getAdornmentWaypointOffset().get(layoutableNode);
        PointOnEdge pointOnEdge = new PointOnEdge(layoutableEdge, n4, d2);
        return pointOnEdge;
    }

    private void A(LayoutableNode layoutableNode, PointOnEdge pointOnEdge, double d2, double d3, DiMacroMemento diMacroMemento) {
        LayoutStrategy layoutStrategy;
        if (diMacroMemento != null) {
            diMacroMemento.add(layoutableNode.getLayoutMemento(this.getProject()));
        }
        if ((layoutStrategy = this.getProject().getLayoutValidator().getLayout(layoutableNode)) != null) {
            PBounds pBounds = layoutStrategy.getPreferredBounds(layoutableNode);
            layoutableNode.setSize(pBounds.getWidth(), pBounds.getHeight());
        }
        double d4 = this.getAngleAtPointOnEdge(pointOnEdge);
        double d5 = d4 + d3;
        Point2D point2D = pointOnEdge.getPoint();
        LayoutableElements.convertToGlobal((LayoutableElement)pointOnEdge.getEdge(), point2D);
        double d6 = point2D.getX();
        double d7 = point2D.getY();
        Point2D point2D2 = Geometry.polarToRectangular((double)d5, (double)d2, (double)d6, (double)d7);
        Point2D point2D3 = this.A(layoutableNode, point2D, d5);
        double d8 = point2D2.getX() - point2D3.getX();
        double d9 = point2D2.getY() - point2D3.getY();
        Point2D.Double double_ = new Point2D.Double(d8, d9);
        this.A(layoutableNode, double_, 1.0, d6, d7, d4, d5);
        LayoutableElements.convertFromGlobal(layoutableNode.getContainerElement(), double_);
        layoutableNode.setTranslation(((Point2D)double_).getX(), ((Point2D)double_).getY());
    }

    protected double getAngleAtPointOnEdge(PointOnEdge pointOnEdge) {
        double d2 = pointOnEdge.getTangentAngle();
        return d2;
    }

    private void A(LayoutableNode layoutableNode, Point2D point2D, double d2, double d3, double d4, double d5, double d6) {
        Point2D point2D2 = Geometry.polarToRectangular((double)d6, (double)1.0E8, (double)d3, (double)d4);
        Point2D point2D3 = Geometry.polarToRectangular((double)(d6 + Math.toRadians(180.0)), (double)1.0E8, (double)d3, (double)d4);
        double d7 = point2D2.getX();
        double d8 = point2D2.getY();
        double d9 = 0.0;
        double d10 = 0.0;
        Point2D point2D4 = this.A(layoutableNode, d7, d8, d3, d4, d5);
        double d11 = point2D.getX() + point2D4.getX();
        double d12 = point2D.getY() + point2D4.getY();
        Point2D point2D5 = this.A(d11, d12, d3, d4, d5);
        Point2D point2D6 = this.A(layoutableNode, point2D3.getX(), point2D3.getY(), d3, d4, d5);
        double d13 = point2D.getX() + point2D6.getX();
        double d14 = point2D.getY() + point2D6.getY();
        Point2D point2D7 = this.A(d13, d14, d3, d4, d5);
        if (Utils.getSign((double)point2D5.getX()) != Utils.getSign((double)point2D7.getX())) {
            double d15;
            double d16;
            double d17 = layoutableNode.getWidth();
            boolean bl = d17 > (d16 = layoutableNode.getHeight());
            double d18 = d15 = bl ? 0.0 : 1.5707963267948966;
            if (Utils.equals((double)d5, (double)d15)) {
                d15 = d5 + 1.5707963267948966;
            }
            Point2D point2D8 = Geometry.getLineIntersection((double)d11, (double)d12, (double)d15, (double)d3, (double)d4, (double)d5);
            if (bl) {
                double d19 = point2D8.getX() - d11;
                double d20 = Math.abs(d19) > d17 ? (double)Utils.getSign((double)d19) * d17 : d19;
                d9 = d20 + (double)Utils.getSign((double)d20) * d2;
            } else {
                double d21 = point2D8.getY() - d12;
                double d22 = Math.abs(d21) > d16 ? (double)Utils.getSign((double)d21) * d16 : d21;
                d10 = d22 + (double)Utils.getSign((double)d22) * d2;
            }
        }
        point2D.setLocation(point2D.getX() + d9, point2D.getY() + d10);
    }

    private Point2D A(double d2, double d3, double d4, double d5, double d6) {
        Point2D point2D = Geometry.getClosestPointOnLine((double)d4, (double)d5, (double)d6, (double)d2, (double)d3);
        double d7 = d2 - point2D.getX();
        double d8 = d3 - point2D.getY();
        Point2D.Double double_ = new Point2D.Double(d7, d8);
        return double_;
    }

    private Point2D A(LayoutableNode layoutableNode, double d2, double d3, double d4, double d5, double d6) {
        Point2D point2D = Geometry.getClosestPointOnLine((double)d4, (double)d5, (double)d6, (double)d2, (double)d3);
        return this.A(layoutableNode, d2, d3, point2D.getX(), point2D.getY());
    }

    private Point2D A(LayoutableNode layoutableNode, Point2D point2D, double d2) {
        Point2D point2D2 = Geometry.polarToRectangular((double)d2, (double)1.0E8, (double)point2D.getX(), (double)point2D.getY());
        return this.A(layoutableNode, point2D2.getX(), point2D2.getY(), point2D.getX(), point2D.getY());
    }

    private Point2D A(LayoutableNode layoutableNode, double d2, double d3, double d4, double d5) {
        Point2D point2D = LayoutableElements.getGlobalPosition(layoutableNode);
        double d6 = layoutableNode.getWidth();
        double d7 = layoutableNode.getHeight();
        double d8 = Math.sqrt(2.0);
        double d9 = d6 * d8;
        double d10 = d7 * d8;
        double d11 = d2;
        double d12 = d3;
        Point2D point2D2 = Geometry.getClosestPointOnEllipse((double)d11, (double)d12, (double)d9, (double)d10, (double)d4, (double)d5);
        double d13 = point2D2.getX() - d11;
        double d14 = point2D2.getY() - d12;
        Point2D point2D3 = layoutableNode.getClosestPointOnBorder(this.getProject(), new Point2D.Double(point2D.getX() + d6 / 2.0 + d13, point2D.getY() + d7 / 2.0 + d14));
        double d15 = point2D3.getX() - point2D.getX();
        double d16 = point2D3.getY() - point2D.getY();
        Point2D.Double double_ = new Point2D.Double(d15, d16);
        return double_;
    }
}

