/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.layout;

import com.gentleware.jboogie.layout.C;
import com.gentleware.jboogie.layout.LayoutableConnector;
import com.gentleware.jboogie.layout.LayoutableEdge;
import com.gentleware.jboogie.layout.LayoutableEdges;
import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.layout.LayoutableElements;
import com.gentleware.jboogie.layout.LayoutableNode;
import com.gentleware.jboogie.layout.LayoutableNodes;
import com.gentleware.jboogie.layout.ShapeStrategy;
import com.gentleware.jboogie.piccolo.nodes.QAssemblyConnector;
import com.gentleware.jboogie.util.DiMacroMemento;
import com.gentleware.jboogie.util.PointOnEdge;
import com.gentleware.jboogie.util.Segment;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.Strings;
import com.gentleware.openapi.util.Utils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class EdgeShape
extends ShapeStrategy {
    private static final Logger B = Logger.getLogger((String)"com.gentleware.jboogie.layout.EdgeShape");
    private static LayoutableEdge D;
    private static int C;
    private static boolean E;

    public EdgeShape(Project project) {
        super(project);
    }

    public static void setCurrentlyDraggedEdgeAndWaypoint(LayoutableEdge layoutableEdge, int n2) {
        D = layoutableEdge;
        C = n2;
    }

    public static void clearCurrentlyDraggedEdge() {
        D = null;
        C = -1;
    }

    public static void enableWaypointRemoval(boolean bl) {
        E = bl;
    }

    public void reshapeElement(LayoutableElement layoutableElement, DiMacroMemento diMacroMemento) {
        this.updateEdgeShape((LayoutableEdge)layoutableElement, diMacroMemento);
    }

    protected void updateEdgeShape(LayoutableEdge layoutableEdge, DiMacroMemento diMacroMemento) {
        boolean bl;
        if (diMacroMemento != null) {
            diMacroMemento.add(layoutableEdge.getLayoutMemento(this.getProject()));
        }
        int n2 = layoutableEdge.getWaypointCount();
        boolean bl2 = bl = layoutableEdge == D;
        if (n2 < 2) {
            if (n2 != 0) {
                B.error((Object)("Edge has " + n2 + " waypoints?!"));
            }
            this.doInitialEdgeShape(layoutableEdge);
        } else {
            boolean bl3;
            Point2D point2D = EdgeShape.getDeltaFromWaypointToConnector(layoutableEdge, true);
            Point2D point2D2 = EdgeShape.getDeltaFromWaypointToConnector(layoutableEdge, false);
            double d2 = point2D.getX();
            double d3 = point2D.getY();
            boolean bl4 = !Utils.equals((double)d2, (double)0.0) || !Utils.equals((double)d3, (double)0.0);
            double d4 = point2D2.getX();
            double d5 = point2D2.getY();
            boolean bl5 = bl3 = !Utils.equals((double)d4, (double)0.0) || !Utils.equals((double)d5, (double)0.0);
            if (bl) {
                boolean bl6;
                boolean bl7;
                boolean bl8 = bl7 = C == n2 - 2;
                if (bl7) {
                    this.A(layoutableEdge, false);
                }
                boolean bl9 = bl6 = C == 1;
                if (bl6) {
                    this.A(layoutableEdge, true);
                }
                this.updateAnchorage(layoutableEdge);
            } else if (!bl4 && !bl3) {
                EdgeShape.setEdgeEndpointsToShortestPath(layoutableEdge, this.getProject());
            } else {
                LayoutableConnector layoutableConnector = layoutableEdge.getSourceConnector();
                LayoutableConnector layoutableConnector2 = layoutableEdge.getTargetConnector();
                if (layoutableConnector == null || layoutableConnector2 == null) {
                    return;
                }
                LayoutableElement layoutableElement = layoutableConnector.getLayoutableElement();
                LayoutableElement layoutableElement2 = layoutableConnector2.getLayoutableElement();
                if (Utils.compare((double)d2, (double)d4) == 0 && Utils.compare((double)d3, (double)d5) == 0) {
                    layoutableEdge.setTranslation(layoutableEdge.getTranslateX() + d2, layoutableEdge.getTranslateY() + d3);
                } else if (layoutableElement != layoutableElement2) {
                    if (bl4 && bl3) {
                        B.debug((Object)"anchor elements moved differently");
                        EdgeShape.setEdgeEndpointsToShortestPath(layoutableEdge, this.getProject());
                    } else {
                        boolean bl10 = layoutableElement instanceof LayoutableNode;
                        boolean bl11 = layoutableElement2 instanceof LayoutableNode;
                        if (E) {
                            LayoutableNode layoutableNode;
                            if (bl4 && bl10) {
                                layoutableNode = (LayoutableNode)layoutableElement;
                                this.A(layoutableEdge, layoutableNode, 1);
                            }
                            if (bl3 && bl11) {
                                layoutableNode = (LayoutableNode)layoutableElement2;
                                this.A(layoutableEdge, layoutableNode, n2 - 2);
                            }
                        }
                        if ((n2 = layoutableEdge.getWaypointCount()) == 2) {
                            EdgeShape.setEdgeEndpointsToShortestPath(layoutableEdge, this.getProject());
                        } else {
                            if (bl4) {
                                this.A(layoutableEdge, true);
                            }
                            if (bl3) {
                                this.A(layoutableEdge, false);
                            }
                        }
                    }
                }
            }
        }
    }

    protected void updateAnchorage(LayoutableEdge layoutableEdge) {
        Collection collection = layoutableEdge.getAnchorage();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            LayoutableConnector layoutableConnector = (LayoutableConnector)iterator.next();
            LayoutableElement layoutableElement = layoutableConnector.getLayoutableElement();
            Point2D.Double double_ = new Point2D.Double(layoutableConnector.getX(), layoutableConnector.getY());
            LayoutableElements.convertToGlobal(layoutableElement, double_);
            Point2D point2D = layoutableEdge.getClosestPointOnBorder(this.getProject(), double_);
            LayoutableElements.convertFromGlobal(layoutableElement, point2D);
            layoutableConnector.setPosition(point2D.getX(), point2D.getY());
        }
    }

    protected void doInitialEdgeShape(LayoutableEdge layoutableEdge) {
        if (LayoutableEdges.isSelfEdge(layoutableEdge)) {
            this.A(layoutableEdge);
        } else {
            this.B(layoutableEdge);
        }
    }

    private void B(LayoutableEdge layoutableEdge) {
        Point2D point2D;
        Point2D point2D2;
        LayoutableConnector layoutableConnector = layoutableEdge.getSourceConnector();
        LayoutableConnector layoutableConnector2 = layoutableEdge.getTargetConnector();
        LayoutableElement layoutableElement = layoutableConnector.getLayoutableElement();
        LayoutableElement layoutableElement2 = layoutableConnector2.getLayoutableElement();
        boolean bl = layoutableElement instanceof LayoutableNode;
        boolean bl2 = layoutableElement2 instanceof LayoutableNode;
        PNode pNode = LayoutableElements.getPNode(layoutableEdge);
        boolean bl3 = pNode instanceof QAssemblyConnector;
        if (bl3) {
            layoutableEdge.setWaypoints(new Point2D[]{new Point2D.Double(), new Point2D.Double(), new Point2D.Double()});
        } else {
            layoutableEdge.setWaypoints(new Point2D[]{new Point2D.Double(), new Point2D.Double()});
        }
        if (bl && bl2) {
            LayoutableNode layoutableNode = (LayoutableNode)layoutableElement;
            LayoutableNode layoutableNode2 = (LayoutableNode)layoutableElement2;
            Segment segment = LayoutableNodes.getShortestSegmentBetweenNodes(this.getProject(), layoutableNode, layoutableNode2, true);
            point2D2 = segment.getPointA();
            point2D = segment.getPointB();
        } else if (bl && !bl2) {
            Point2D point2D3 = com.gentleware.jboogie.layout.C.A(layoutableConnector2);
            LayoutableNode layoutableNode = (LayoutableNode)layoutableElement;
            point2D2 = layoutableNode.getClosestPointOnBorder(this.getProject(), point2D3);
            LayoutableEdge layoutableEdge2 = (LayoutableEdge)layoutableElement2;
            point2D = PointOnEdge.getClosestPointOnEdge(layoutableEdge2, point2D3.getX(), point2D3.getY()).getPoint();
        } else if (bl2) {
            Point2D point2D4 = com.gentleware.jboogie.layout.C.A(layoutableConnector);
            LayoutableNode layoutableNode = (LayoutableNode)layoutableElement2;
            point2D = layoutableNode.getClosestPointOnBorder(this.getProject(), point2D4);
            LayoutableEdge layoutableEdge3 = (LayoutableEdge)layoutableElement;
            point2D2 = PointOnEdge.getClosestPointOnEdge(layoutableEdge3, point2D.getX(), point2D.getY()).getPoint();
        } else {
            LayoutableEdge layoutableEdge4 = (LayoutableEdge)layoutableElement;
            LayoutableEdge layoutableEdge5 = (LayoutableEdge)layoutableElement2;
            point2D2 = this.D(layoutableEdge4);
            point2D = PointOnEdge.getClosestPointOnEdge(layoutableEdge5, point2D2.getX(), point2D2.getY()).getPoint();
        }
        EdgeShape.A(layoutableEdge, point2D2, point2D);
        EdgeShape.setEdgeEndpointsToShortestPath(layoutableEdge, this.getProject(), bl3);
        if (bl3) {
            this.C(layoutableEdge);
        }
    }

    private Point2D D(LayoutableEdge layoutableEdge) {
        int n2 = Math.max(0, layoutableEdge.getWaypointCount() / 2 - 1);
        PointOnEdge pointOnEdge = new PointOnEdge(layoutableEdge, n2, 0.5);
        Point2D point2D = pointOnEdge.getPoint();
        LayoutableElements.convertToGlobal((LayoutableElement)layoutableEdge, point2D);
        return point2D;
    }

    private void A(LayoutableEdge layoutableEdge) {
        LayoutableNode layoutableNode = (LayoutableNode)layoutableEdge.getSourceConnector().getLayoutableElement();
        double d2 = layoutableNode.getTranslateX() + layoutableNode.getWidth();
        double d3 = layoutableNode.getTranslateY() + layoutableNode.getHeight();
        double d4 = d2 - 25.0;
        double d5 = d2 + 25.0;
        double d6 = d3 - Math.min(layoutableNode.getHeight() * 1.0 / 4.0, 20.0);
        double d7 = d6 + 40.0;
        Point2D.Double double_ = new Point2D.Double(d2, d6);
        Point2D.Double double_2 = new Point2D.Double(d5, d6);
        Point2D.Double double_3 = new Point2D.Double(d5, d7);
        Point2D.Double double_4 = new Point2D.Double(d4, d7);
        Point2D.Double double_5 = new Point2D.Double(d4, d3);
        Point2D[] point2DArray = new Point2D[]{double_, double_2, double_3, double_4, double_5};
        layoutableEdge.setWaypoints(point2DArray);
        EdgeShape.updateEdgeConnectors(layoutableEdge);
    }

    private void A(LayoutableEdge layoutableEdge, LayoutableNode layoutableNode, int n2) {
        Object object;
        int n3;
        if (layoutableEdge instanceof QAssemblyConnector && (n3 = ((QAssemblyConnector)(object = (QAssemblyConnector)layoutableEdge)).getEyeWaypointIndex()) == n2) {
            return;
        }
        object = new Point2D.Double();
        LayoutableElements.convertToGlobal((LayoutableElement)layoutableNode, (Point2D)object);
        PBounds pBounds = new PBounds(((Point2D.Double)object).getX(), ((Point2D.Double)object).getY(), layoutableNode.getWidth(), layoutableNode.getHeight());
        while (n2 > 0 && n2 < layoutableEdge.getWaypointCount() - 1) {
            Point2D.Double double_ = new Point2D.Double(layoutableEdge.getWaypointX(n2), layoutableEdge.getWaypointY(n2));
            LayoutableElements.convertToGlobal((LayoutableElement)layoutableEdge, double_);
            String string = layoutableEdge.getProperty("layout", false, "");
            if (!pBounds.contains((Point2D)double_) || !Strings.isEmpty((String)string)) break;
            layoutableEdge.removeWaypoint(n2);
        }
    }

    public static void setEdgeEndpointsToShortestPath(LayoutableEdge layoutableEdge, Project project) {
        EdgeShape.setEdgeEndpointsToShortestPath(layoutableEdge, project, false);
    }

    public static void setEdgeEndpointsToShortestPath(LayoutableEdge layoutableEdge, Project project, boolean bl) {
        Point2D point2D;
        Point2D point2D2;
        LayoutableConnector layoutableConnector = layoutableEdge.getSourceConnector();
        LayoutableConnector layoutableConnector2 = layoutableEdge.getTargetConnector();
        if (layoutableConnector == null || layoutableConnector2 == null) {
            return;
        }
        LayoutableElement layoutableElement = layoutableConnector.getLayoutableElement();
        LayoutableElement layoutableElement2 = layoutableConnector2.getLayoutableElement();
        if (layoutableElement == null || layoutableElement2 == null) {
            return;
        }
        int n2 = layoutableEdge.getWaypointCount();
        int n3 = n2 - 1;
        Point2D.Double double_ = new Point2D.Double(layoutableEdge.getWaypointX(0), layoutableEdge.getWaypointY(0));
        LayoutableElements.convertToGlobal((LayoutableElement)layoutableEdge, double_);
        Point2D.Double double_2 = new Point2D.Double(layoutableEdge.getWaypointX(n3), layoutableEdge.getWaypointY(n3));
        LayoutableElements.convertToGlobal((LayoutableElement)layoutableEdge, double_2);
        if (n2 == 2 || bl) {
            Segment segment = LayoutableNodes.getShortestSegmentBetweenNodes(project, layoutableElement, double_, layoutableElement2, double_2);
            point2D2 = segment.getPointA();
            point2D = segment.getPointB();
        } else {
            Point2D.Double double_3 = new Point2D.Double(layoutableEdge.getWaypointX(1), layoutableEdge.getWaypointY(1));
            LayoutableElements.convertToGlobal((LayoutableElement)layoutableEdge, double_3);
            point2D2 = layoutableElement.getClosestPointOnBorder(project, double_3);
            Point2D.Double double_4 = new Point2D.Double(layoutableEdge.getWaypointX(n2 - 2), layoutableEdge.getWaypointY(n2 - 2));
            LayoutableElements.convertToGlobal((LayoutableElement)layoutableEdge, double_4);
            point2D = layoutableElement2.getClosestPointOnBorder(project, double_4);
            if (layoutableElement instanceof LayoutableNode) {
                point2D2 = LayoutableNodes.clipAtAdornments(project, (LayoutableNode)layoutableElement, point2D2, double_3);
            }
            if (layoutableElement2 instanceof LayoutableNode) {
                point2D = LayoutableNodes.clipAtAdornments(project, (LayoutableNode)layoutableElement2, point2D, double_4);
            }
        }
        EdgeShape.A(layoutableEdge, point2D2, point2D);
    }

    private static void A(LayoutableEdge layoutableEdge, Point2D point2D, Point2D point2D2) {
        int n2 = layoutableEdge.getWaypointCount() - 1;
        LayoutableElements.convertFromGlobal((LayoutableElement)layoutableEdge, point2D);
        LayoutableElements.convertFromGlobal((LayoutableElement)layoutableEdge, point2D2);
        layoutableEdge.setWaypoint(0, point2D.getX(), point2D.getY());
        layoutableEdge.setWaypoint(n2, point2D2.getX(), point2D2.getY());
        EdgeShape.updateEdgeConnectors(layoutableEdge);
    }

    private void C(LayoutableEdge layoutableEdge) {
        Point2D.Double double_ = new Point2D.Double(layoutableEdge.getWaypointX(0), layoutableEdge.getWaypointY(0));
        Point2D.Double double_2 = new Point2D.Double(layoutableEdge.getWaypointX(layoutableEdge.getWaypointCount() - 1), layoutableEdge.getWaypointY(layoutableEdge.getWaypointCount() - 1));
        double d2 = ((Point2D)double_).getX();
        double d3 = ((Point2D)double_2).getX();
        double d4 = ((Point2D)double_).getY();
        double d5 = ((Point2D)double_2).getY();
        double d6 = d2 + (d3 - d2) / 2.0;
        double d7 = d4 + (d5 - d4) / 2.0;
        Point2D.Double double_3 = new Point2D.Double(d6, d7);
        layoutableEdge.setWaypoint(1, ((Point2D)double_3).getX(), ((Point2D)double_3).getY());
    }

    private void A(LayoutableEdge layoutableEdge, boolean bl) {
        int n2 = layoutableEdge.getWaypointCount();
        int n3 = bl ? 0 : n2 - 1;
        int n4 = bl ? 1 : n2 - 2;
        LayoutableConnector layoutableConnector = bl ? layoutableEdge.getSourceConnector() : layoutableEdge.getTargetConnector();
        LayoutableElement layoutableElement = layoutableConnector.getLayoutableElement();
        if (layoutableElement != null) {
            double d2 = layoutableEdge.getWaypointX(n4);
            double d3 = layoutableEdge.getWaypointY(n4);
            Point2D.Double double_ = new Point2D.Double(d2, d3);
            LayoutableElements.convertToGlobal((LayoutableElement)layoutableEdge, double_);
            Point2D point2D = layoutableElement.getClosestPointOnBorder(this.getProject(), double_);
            if (layoutableElement instanceof LayoutableNode) {
                LayoutableNode layoutableNode = (LayoutableNode)layoutableElement;
                point2D = LayoutableNodes.clipAtAdornments(this.getProject(), layoutableNode, point2D, double_);
            }
            LayoutableElements.convertFromGlobal((LayoutableElement)layoutableEdge, point2D);
            layoutableEdge.setWaypoint(n3, point2D.getX(), point2D.getY());
            EdgeShape.updateEdgeConnector(layoutableEdge, bl);
        }
    }

    protected static void updateEdgeConnectors(LayoutableEdge layoutableEdge) {
        EdgeShape.updateEdgeConnector(layoutableEdge, true);
        EdgeShape.updateEdgeConnector(layoutableEdge, false);
    }

    protected static void updateEdgeConnector(LayoutableEdge layoutableEdge, boolean bl) {
        int n2 = layoutableEdge.getWaypointCount();
        int n3 = bl ? 0 : n2 - 1;
        Point2D.Double double_ = new Point2D.Double(layoutableEdge.getWaypointX(n3), layoutableEdge.getWaypointY(n3));
        LayoutableConnector layoutableConnector = bl ? layoutableEdge.getSourceConnector() : layoutableEdge.getTargetConnector();
        LayoutableElement layoutableElement = layoutableConnector.getLayoutableElement();
        LayoutableElements.convertPosition(double_, layoutableEdge, layoutableElement);
        layoutableConnector.setPosition(((Point2D)double_).getX(), ((Point2D)double_).getY());
    }

    public static Point2D getDeltaFromWaypointToConnector(LayoutableEdge layoutableEdge, boolean bl) {
        LayoutableConnector layoutableConnector;
        int n2 = bl ? 0 : layoutableEdge.getWaypointCount() - 1;
        double d2 = layoutableEdge.getWaypointX(n2);
        double d3 = layoutableEdge.getWaypointY(n2);
        Point2D.Double double_ = new Point2D.Double(d2, d3);
        LayoutableElements.convertToGlobal((LayoutableElement)layoutableEdge, double_);
        LayoutableConnector layoutableConnector2 = layoutableConnector = bl ? layoutableEdge.getSourceConnector() : layoutableEdge.getTargetConnector();
        if (layoutableConnector == null) {
            return new Point2D.Double(0.0, 0.0);
        }
        LayoutableElement layoutableElement = layoutableConnector.getLayoutableElement();
        double d4 = layoutableConnector.getX();
        double d5 = layoutableConnector.getY();
        Point2D.Double double_2 = new Point2D.Double(d4, d5);
        LayoutableElements.convertToGlobal(layoutableElement, double_2);
        Point2D.Double double_3 = new Point2D.Double(((Point2D)double_2).getX() - ((Point2D)double_).getX(), ((Point2D)double_2).getY() - ((Point2D)double_).getY());
        return double_3;
    }

    public static LayoutableEdge getCurrentlyDraggedEdge() {
        return D;
    }

    static {
        E = true;
    }
}

