/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.layout;

import com.gentleware.jboogie.layout.LayoutStrategy;
import com.gentleware.jboogie.layout.LayoutX;
import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.layout.LayoutableNode;
import com.gentleware.jboogie.model_management.SimpleTypeInfo;
import com.gentleware.jboogie.util.DiMacroMemento;
import com.gentleware.openapi.jboogie.Project;
import edu.umd.cs.piccolo.util.PBounds;
import java.util.Iterator;
import java.util.List;

public class EllipseVerticalLayout
extends LayoutStrategy {
    private double O;
    private final LayoutX P;
    private final double Q = Math.sqrt(2.0);

    public EllipseVerticalLayout(Project project, double d2, LayoutX layoutX) {
        super(project);
        this.O = d2;
        this.P = layoutX;
    }

    public void reshapeElements(LayoutableElement layoutableElement, List list, DiMacroMemento diMacroMemento) {
        if (!(layoutableElement instanceof LayoutableNode)) {
            throw new IllegalArgumentException("EllipseFillLayout can only be used with Nodes!");
        }
        LayoutableNode layoutableNode = (LayoutableNode)layoutableElement;
        double d2 = this.getPreferredBoundsImpl((LayoutableElement)layoutableElement, (List)list).height / this.Q;
        double d3 = (layoutableNode.getHeight() - d2) / 2.0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            double d4;
            double d5;
            LayoutableElement layoutableElement2 = (LayoutableElement)list.get(i2);
            LayoutableNode layoutableNode2 = (LayoutableNode)layoutableElement2;
            LayoutStrategy layoutStrategy = this.getLayout(layoutableNode2);
            PBounds pBounds = layoutStrategy.getPreferredBounds(layoutableNode2);
            double d6 = layoutableNode.getWidth();
            double d7 = layoutableNode.getHeight() - d3;
            double d8 = d6 / this.Q;
            d8 = Math.min(d8, pBounds.getWidth());
            SimpleTypeInfo simpleTypeInfo = layoutableNode2.getSimpleTypeInfo(this.getProject());
            if (SimpleTypeInfo.COMPARTMENT_SEPARATOR.equals(simpleTypeInfo)) {
                d5 = layoutableNode.getWidth() / 2.0;
                d4 = layoutableNode.getHeight() / 2.0;
                double d9 = d4 - d3;
                double d10 = Math.asin(d9 /= d4);
                double d11 = Math.cos(d10);
                d8 = d11 * d5 * 2.0;
            }
            d5 = Math.min(d7 / this.Q, pBounds.getHeight());
            d5 = Math.max(d5, 1.0);
            d4 = 0.0;
            if (this.P == LayoutX.RIGHT) {
                d4 = d6 - d8;
            }
            if (this.P == LayoutX.CENTER) {
                d4 = (d6 - d8) / 2.0;
            }
            if (this.P == LayoutX.FILL) {
                d8 = d6;
            }
            LayoutableNode layoutableNode3 = (LayoutableNode)list.get(i2);
            this.setNodeShape(layoutableNode3, d4, d3, d8, d5, diMacroMemento);
            d3 += d5;
        }
    }

    protected PBounds getPreferredBoundsImpl(LayoutableElement layoutableElement, List list) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (layoutableElement instanceof LayoutableNode) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                LayoutableElement layoutableElement2 = (LayoutableElement)iterator.next();
                LayoutStrategy layoutStrategy = this.getLayout(layoutableElement2);
                PBounds pBounds = layoutStrategy.getPreferredBounds(layoutableElement2);
                double d4 = (pBounds.getWidth() + 2.0 * this.O) * this.Q;
                double d5 = (pBounds.getHeight() + 2.0 * this.O) * this.Q;
                d2 = Math.max(d2, d4);
                d3 += d5;
            }
        }
        return new PBounds(0.0, 0.0, d2, d3);
    }
}

