/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.layout;

import com.gentleware.jboogie.factory.ModelMapper;
import com.gentleware.jboogie.layout.LayoutValidator;
import com.gentleware.jboogie.layout.LayoutableEdge;
import com.gentleware.jboogie.layout.LayoutableEdges;
import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.layout.LayoutableNode;
import com.gentleware.jboogie.layout.LayoutableNodes;
import com.gentleware.jboogie.layout.NodeAdornmentShape;
import com.gentleware.jboogie.layout.ShapeStrategy;
import com.gentleware.jboogie.model_management.SimpleTypeInfo;
import com.gentleware.jboogie.piccolo.nodes.QStyledText;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.Utils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramElementImpl;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramImpl;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.GraphElementImpl;

public final class LayoutableElements {
    private static final Logger A = Logger.getLogger((String)"com.gentleware.jboogie.layout.LayoutableElements");

    private LayoutableElements() {
    }

    public static LayoutableElement findContainedWithTypeInfo(Project project, LayoutableElement layoutableElement, SimpleTypeInfo simpleTypeInfo) {
        return LayoutableElements.A(project, layoutableElement, simpleTypeInfo, true);
    }

    private static LayoutableElement A(Project project, LayoutableElement layoutableElement, SimpleTypeInfo simpleTypeInfo, boolean bl) {
        LayoutableElement layoutableElement2 = null;
        SimpleTypeInfo simpleTypeInfo2 = layoutableElement.getSimpleTypeInfo(project);
        if (Utils.equals((Object)simpleTypeInfo2, (Object)simpleTypeInfo)) {
            layoutableElement2 = layoutableElement;
        } else if (!bl && layoutableElement.getSmElement(project, false) != null) {
            return null;
        }
        List list = layoutableElement.getContainedElements();
        Iterator iterator = list.iterator();
        while (layoutableElement2 == null && iterator.hasNext()) {
            LayoutableElement layoutableElement3 = (LayoutableElement)iterator.next();
            layoutableElement2 = LayoutableElements.A(project, layoutableElement3, simpleTypeInfo, false);
        }
        return layoutableElement2;
    }

    public static Point2D getGlobalPosition(LayoutableElement layoutableElement) {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        LayoutableElement layoutableElement2 = layoutableElement;
        if (layoutableElement2 == null) {
            Utils.logErrorOrThrow((Logger)A, (Object)"getGlobalPosition called with null parameter. Returning 0,0.");
            return double_;
        }
        do {
            double d2 = layoutableElement2.getTranslateX();
            double d3 = layoutableElement2.getTranslateY();
            ((Point2D)double_).setLocation(((Point2D)double_).getX() + d2, ((Point2D)double_).getY() + d3);
        } while ((layoutableElement2 = layoutableElement2.getContainerElement()) != null);
        return double_;
    }

    public static void convertFromGlobal(LayoutableElement layoutableElement, Point2D point2D) {
        LayoutableElement layoutableElement2 = layoutableElement;
        do {
            double d2 = layoutableElement2.getTranslateX();
            double d3 = layoutableElement2.getTranslateY();
            point2D.setLocation(point2D.getX() - d2, point2D.getY() - d3);
        } while ((layoutableElement2 = layoutableElement2.getContainerElement()) != null);
    }

    public static void convertFromGlobal(LayoutableElement layoutableElement, PBounds pBounds) {
        Point2D point2D = pBounds.getOrigin();
        LayoutableElements.convertFromGlobal(layoutableElement, point2D);
        pBounds.setOrigin(point2D.getX(), point2D.getY());
    }

    public static PBounds getGlobalBounds(LayoutableElement layoutableElement) {
        if (layoutableElement instanceof LayoutableNode) {
            return LayoutableNodes.getGlobalBounds((LayoutableNode)layoutableElement);
        }
        return LayoutableEdges.getGlobalBounds((LayoutableEdge)layoutableElement);
    }

    public static PBounds getLocalBounds(LayoutableElement layoutableElement) {
        if (layoutableElement instanceof LayoutableNode) {
            return LayoutableNodes.getLocalBounds((LayoutableNode)layoutableElement);
        }
        return LayoutableEdges.getLocalBounds((LayoutableEdge)layoutableElement);
    }

    public static void convertToGlobal(LayoutableElement layoutableElement, Point2D point2D) {
        Point2D point2D2 = LayoutableElements.getGlobalPosition(layoutableElement);
        point2D.setLocation(point2D.getX() + point2D2.getX(), point2D.getY() + point2D2.getY());
    }

    public static void convertPosition(Point2D point2D, LayoutableElement layoutableElement, LayoutableElement layoutableElement2) {
        LayoutableElements.convertToGlobal(layoutableElement, point2D);
        LayoutableElements.convertFromGlobal(layoutableElement2, point2D);
    }

    public static void convertToGlobal(LayoutableElement layoutableElement, PBounds pBounds) {
        Point2D point2D = pBounds.getOrigin();
        LayoutableElements.convertToGlobal(layoutableElement, point2D);
        pBounds.x = point2D.getX();
        pBounds.y = point2D.getY();
    }

    public static boolean shouldConnectToAdornment(Project project, LayoutableElement layoutableElement) {
        LayoutableElement layoutableElement2 = layoutableElement;
        LayoutValidator layoutValidator = project.getLayoutValidator();
        ShapeStrategy shapeStrategy = layoutValidator.getShape(layoutableElement);
        if (layoutableElement instanceof DiagramElementImpl) {
            DiagramElementImpl diagramElementImpl = (DiagramElementImpl)layoutableElement;
            layoutableElement2 = (LayoutableElement)diagramElementImpl.getPNode();
        }
        boolean bl = true;
        if (layoutableElement2 instanceof QStyledText) {
            QStyledText qStyledText = (QStyledText)layoutableElement2;
            String string = qStyledText.getText();
            boolean bl2 = bl = !string.equals("");
        }
        boolean bl3 = shapeStrategy != null ? shapeStrategy.useAdornmentForConnection() && layoutableElement.isVisible() && bl : false;
        return bl3;
    }

    public static boolean isNodeAdornment(Project project, LayoutableElement layoutableElement) {
        ShapeStrategy shapeStrategy = project.getLayoutValidator().getShape(layoutableElement);
        boolean bl = shapeStrategy instanceof NodeAdornmentShape;
        return bl;
    }

    public static DiagramElementImpl getDiElement(Project project, LayoutableElement layoutableElement) {
        if (layoutableElement instanceof DiagramElementImpl) {
            DiagramElementImpl diagramElementImpl = (DiagramElementImpl)layoutableElement;
            return diagramElementImpl;
        }
        if (layoutableElement instanceof PNode) {
            PNode pNode = (PNode)layoutableElement;
            DiagramElementImpl diagramElementImpl = project.getModelMapper().getDiElement(pNode);
            return diagramElementImpl;
        }
        return null;
    }

    public static PNode getPNode(LayoutableElement layoutableElement) {
        PNode pNode;
        if (layoutableElement instanceof PNode) {
            pNode = (PNode)layoutableElement;
        } else if (layoutableElement instanceof DiagramElementImpl) {
            DiagramElementImpl diagramElementImpl = (DiagramElementImpl)layoutableElement;
            pNode = (PNode)diagramElementImpl.getPiccoloElement();
        } else {
            throw new IllegalStateException("Container is neither MDR nor Piccolo!");
        }
        return pNode;
    }

    public static DiagramImpl getDiagram(Project project, LayoutableElement layoutableElement) {
        DiagramImpl diagramImpl;
        ModelMapper modelMapper = project.getModelMapper();
        if (layoutableElement instanceof PNode) {
            PNode pNode = (PNode)layoutableElement;
            GraphElementImpl graphElementImpl = (GraphElementImpl)modelMapper.getDiElement(pNode);
            diagramImpl = graphElementImpl.getDiagram();
        } else {
            GraphElementImpl graphElementImpl = (GraphElementImpl)layoutableElement;
            diagramImpl = graphElementImpl.getDiagram();
        }
        return diagramImpl;
    }
}

