/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.layout;

import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.layout.LayoutableElements;
import com.gentleware.jboogie.layout.LayoutableNode;
import com.gentleware.jboogie.layout.LayoutableNodes;
import com.gentleware.jboogie.style.Style;
import com.gentleware.jboogie.util.Segment;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.Geometry;
import java.awt.geom.Point2D;

public class NodeAdornmentLocator {
    public Point2D getAdornmentLocation(Project project, LayoutableElement layoutableElement, LayoutableNode layoutableNode) {
        LayoutableNode layoutableNode2 = (LayoutableNode)layoutableElement;
        double d2 = layoutableNode2.getWidth();
        double d3 = layoutableNode2.getHeight();
        double d4 = layoutableNode.getWidth();
        double d5 = layoutableNode.getHeight();
        Style style = project.getStyle();
        double d6 = style.getAdornmentDistance().get(layoutableNode);
        double d7 = style.getAdornmentAngle().get(layoutableNode);
        double d8 = d2 * style.getAnchorX().get(layoutableNode);
        double d9 = d3 * style.getAnchorY().get(layoutableNode);
        double d10 = d4 * style.getAdornmentX().get(layoutableNode);
        double d11 = d5 * style.getAdornmentY().get(layoutableNode);
        Point2D point2D = Geometry.polarToRectangular((double)d7, (double)d6, (double)d8, (double)d9);
        point2D.setLocation(point2D.getX() - d10, point2D.getY() - d11);
        return point2D;
    }

    public void handleAdornmentMoved(Project project, LayoutableElement layoutableElement, LayoutableNode layoutableNode) {
        LayoutableNode layoutableNode2 = (LayoutableNode)layoutableElement;
        Segment segment = LayoutableNodes.getShortestSegmentBetweenNodes(project, layoutableNode2, layoutableNode, false);
        Point2D point2D = segment.getPointA();
        Point2D point2D2 = segment.getPointB();
        double d2 = Geometry.getAngleBetween((Point2D)point2D, (Point2D)point2D2);
        double d3 = Geometry.getDistanceBetween((Point2D)point2D, (Point2D)point2D2);
        this.convertGlobalAbsolutePointToLocalRelativePoint(point2D, layoutableNode2);
        this.convertGlobalAbsolutePointToLocalRelativePoint(point2D2, layoutableNode);
        double d4 = point2D.getX();
        double d5 = point2D.getY();
        double d6 = point2D2.getX();
        double d7 = point2D2.getY();
        Style style = project.getStyle();
        style.getAnchorX().set(layoutableNode, d4);
        style.getAnchorY().set(layoutableNode, d5);
        style.getAdornmentX().set(layoutableNode, d6);
        style.getAdornmentY().set(layoutableNode, d7);
        style.getAdornmentDistance().set(layoutableNode, d3);
        style.getAdornmentAngle().set(layoutableNode, d2);
    }

    protected void convertGlobalAbsolutePointToLocalRelativePoint(Point2D point2D, LayoutableNode layoutableNode) {
        LayoutableElements.convertFromGlobal((LayoutableElement)layoutableNode, point2D);
        double d2 = layoutableNode.getWidth();
        double d3 = layoutableNode.getHeight();
        double d4 = point2D.getX() / d2;
        double d5 = point2D.getY() / d3;
        point2D.setLocation(d4, d5);
    }

    protected void convertLocalRelativePointToGlobalAbsolutePoint(Point2D point2D, LayoutableNode layoutableNode) {
        double d2 = layoutableNode.getWidth();
        double d3 = layoutableNode.getHeight();
        double d4 = point2D.getX() * d2;
        double d5 = point2D.getY() * d3;
        point2D.setLocation(d4, d5);
        LayoutableElements.convertToGlobal((LayoutableElement)layoutableNode, point2D);
    }
}

