/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.piccolo.nodes;

import com.gentleware.jboogie.layout.LayoutableEdge;
import com.gentleware.jboogie.layout.LayoutableElements;
import com.gentleware.jboogie.layout.LayoutableNode;
import com.gentleware.jboogie.piccolo.E;
import com.gentleware.jboogie.piccolo.nodes.QNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PBallSocket
extends QNode {
    protected static final int GAP_BETWEEN_BALL_AND_SOCKET = 4;
    public static final int BALL = 0;
    public static final int SOCKET = 1;
    public static final int BALL_SOCKET = 2;
    public static final int COMPONENT_SOCKET = 3;
    private int \u0105;
    private Arc2D \u0104;
    private Ellipse2D \u0107;
    private LayoutableEdge \u0106;

    public PBallSocket(LayoutableEdge layoutableEdge) {
        this(layoutableEdge, null);
    }

    public PBallSocket(LayoutableEdge layoutableEdge, Rectangle2D rectangle2D) {
        super(new E(0));
        this.\u0106 = layoutableEdge;
        this.\u0104 = new Arc2D.Double();
        this.\u0104.setAngleExtent(180.0);
        this.\u0104.setArcType(0);
        this.\u0104.setAngleStart(this.calculateStartAngle());
        this.\u0107 = new Ellipse2D.Double();
        this.setStroke(new BasicStroke());
        this.setStrokePaint(Color.black);
        if (rectangle2D == null) {
            this.setBounds(0.0, 0.0, 25.0, 25.0);
        } else {
            this.setBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
    }

    protected void updatePath() {
        E e2 = this.getPath();
        e2.B();
        switch (this.\u0105) {
            case 2: {
                e2.A(this.getBall(), false);
            }
            case 1: 
            case 3: {
                e2.A(this.\u0104, false);
                e2.A(this.\u0104, false);
                break;
            }
            default: {
                e2.A(this.getBall(), false);
            }
        }
    }

    private Rectangle2D C(double d2, double d3, double d4, double d5) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2 - d4, d3 - d5, 2.0 * d4, 2.0 * d5);
        return double_;
    }

    public Arc2D getSocket() {
        return this.\u0104;
    }

    protected E getPath() {
        return (E)this.getShapeReference();
    }

    public boolean setBounds(double d2, double d3, double d4, double d5) {
        if (super.setBounds(d2, d3, d4, d5)) {
            double d6 = d4 / 2.0;
            double d7 = d5 / 2.0;
            double d8 = d2 + d6;
            double d9 = d3 + d7;
            Rectangle2D rectangle2D = this.C(d8, d9, d6, d7);
            this.\u0104.setFrame(rectangle2D);
            this.updateRotation();
            Rectangle2D rectangle2D2 = this.C(d8, d9, d6 - 4.0, d7 - 4.0);
            this.getBall().setFrame(rectangle2D2);
            this.updatePath();
            return true;
        }
        return false;
    }

    protected void updateRotation() {
        double d2 = Math.toDegrees(this.calculateStartAngle());
        this.\u0104.setAngleStart(d2);
    }

    public void setType(int n2) {
        this.\u0105 = n2;
        this.updatePath();
    }

    public void setRotationEdge(LayoutableEdge layoutableEdge) {
        this.\u0106 = layoutableEdge;
        this.updateRotation();
        this.updatePath();
    }

    public void setTranslation(double d2, double d3) {
        super.setTranslation(d2, d3);
        this.updateRotation();
        this.updatePath();
    }

    protected double calculateStartAngle() {
        if (this.\u0106 != null) {
            double d2;
            double d3;
            int n2 = this.\u0106.getWaypointCount();
            Point2D.Double double_ = new Point2D.Double();
            LayoutableElements.convertPosition(double_, this, this.\u0106);
            double d4 = ((Point2D)double_).getX();
            double d5 = ((Point2D)double_).getY();
            if (n2 > 0) {
                int n3 = this.getSourceWaypointIndex();
                int n4 = this.getTargetWaypointIndex();
                d3 = this.\u0106.getWaypointX(n3);
                d2 = this.\u0106.getWaypointY(n3);
                d4 = this.\u0106.getWaypointX(n4);
                d5 = this.\u0106.getWaypointY(n4);
            } else {
                LayoutableNode layoutableNode = (LayoutableNode)this.\u0106.getSourceConnector().getLayoutableElement();
                Point2D.Double double_2 = new Point2D.Double();
                LayoutableElements.convertPosition(double_2, layoutableNode, this.\u0106);
                d3 = double_2.getX();
                d2 = double_2.getY();
            }
            double d6 = d5 - d2;
            double d7 = d4 - d3;
            double d8 = Math.atan(d7 / d6);
            if (d5 < d2) {
                d8 = Math.PI + d8;
            }
            if (this.\u0105 == 3 || this.\u0105 == 2) {
                if (d6 == 0.0) {
                    d8 = d7 <= 0.0 ? -1.5707963267948966 : 1.5707963267948966;
                }
                if (this.\u0105 == 3) {
                    d8 = Math.PI + d8;
                }
            }
            return d8;
        }
        return 0.0;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.getBoundsReference().intersects(rectangle2D);
    }

    public LayoutableEdge getRotationEdge() {
        return this.\u0106;
    }

    protected int getSourceWaypointIndex() {
        return this.\u0106.getWaypointCount() - 2;
    }

    protected int getTargetWaypointIndex() {
        return this.\u0106.getWaypointCount() - 1;
    }

    public Ellipse2D getBall() {
        return this.\u0107;
    }
}

