/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.piccolo.nodes;

import com.gentleware.jboogie.piccolo.nodes._;
import com.gentleware.jboogie.util.JBoogieUtils;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class PShape
extends _ {
    public static final String PROPERTY_STROKE_PAINT = "strokePaint";
    public static final String PROPERTY_STROKE = "stroke";
    public static final String PROPERTY_SHAPE = "shape";
    private static final BasicStroke G = new BasicStroke();
    private transient Shape E;
    private transient Stroke D;
    private Paint F;

    public PShape(Shape shape) {
        this.setStroke(G);
        this.setStrokePaint(Color.black);
        this.E = shape;
    }

    public Shape getShapeReference() {
        return this.E;
    }

    public void setShape(Shape shape) {
        this.E = shape;
        this.handleShapeUpdated();
    }

    protected void handleShapeUpdated() {
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_SHAPE, null, this.E);
    }

    protected void updateBoundsFromShape() {
        Rectangle2D rectangle2D = this.getShapeBoundsWithStroke();
        this.setBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Paint getStrokePaint() {
        return this.F;
    }

    public void setStrokePaint(Paint paint) {
        Paint paint2 = this.F;
        this.F = paint;
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_STROKE_PAINT, paint2, this.F);
    }

    public Stroke getStroke() {
        return this.D;
    }

    public void setStroke(Stroke stroke) {
        Stroke stroke2 = this.D;
        this.D = stroke;
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_STROKE, stroke2, this.D);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        if (super.intersects(rectangle2D)) {
            if (this.getPaint() != null && this.E.intersects(rectangle2D)) {
                return true;
            }
            if (this.D != null && this.F != null) {
                return this.D.createStrokedShape(this.E).intersects(rectangle2D);
            }
        }
        return false;
    }

    public Rectangle2D getShapeBoundsWithStroke() {
        if (this.D != null) {
            Shape shape = this.D.createStrokedShape(this.E);
            return shape.getBounds2D();
        }
        return this.E.getBounds2D();
    }

    protected void paint(PPaintContext pPaintContext) {
        Paint paint = this.getPaint();
        Graphics2D graphics2D = pPaintContext.getGraphics();
        Paint paint2 = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(this.E);
        }
        if (this.D != null && this.F != null) {
            graphics2D.setPaint(this.F);
            graphics2D.setStroke(this.D);
            graphics2D.draw(this.E);
        }
        graphics2D.setPaint(paint2);
        graphics2D.setStroke(stroke);
    }

    protected String getParamString() {
        StringBuffer stringBuffer = new StringBuffer();
        Point2D point2D = this.getOffset();
        if (point2D != null) {
            stringBuffer.append("offset=(");
            stringBuffer.append(point2D.getX());
            stringBuffer.append(", ");
            stringBuffer.append(point2D.getY());
            stringBuffer.append(")");
        }
        stringBuffer.append(", shape=" + this.E);
        if (this.E != null) {
            stringBuffer.append(", shape.bounds={");
            stringBuffer.append(this.E.getBounds());
            stringBuffer.append("}");
        }
        return new String(stringBuffer);
    }

    public String toString() {
        return JBoogieUtils.getShortInstanceId((Object)this) + "[" + this.getParamString() + "]";
    }
}

