/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.piccolo.nodes;

import com.gentleware.jboogie.factory.ModelMapper;
import com.gentleware.jboogie.piccolo.E;
import com.gentleware.jboogie.piccolo.nodes.PBallSocketForAssemblyConnector;
import com.gentleware.jboogie.piccolo.nodes.PFilledEllipse;
import com.gentleware.jboogie.piccolo.nodes.QConnector;
import com.gentleware.jboogie.piccolo.nodes.QEdge;
import com.gentleware.jboogie.renderer.Renderer;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.Geometry;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramElementImpl;

public class QAssemblyConnector
extends QEdge {
    private PBallSocketForAssemblyConnector \u00d6;
    private Project \u00d5;
    public static String EYE_WAYPOINT_DI_PROPERTY_NAME = "eyeWaypoint";
    public static String EYE_WAYPOINT_DI_PROPERTY_DEFAULT_VALUE = "1";
    private PFilledEllipse \u00d8;
    private int \u00d4;

    public QAssemblyConnector(Project project, QConnector qConnector, QConnector qConnector2, boolean bl) {
        super(qConnector, qConnector2, bl);
        this.\u00d5 = project;
        this.\u00d6 = new PBallSocketForAssemblyConnector(this);
        Ellipse2D ellipse2D = this.\u00d6.getBall();
        Rectangle rectangle = ellipse2D.getBounds();
        this.\u00d8 = new PFilledEllipse(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), 0.9);
        this.setEyeWaypointIndex(Integer.valueOf(EYE_WAYPOINT_DI_PROPERTY_DEFAULT_VALUE));
    }

    public void addWaypoint(int n2, double d2, double d3) {
        super.addWaypoint(n2, d2, d3);
        int n3 = this.getEyeWaypointIndex();
        if (n2 <= n3) {
            this.setEyeWaypointIndex(++n3);
        }
    }

    public void removeWaypoint(int n2) {
        int n3 = this.getEyeWaypointIndex();
        if (n2 != n3) {
            super.removeWaypoint(n2);
            if (n2 < n3) {
                this.setEyeWaypointIndex(--n3);
            }
        }
    }

    public int getEyeWaypointIndex() {
        return this.\u00d4;
    }

    public void setEyeWaypointIndex(int n2) {
        this.\u00d4 = n2;
    }

    private void O() {
        DiagramElementImpl diagramElementImpl = this.N();
        if (diagramElementImpl != null) {
            diagramElementImpl.setProperty(this.\u00d5, EYE_WAYPOINT_DI_PROPERTY_NAME, String.valueOf(this.getEyeWaypointIndex()));
        }
    }

    private DiagramElementImpl N() {
        ModelMapper modelMapper = this.\u00d5.getModelMapper();
        DiagramElementImpl diagramElementImpl = modelMapper.getDiElement(this);
        return diagramElementImpl;
    }

    protected void draw(E e2, Point2D[] point2DArray) {
        if (point2DArray.length > 0) {
            Object object;
            e2.A(point2DArray[0].getX(), point2DArray[0].getY());
            for (int i2 = 1; i2 < point2DArray.length; ++i2) {
                int n2 = this.getEyeWaypointIndex();
                if (n2 < this.getWaypointCount()) {
                    object = this.\u00d6.getBounds();
                    double d2 = object.getWidth();
                    double d3 = object.getHeight();
                    double d4 = this.getWaypointX(n2) - d2 / 2.0;
                    double d5 = this.getWaypointY(n2) - d3 / 2.0;
                    this.\u00d6.setBounds(d4, d5, d2, d3);
                    if (i2 == n2) {
                        Ellipse2D ellipse2D = this.\u00d6.getBall();
                        Rectangle rectangle = ellipse2D.getBounds();
                        Point2D point2D = Geometry.getClosestPointOnEllipse((double)ellipse2D.getCenterX(), (double)ellipse2D.getCenterY(), (double)(rectangle.getWidth() / 2.0), (double)(rectangle.getHeight() / 2.0), (double)point2DArray[i2 - 1].getX(), (double)point2DArray[i2 - 1].getY());
                        e2.B(point2D.getX(), point2D.getY());
                        if (point2DArray.length <= i2 + 1) continue;
                        point2D = Geometry.getClosestPointOnEllipse((double)ellipse2D.getCenterX(), (double)ellipse2D.getCenterY(), (double)(rectangle.getWidth() / 2.0 + 4.0), (double)(rectangle.getHeight() / 2.0 + 4.0), (double)point2DArray[i2 + 1].getX(), (double)point2DArray[i2 + 1].getY());
                        e2.A(point2D.getX(), point2D.getY());
                        continue;
                    }
                    e2.B(point2DArray[i2].getX(), point2DArray[i2].getY());
                    continue;
                }
                e2.B(point2DArray[i2].getX(), point2DArray[i2].getY());
            }
            this.\u00d6.updateRotation();
            this.\u00d6.updatePath();
            E e3 = (E)this.\u00d6.getShapeReference();
            e2.A(e3, false);
            Ellipse2D ellipse2D = this.\u00d6.getBall();
            object = ellipse2D.getBounds();
            this.\u00d8.setBounds((Rectangle2D)object);
        }
    }

    protected void paint(PPaintContext pPaintContext) {
        super.paint(pPaintContext);
        DiagramElementImpl diagramElementImpl = this.\u00d5.getModelMapper().getDiElement(this);
        Renderer renderer = this.\u00d5.getRendererFactory().getRenderer(diagramElementImpl);
        Color color = renderer.getFillColor(diagramElementImpl);
        this.\u00d8.paint(pPaintContext, color);
    }

    public void transferToDi(Project project) {
        super.transferToDi(project);
        this.O();
    }
}

