/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.ui;

import com.gentleware.jboogie.controller.Controller;
import com.gentleware.jboogie.model_management.ModelTransferable;
import com.gentleware.jboogie.model_management.SimpleTypeInfo;
import com.gentleware.jboogie.piccolo.nodes.AddNodeAndLinkEventHandler;
import com.gentleware.jboogie.ui.DiagramPanel;
import com.gentleware.jboogie.ui.TransferableAccessor;
import com.gentleware.jboogie.util.F;
import com.gentleware.jboogie.util.GraphNodeBoundsLocator;
import com.gentleware.jboogie.util.GraphNodePointLocator;
import com.gentleware.openapi.jboogie.Command;
import com.gentleware.openapi.jboogie.DiId;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.jboogie.SmId;
import com.gentleware.openapi.util.CollectionFactory;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramElementImpl;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramImpl;

public class DiagramEditorDropTarget
implements DropTargetListener {
    private static final Logger A = Logger.getLogger((String)"com.gentleware.jboogie.ui.DiagramEditorDropTarget");
    protected Project _project;
    protected DiagramPanel _panel;
    private TransferableAccessor C;
    protected DropTarget _dropTarget;
    protected boolean _acceptableType;
    private Map B;

    public DiagramEditorDropTarget(Project project, DiagramPanel diagramPanel, TransferableAccessor transferableAccessor) {
        this._project = project;
        this._panel = diagramPanel;
        this.C = transferableAccessor;
        this._dropTarget = new DropTarget((Component)((Object)this._panel), 2, this, true, null);
        this.B = CollectionFactory.createHashMap();
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.checkTransferType(dropTargetDragEvent);
        this.acceptOrRejectDrag(dropTargetDragEvent);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.A(false);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = this.acceptOrRejectDrag(dropTargetDragEvent);
        this.A(false);
        if (bl) {
            this.B = this.A(dropTargetDragEvent);
            this.A(true);
        }
    }

    private void A(boolean bl) {
        Iterator iterator = this.B.keySet().iterator();
        while (iterator.hasNext()) {
            DiagramElementImpl diagramElementImpl = (DiagramElementImpl)iterator.next();
            Controller controller = (Controller)this.B.get(diagramElementImpl);
            controller.acceptDragEvent(diagramElementImpl, bl);
        }
    }

    private Map A(DropTargetDragEvent dropTargetDragEvent) {
        Map map;
        block7: {
            map = CollectionFactory.createHashMap();
            Transferable transferable = this.C.getTransferable();
            if (transferable != null) {
                try {
                    Object object = transferable.getTransferData(ModelTransferable.elementListFlavor);
                    if (!(object instanceof List)) break block7;
                    List list = (List)object;
                    Point2D point2D = dropTargetDragEvent.getLocation();
                    PCanvas pCanvas = this._panel.getCanvas();
                    point2D = SwingUtilities.convertPoint((Component)((Object)this._panel), (int)((Point2D)point2D).getX(), (int)((Point2D)point2D).getY(), (Component)pCanvas);
                    PCamera pCamera = pCanvas.getCamera();
                    PAffineTransform pAffineTransform = pCamera.getViewTransform();
                    try {
                        point2D = pAffineTransform.inverseTransform(point2D, null);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        A.error((Object)noninvertibleTransformException);
                    }
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        if (!this.isTransferableElement(e2)) continue;
                        DiagramElementImpl diagramElementImpl = AddNodeAndLinkEventHandler.findDragTargetDiElement(point2D, pCamera, this._project, null);
                        Controller controller = this._project.getModelMapper().getController(diagramElementImpl);
                        map.put(diagramElementImpl, controller);
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    A.error((Object)unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    A.error((Object)iOException);
                }
            }
        }
        return map;
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        A.info((Object)("DropTarget dropActionChanged, drop action = " + F.A(dropTargetDragEvent.getDropAction())));
        this.acceptOrRejectDrag(dropTargetDragEvent);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        block5: {
            if ((dropTargetDropEvent.getDropAction() & 2) != 0) {
                try {
                    if (dropTargetDropEvent.isDataFlavorSupported(ModelTransferable.elementListFlavor)) {
                        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                        boolean bl = this.dropNode(dropTargetDropEvent);
                        dropTargetDropEvent.dropComplete(bl);
                        A.info((Object)("Drop completed, success: " + bl));
                        break block5;
                    }
                    A.info((Object)"Drop target rejecting drop (wrong flavor)");
                    dropTargetDropEvent.rejectDrop();
                }
                catch (Exception exception) {
                    A.info((Object)"Drop target rejecting drop (exception)", (Throwable)exception);
                    exception.printStackTrace();
                    dropTargetDropEvent.dropComplete(false);
                }
            } else {
                A.info((Object)"Drop target rejected drop");
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    protected boolean acceptOrRejectDrag(DropTargetDragEvent dropTargetDragEvent) {
        int n2 = dropTargetDragEvent.getDropAction();
        int n3 = dropTargetDragEvent.getSourceActions();
        boolean bl = false;
        if (!this._acceptableType || (n3 & 3) == 0) {
            dropTargetDragEvent.rejectDrag();
        } else if ((n2 & 3) == 0) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(n2);
            bl = true;
        }
        return bl;
    }

    protected void checkTransferType(DropTargetDragEvent dropTargetDragEvent) {
        this._acceptableType = dropTargetDragEvent.isDataFlavorSupported(ModelTransferable.elementListFlavor);
    }

    protected boolean dropAllowed(Object object, Controller controller) {
        DiagramImpl diagramImpl = this._panel.getDiagram();
        if (diagramImpl.getSimpleTypeInfo().equals(SimpleTypeInfo.COLLABORATION_DIAGRAM)) {
            return false;
        }
        if (object instanceof RefObject) {
            RefObject refObject = (RefObject)object;
            if (!this._project.getDiPulizerPool().getDiPulizerFor(refObject).shouldCreateDi(this._panel.getDiagram(), refObject)) {
                return false;
            }
        }
        if (this._project.getDiHelpers().hasPresentationIn(this._panel.getDiagram(), (RefObject)object)) {
            // empty if block
        }
        return controller.canDragAndDropModelElementType(object.getClass());
    }

    protected boolean dropNode(DropTargetDropEvent dropTargetDropEvent) throws IOException, UnsupportedFlavorException, MalformedURLException {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        Object object = transferable.getTransferData(ModelTransferable.elementListFlavor);
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        Point2D point2D = dropTargetDropEvent.getLocation();
        PCanvas pCanvas = this._panel.getCanvas();
        point2D = SwingUtilities.convertPoint((Component)((Object)this._panel), (int)point2D.getX(), (int)point2D.getY(), (Component)pCanvas);
        PCamera pCamera = pCanvas.getCamera();
        PAffineTransform pAffineTransform = pCamera.getViewTransform();
        try {
            point2D = pAffineTransform.inverseTransform(point2D, null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            A.error((Object)noninvertibleTransformException);
        }
        DiId diId = this._project.getDiId((RefObject)this._panel.getDiagram());
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!this.isTransferableElement(e2)) {
                bl = false;
                continue;
            }
            RefObject refObject = (RefObject)e2;
            DiagramElementImpl diagramElementImpl = AddNodeAndLinkEventHandler.findDragTargetDiElement(point2D, pCamera, this._project, null);
            Controller controller = this._project.getModelMapper().getController(diagramElementImpl);
            PNode pNode = diagramElementImpl.getPNode();
            Point2D point2D2 = (Point2D)point2D.clone();
            PAffineTransform pAffineTransform2 = pCamera.getTransform();
            PAffineTransform pAffineTransform3 = pNode.getGlobalToLocalTransform(pAffineTransform2);
            double d2 = pAffineTransform3.getTranslateY();
            double d3 = pAffineTransform3.getTranslateX();
            if (!this.dropAllowed(refObject, controller)) {
                return false;
            }
            DiId diId2 = this._project.getNextDiId();
            Command command = this.createDragCommand(diId2, this._project.getSmId(refObject), diId, point2D, GraphNodeBoundsLocator.EXACT);
            if (command == null) continue;
            command.execute();
        }
        return bl;
    }

    protected void showDataFlavors(DataFlavor[] dataFlavorArray) {
        for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
            A.info((Object)("DropTarget show data flavors = " + dataFlavorArray[i2]));
        }
    }

    protected boolean isTransferableElement(Object object) {
        return object instanceof RefObject;
    }

    protected Command createDragCommand(DiId diId, SmId smId, DiId diId2, Point2D point2D, GraphNodePointLocator graphNodePointLocator) {
        return this._project.getDiCommandFactory().makeCommandAddNodeFromSmElement(diId, smId, diId2, point2D, graphNodePointLocator);
    }
}

