/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.ui;

import com.gentleware.openapi.jboogie.ProjectType;
import com.gentleware.openapi.util.CollectionFactory;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class MenuItem {
    protected JComponent _menuItem;
    protected Class _actionClass;
    protected String _name;
    protected ProjectType _projectType;
    protected List _subMenuNames;
    protected List _subMenuItems;

    public MenuItem(JComponent jComponent, String string, ProjectType projectType) {
        this(jComponent, null, string, projectType);
    }

    public MenuItem(Class clazz, String string, ProjectType projectType) {
        this(null, clazz, string, projectType);
    }

    public MenuItem(JComponent jComponent, Class clazz, String string, ProjectType projectType) {
        this._menuItem = jComponent;
        this._actionClass = clazz;
        this._name = string;
        this._projectType = projectType;
        this._subMenuNames = CollectionFactory.createArrayList();
        this._subMenuItems = CollectionFactory.createArrayList();
    }

    public JComponent getMenuItem() {
        return this._menuItem;
    }

    public Class getActionClass() {
        return this._actionClass;
    }

    public String getName() {
        return this._name;
    }

    public ProjectType getProjectType() {
        return this._projectType;
    }

    public int indexOfSubItem(String string) {
        return this._subMenuNames.indexOf(string);
    }

    public int getSubItemCount() {
        return this._subMenuItems.size();
    }

    public MenuItem getSubItem(int n2) {
        return (MenuItem)this._subMenuItems.get(n2);
    }

    public synchronized void addSubItem(String string, MenuItem menuItem) {
        this.addSubItem(this._subMenuNames.size(), string, menuItem);
    }

    public synchronized void addSubItemBefore(String string, MenuItem menuItem, String string2) {
        int n2 = this._subMenuNames.indexOf(string2);
        if (n2 == -1) {
            n2 = 0;
        }
        this.addSubItem(n2, string, menuItem);
    }

    public synchronized void addSubItemAfter(String string, MenuItem menuItem, String string2) {
        int n2 = this._subMenuNames.indexOf(string2) + 1;
        this.addSubItem(n2, string, menuItem);
    }

    public synchronized void addSubItem(int n2, String string, MenuItem menuItem) {
        if (!(this._menuItem instanceof JMenu)) {
            return;
        }
        this._subMenuItems.add(n2, menuItem);
        this._subMenuNames.add(n2, string);
    }

    public synchronized void removeSubItem(MenuItem menuItem) {
        int n2 = this._subMenuItems.indexOf(menuItem);
        this.removeSubItem(n2);
    }

    public synchronized void removeSubItem(String string) {
        int n2 = this._subMenuNames.indexOf(string);
        this.removeSubItem(n2);
    }

    public synchronized void removeSubItem(int n2) {
        this._subMenuItems.remove(n2);
        this._subMenuNames.remove(n2);
    }

    public boolean equals(Object object) {
        if (object instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)object;
            Class clazz = menuItem.getActionClass();
            JComponent jComponent = menuItem.getMenuItem();
            if (this._actionClass != null) {
                return this._actionClass.equals(clazz);
            }
            if (this._menuItem != null) {
                return this._menuItem.equals(jComponent);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this._actionClass != null) {
            return this._actionClass.hashCode();
        }
        return 13 * this._menuItem.hashCode();
    }
}

