/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.util.graphicswriter;

import com.gentleware.jboogie.kernel.FileFormatsResourceBundle;
import com.gentleware.jboogie.util.H;
import com.gentleware.jboogie.util.graphicswriter.GraphicsWriter;
import com.gentleware.openapi.swingx.ResourceId;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class EpsWriter
extends GraphicsWriter {
    private static final Logger F = Logger.getLogger((String)"com.gentleware.jboogie.util.graphicswriter.EpsWriter");

    public void write(OutputStream outputStream, PCanvas pCanvas, Rectangle rectangle) throws GraphicsWriter.WriteException {
        try {
            F.info((Object)"Writing Encapsulated PostScript...");
            H h2 = new H(outputStream, rectangle);
            h2.translate(32, 810);
            double d2 = Math.min(535.0 / (double)rectangle.width, 778.0 / (double)rectangle.height);
            if (d2 < 1.0) {
                F.info((Object)("Scaling PS output by " + d2));
                h2.A(d2, d2);
            }
            h2.translate(-rectangle.x, -rectangle.y);
            h2.setClip(rectangle);
            pCanvas.print((Graphics)h2);
            h2.dispose();
            F.info((Object)"Wrote Encapsulated PostScript.");
        }
        catch (IOException iOException) {
            throw new GraphicsWriter.WriteException(iOException);
        }
    }

    public String getFormatName() {
        return "Encapsulated PostScript";
    }

    public ResourceId getFormatNameResourceId() {
        return FileFormatsResourceBundle.EPS;
    }

    public String getDefaultFileSuffix() {
        return "eps";
    }

    public String[] getFileSuffixes() {
        return new String[]{"eps", "ps", "ai"};
    }
}

