/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.util.graphicswriter;

import com.gentleware.jboogie.kernel.FileFormatsResourceBundle;
import com.gentleware.jboogie.util.graphicswriter.B;
import com.gentleware.jboogie.util.graphicswriter.D;
import com.gentleware.jboogie.util.graphicswriter.GifWriter;
import com.gentleware.jboogie.util.graphicswriter.ImageIOGraphicsWriter;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Utils;
import com.gentleware.swingx.SuffixFileFilter;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.Rectangle;
import java.io.OutputStream;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class GraphicsWriter {
    private static GraphicsWriter[] C;
    private GraphicsFileFilter A;
    private static final Map D;
    private static Logger B;

    public abstract void write(OutputStream var1, PCanvas var2, Rectangle var3) throws WriteException;

    public abstract String getFormatName();

    public abstract ResourceId getFormatNameResourceId();

    public abstract String getDefaultFileSuffix();

    protected GraphicsWriter() {
    }

    public static void add(String string, GraphicsWriter graphicsWriter) {
        D.put(string, graphicsWriter);
    }

    public static void remove(String string) {
        Object v = D.remove(string);
        if (v == null) {
            B.warn((Object)("GraphicsWriter.remove(): format not found '" + string + '\''));
        }
    }

    private static void A() {
        GifWriter gifWriter = new GifWriter();
        D.put(gifWriter.getFormatName(), gifWriter);
        B b2 = new B();
        D.put(b2.getFormatName(), b2);
        if (Utils.canWriteImage((String)"png")) {
            GraphicsWriter.add("Portable Network Graphics", new ImageIOGraphicsWriter("png", "Portable Network Graphics", "png", FileFormatsResourceBundle.PNG));
        }
        if (Utils.canWriteImage((String)"pnm")) {
            GraphicsWriter.add("Portable Bitmap", new ImageIOGraphicsWriter("pnm", "Portable Bitmap", "pbm", FileFormatsResourceBundle.PNM));
        }
        if (Utils.canWriteImage((String)"jpeg 2000")) {
            GraphicsWriter.add("JPEG 2000", new ImageIOGraphicsWriter("jpeg 2000", "JPEG 2000", "jp2", new String[]{"jp2", "j2c", "j2k", "jpc", "jpx"}, FileFormatsResourceBundle.JPG2000));
        }
        if (Utils.canWriteImage((String)"tif")) {
            GraphicsWriter.add("Tagged Image File Format", new ImageIOGraphicsWriter("tif", "Tagged Image File Format", "tif", new String[]{"tif", "tiff"}, FileFormatsResourceBundle.TIF));
        }
        if (Utils.canWriteImage((String)"")) {
            GraphicsWriter.add("", new ImageIOGraphicsWriter("", "Raw Image", "raw", FileFormatsResourceBundle.RawImage));
        }
        if (Utils.canWriteImage((String)"JPEG")) {
            GraphicsWriter.add("JPEG", new ImageIOGraphicsWriter("JPEG", "JPEG", "jpg", new String[]{"jpg", "jpeg"}, FileFormatsResourceBundle.JPEG));
        }
        if (Utils.canWriteImage((String)"wbmp")) {
            GraphicsWriter.add("Wireless Bitmap", new ImageIOGraphicsWriter("wbmp", "Wireless Bitmap", "wbmp", new String[]{"wbmp", "wbm"}, FileFormatsResourceBundle.WBMP));
        }
        if (Utils.canWriteImage((String)"bmp")) {
            GraphicsWriter.add("Windows Bitmap", new ImageIOGraphicsWriter("bmp", "Windows Bitmap", "bmp", FileFormatsResourceBundle.BMP));
        }
        GraphicsWriter.add("PostScript", new D("ps", "PostScript", "ps", FileFormatsResourceBundle.PS));
        GraphicsWriter.add("Encapsulated PostScript", new D("eps", "Encapsulated PostScript", "eps", new String[]{"eps", "epsi", "epi", "epsf"}, FileFormatsResourceBundle.EPS));
        GraphicsWriter.add("Portable Document Format", new D("pdf", "Portable Document Format", "pdf", FileFormatsResourceBundle.PDF));
        C = D.values().toArray(new GraphicsWriter[D.size()]);
    }

    public static GraphicsWriter[] getAll() {
        GraphicsWriter.A();
        return C;
    }

    public static GraphicsWriter get(String string) {
        GraphicsWriter graphicsWriter = (GraphicsWriter)D.get(string);
        return graphicsWriter;
    }

    public void write(OutputStream outputStream, PCanvas pCanvas) throws WriteException {
        Rectangle rectangle = new Rectangle(0, 0, pCanvas.getWidth(), pCanvas.getHeight());
        if (rectangle.width <= 0) {
            rectangle.width = 1;
        }
        if (rectangle.height <= 0) {
            rectangle.height = 1;
        }
        this.write(outputStream, pCanvas, rectangle);
    }

    public String[] getFileSuffixes() {
        return new String[]{this.getDefaultFileSuffix()};
    }

    public boolean isFileSuffix(String string) {
        String[] stringArray = this.getFileSuffixes();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public GraphicsFileFilter getFileChooserFilter() {
        if (this.A == null) {
            this.A = new GraphicsFileFilter(this, this.getFileSuffixes(), this.getFormatNameResourceId());
        }
        return this.A;
    }

    static {
        D = CollectionFactory.createHashMap();
        B = Logger.getLogger((String)"com.gentleware.jboogie.util.graphicswriter.GraphicsWriter");
    }

    public static class GraphicsFileFilter
    extends SuffixFileFilter {
        private final GraphicsWriter F;

        GraphicsFileFilter(GraphicsWriter graphicsWriter, String[] stringArray, ResourceId resourceId) {
            super(stringArray, resourceId);
            this.F = graphicsWriter;
        }

        public GraphicsWriter getWriter() {
            return this.F;
        }
    }

    public static class WriteException
    extends Exception {
        public WriteException(String string) {
            super(string);
        }

        public WriteException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public WriteException(Throwable throwable) {
            super(throwable);
        }
    }
}

