<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstra�e 12, 20357 Hamburg, Germany
-->
<xsl:transform version="1.0" xmlns:UML="org.omg.xmi.namespace.UML"
               xmlns:UML2="org.omg.xmi.namespace.UML2" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!--xsl:import href="utilities.xsl"/-->
    <xsl:key
            match="
        UML:StateMachine/UML:StateMachine.context/UML:Class |
        UML:StateMachine/UML:StateMachine.context/UML:AssociationClass |
        UML:StateMachine/UML:StateMachine.context/UML:Node |
        UML:StateMachine/UML:StateMachine.context/UML:Component |
        UML:StateMachine/UML:StateMachine.context/UML:UseCase |
        UML:StateMachine/UML:StateMachine.context/UML:Interface |
        UML:StateMachine/UML:StateMachine.context/UML:Actor |
        UML:StateMachine/UML:StateMachine.context/UML:ClassifierRole |
        UML:StateMachine/UML:StateMachine.context/UML:DataType |
        UML:StateMachine/UML:StateMachine.context/UML:Subsystem |
        UML:StateMachine/UML:StateMachine.context/UML:Exception"
            name="classXmiIdRef" use="@xmi.idref"/>

    <xsl:key
            match="UML:ActivityGraph/UML:StateMachine.context/UML:Class|
        UML:ActivityGraph/UML:StateMachine.context/UML:UseCase|
        UML:ActivityGraph/UML:StateMachine.context/UML:AssociationClass|
        UML:ActivityGraph/UML:StateMachine.context/UML:Interface|
        UML:ActivityGraph/UML:StateMachine.context/UML:Actor|
        UML:ActivityGraph/UML:StateMachine.context/UML:Collaboration|
        UML:ActivityGraph/UML:StateMachine.context/UML2:StateMachine|
        UML:ActivityGraph/UML:StateMachine.context/UML:Model|
        UML:ActivityGraph/UML:StateMachine.context/UML:Component|
        UML:ActivityGraph/UML:StateMachine.context/UML:Package"
            name="activityXmiIdRef" use="@xmi.idref"/>


    <xsl:key match="/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement//UML:CallEvent"
             name="callEventXmiId" use="@xmi.id"/>


    <!--UML:Component[@xmi.id] |-->
    <xsl:template
            match="UML:Class[@xmi.id] |
        UML:AssociationClass[@xmi.id] |
        UML:Node[@xmi.id] |
        UML:UseCase[@xmi.id]|
        UML:Collaboration[@xmi.id]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <!-- Does a StateMachine exists which references the context element? -->
            <xsl:if test="key('classXmiIdRef', @xmi.id) or key('activityXmiIdRef', @xmi.id)">
                <xsl:call-template name="stateMachineFound"/>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>

    <!--Add handling for Uml2StateMachines-->
    <xsl:template
            match="UML:Collaboration[key('activityXmiIdRef',UML2:BehavioredClassifier.ownedBehavior/UML2:StateMachine/@xmi.id)]/UML2:BehavioredClassifier.ownedBehavior">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="key('activityXmiIdRef', UML2:StateMachine/@xmi.id)/../.."
                                 mode="activityGraphRoot"/>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>

    <!-- Omit the ClassifierFeature in case a StateMachine exits,
because in the stateMachineFound template the classifierFeature was/will be created and copied. -->
    <xsl:template match="UML:Classifier.feature[key('classXmiIdRef', ../@xmi.id) | key('activityXmiIdRef', ../@xmi.id)]"/>

    <xsl:template name="stateMachineFound">
        <!-- Create Operations in ClassifierFeatures f�r Trigger-->
        <!-- ### Create Operations in ClassifierFeatures f�r Trigger -->
        <xsl:apply-templates select="UML:Classifier.feature" mode="copy_classifier_feature"/>
        <xsl:if test="not(UML:Classifier.feature)">
            <xsl:call-template name="addClassifierFeature"/>
        </xsl:if>
        <xsl:element name="UML2:BehavioredClassifier.ownedBehavior">
            <xsl:apply-templates select="key('classXmiIdRef', @xmi.id)/../../." mode="stateMachine"/>
            <xsl:apply-templates select="key('activityXmiIdRef', @xmi.id)/../../." mode="activityGraphRoot"/>
        </xsl:element>
    </xsl:template>

    <xsl:template name="addClassifierFeature">
        <xsl:element name="UML:Classifier.feature">
            <xsl:call-template name="addOperationToFeature">
                <xsl:with-param name="xmiId" select="@xmi.id"/>
                <xsl:with-param name="name" select="@name"/>
            </xsl:call-template>
        </xsl:element>
    </xsl:template>

    <!-- Elements which are not allowed to have a statemachine associated anymore.
If you add an additinally element to the match attribute, don't forget to update
the key: classXmiIdRef as well! -->
    <xsl:template
            match="UML:Interface[@xmi.id] |
                    UML:Actor[@xmi.id] |
                    UML:ClassifierRole[@xmi.id] |
                    UML:DataType[@xmi.id] |
                    UML:Subsystem[@xmi.id] |
                    UML:Exception[@xmi.id] |
                    UML:Model[@xmi.id] |
                    UML:Package[@xmi.id]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates/>
        </xsl:copy>
        <xsl:if test="key('classXmiIdRef', @xmi.id)">
            <xsl:call-template name="addMessage">
                <xsl:with-param name="message">
                    <xsl:text>Found statemachine for Classifier:</xsl:text>
                    <xsl:value-of select="@name"/>
                    <xsl:text>with type:</xsl:text>
                    <xsl:value-of select="local-name()"/>
                    .
                    <xsl:text>
                        In UML2 statemachines are not allowed at this element.

                        Therefore a Collaboration will be created which is the new onwer of
                        the statemachine:</xsl:text>
                    <xsl:value-of select="key('classXmiIdRef', @xmi.id)/../../@name"/>
                    .
                </xsl:with-param>
            </xsl:call-template>
            <xsl:variable name="collaborationName">
                <xsl:text>CollaborationFor</xsl:text>
                <xsl:value-of select="@name"/>
                <xsl:text>_generated_</xsl:text>
                <xsl:value-of select="@xmi.id"/>
            </xsl:variable>
            <xsl:element name="UML:Collaboration">
                <xsl:attribute name="xmi.id">
                    <xsl:call-template name="generateXmiId"/>
                </xsl:attribute>
                <!-- The text element are used to disable the preserving of whitspaces-->
                <xsl:attribute name="name">
                    <xsl:value-of select="$collaborationName"/>
                </xsl:attribute>
                <xsl:call-template name="addCommonAttributes"/>
                <xsl:call-template name="stateMachineFound"/>
            </xsl:element>
            <xsl:call-template name="addMessage">
                <xsl:with-param name="message">
                    <xsl:text>Name of generated Collaboration:</xsl:text>
                    <xsl:value-of select="$collaborationName"/>
                </xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="key('activityXmiIdRef', @xmi.id)">
            <xsl:variable name="collaborationName">
                <xsl:text>CollaborationFor</xsl:text>
                <xsl:value-of select="@name"/>
                <xsl:text>_generated_</xsl:text>
                <xsl:value-of select="@xmi.id"/>
            </xsl:variable>
            <xsl:element name="UML:Collaboration">
                <xsl:attribute name="xmi.id">
                    <xsl:call-template name="generateXmiId"/>
                </xsl:attribute>
                <!-- The text element are used to disable the preserving of whitspaces-->
                <xsl:attribute name="name">
                    <xsl:value-of select="$collaborationName"/>
                </xsl:attribute>
                <xsl:call-template name="addCommonAttributes"/>
                <xsl:call-template name="stateMachineFound"/>
            </xsl:element>
        </xsl:if>
    </xsl:template>

    <xsl:template match="UML:Classifier.feature" mode="copy_classifier_feature">
        <!-- ###found2 xmi id:<xsl:value-of select="../@xmi.id"/> -->
        <xsl:copy>
            <xsl:apply-templates select="." mode="class_conversion">
                <xsl:with-param name="xmiId" select="../@xmi.id"/>
            </xsl:apply-templates>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>

    <xsl:template name="addOperationToFeature" match="UML:Classifier.feature"
                  mode="class_conversion" priority="-5">
        <xsl:param name="xmiId"/>
        <xsl:param name="name" select="../@name"/>
        <!--### Processing addOperationToFeature for Element name: <xsl:value-of select="name()"/>-->
        <xsl:variable name="classifierName" select="$name"/>
        <!--Select all Elements which references the selected Class-->
        <xsl:for-each select="key('classXmiIdRef', $xmiId)">
            <!--### Position: <xsl:value-of select="position()"/>-->
            <!--### Element: <xsl:value-of select="name()"/>-->
            <!-- Search for call events in this context -->
            <xsl:for-each select="../..//UML:CallEvent">
                <!--Select all CallEvents which are referenced by this CallEvent context -->
                <xsl:for-each select="key('callEventXmiId', @xmi.idref)">
                    <xsl:if test="position()=1">
                        <xsl:call-template name="addMessage">
                            <xsl:with-param name="message">
                                <xsl:call-template name="line-break"/>
                                <xsl:text>The UML model type for a Trigger (CallEvent) changed to CallTrigger.</xsl:text>
                                <xsl:call-template name="line-break"/>
                                <xsl:text>An operation needs to be generated at the owned classifier (</xsl:text>
                                <xsl:value-of select="$classifierName"/>
                                <xsl:text>)</xsl:text>
                                <xsl:call-template name="line-break"/>
                                <xsl:text>which will be referenced by the converted CallTrigger. The following</xsl:text>
                                <xsl:call-template name="line-break"/>
                                <xsl:text>CallEvents are converted:</xsl:text>
                                <xsl:call-template name="line-break"/>
                            </xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:call-template name="addMessage">
                        <xsl:with-param name="message">
                            <xsl:text>CallEvent:</xsl:text>
                            <xsl:value-of select="@name"/>
                        </xsl:with-param>
                    </xsl:call-template>
                    <xsl:call-template name="addOperation"/>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="*" mode="class_conversion" priority="-10">
        <xsl:apply-templates select="@*"/>
        <xsl:apply-templates select="."/>
    </xsl:template>

    <xsl:template name="addOperation">
        <!--###addOperation-->
        <xsl:variable name="operationXmiId">
            <xsl:call-template name="generateXmiId"/>
        </xsl:variable>
        <xsl:variable name="generatedName">
            <xsl:value-of select="@name"/>
            <xsl:text>_generated_</xsl:text>
            <xsl:value-of select="$operationXmiId"/>
        </xsl:variable>
        <xsl:element name="UML:Operation">
            <xsl:attribute name="name">
                <xsl:value-of select="$generatedName"/>
            </xsl:attribute>
            <xsl:attribute name="xmi.id">
                <xsl:value-of select="$operationXmiId"/>
            </xsl:attribute>
            <xsl:attribute name="visibility">public</xsl:attribute>
            <xsl:attribute name="isSpecification">false</xsl:attribute>
            <xsl:attribute name="ownerScope">instance</xsl:attribute>
            <xsl:attribute name="isQuery">false</xsl:attribute>
            <xsl:attribute name="concurrency">sequential</xsl:attribute>
            <xsl:attribute name="isRoot">false</xsl:attribute>
            <xsl:attribute name="isLeaf">false</xsl:attribute>
            <xsl:attribute name="isAbstract">false</xsl:attribute>
            <xsl:attribute name="callevent.xmi.idref">
                <xsl:value-of select="@xmi.id"/>
            </xsl:attribute>
            <xsl:element name="UML:BehavioralFeature.parameter">
                <xsl:copy-of select="UML:Event.parameter/UML:Parameter"/>
                <xsl:if test="not(UML:Event.parameter/UML:Parameter[@kind ='return'])">
                    <xsl:element name="UML:Parameter">
                        <xsl:attribute name="xmi.id">
                            <xsl:call-template name="generateXmiId"/>
                        </xsl:attribute>
                        <xsl:attribute name="name">return_generated</xsl:attribute>
                        <xsl:attribute name="isSpecification">false</xsl:attribute>
                        <xsl:attribute name="kind">return</xsl:attribute>
                        <xsl:element name="UML:Parameter.type">
                            <xsl:element name="UML:DataType">
                                <xsl:attribute name="xmi.idref">
                                    <xsl:value-of select="$parameterVoidXmiId"/>
                                </xsl:attribute>
                            </xsl:element>
                        </xsl:element>
                    </xsl:element>
                </xsl:if>
            </xsl:element>
        </xsl:element>
        <xsl:element name="UML:Method">
            <xsl:attribute name="xmi.id">
                <xsl:call-template name="generateXmiId"/>
            </xsl:attribute>
            <xsl:attribute name="isSpecification">false</xsl:attribute>
            <xsl:attribute name="isQuery">false</xsl:attribute>
            <xsl:element name="UML:Method.body">
                <xsl:element name="UML:ProcedureExpression">
                    <xsl:attribute name="xmi.id">
                        <xsl:call-template name="generateXmiId"/>
                    </xsl:attribute>
                    <xsl:attribute name="language"/>
                    <xsl:attribute name="body"/>
                </xsl:element>
            </xsl:element>
            <xsl:element name="UML:Method.specification">
                <xsl:element name="UML:Operation">
                    <xsl:attribute name="xmi.idref">
                        <xsl:value-of select="$operationXmiId"/>
                    </xsl:attribute>
                </xsl:element>
            </xsl:element>
        </xsl:element>
        <xsl:call-template name="addMessage">
            <xsl:with-param name="message">
                <xsl:text>Generated Operation:</xsl:text>
                <xsl:value-of select="$generatedName"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
</xsl:transform>
