<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstra�e 12, 20357 Hamburg, Germany
Andrey Polyakov andrew@gentleware.net
-->
<xsl:transform version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:UML="org.omg.xmi.namespace.UML"
               xmlns:UML2="org.omg.xmi.namespace.UML2">

    <xsl:key name="is-port-key"
             match="//UML:Attribute[UML:ModelElement.stereotype[UML:Stereotype/@xmi.idref=/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement/UML:Stereotype[@name='gentleware-port']/@xmi.id]]"
             use="@xmi.id"/>
    <xsl:key name="is-need-fix-position"
             match="//UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element[UML:Node|UML:ComponentInstance|UML:NodeInstance]]/UML:GraphElement.contained/UML:GraphNode[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='BodyCompartment']]/UML:GraphElement.contained/node()"
             use="@xmi.id"/>
    <xsl:key name="is-realization"
             match="//UML:Abstraction[UML:ModelElement.stereotype[UML:Stereotype/@xmi.idref=/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement/UML:Stereotype[@name='realize']/@xmi.id] and UML:Dependency.client/UML:Class and UML:Dependency.supplier/UML:Component]"
             use="@xmi.id"/>
    <xsl:key name="is-stimulus-action" match="//UML:Stimulus[UML:Stimulus.communicationLink/UML:Link]/UML:Stimulus.dispatchAction/UML:CallAction"
             use="@xmi.idref"/>
    <xsl:key name="is-not-collaboration-object" match="//UML:Object[count(../../../UML:Collaboration) = 0 and @xmi.id]" use="@xmi.id"/>
    <xsl:key name="is-assembly-connector"
             match="//UML:Dependency[UML:ModelElement.stereotype[UML:Stereotype/@xmi.idref=/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement/UML:Stereotype[@name='gentleware-assembly-connector']/@xmi.id]]"
             use="@xmi.id"/>
    <xsl:key name="is-provided-interface-in-assembly-connector"
             match="//UML:Dependency[UML:ModelElement.stereotype[UML:Stereotype/@xmi.idref=/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement/UML:Stereotype[@name='gentleware-assembly-connector']/@xmi.id]]/UML:Dependency.client/UML:Interface"
             use="@xmi.idref"/>
    <xsl:key name="is-reqired-interface-in-assembly-connector"
             match="//UML:Dependency[UML:ModelElement.stereotype[UML:Stereotype/@xmi.idref=/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement/UML:Stereotype[@name='gentleware-assembly-connector']/@xmi.id]]/UML:Dependency.supplier/UML:Interface"
             use="@xmi.idref"/>
    <!-- DI -->
    <xsl:template match="UML:Diagram[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='DeploymentDiagram']]">
        <xsl:apply-templates select="." mode="deploymentDiagram"/>
    </xsl:template>
    <xsl:template match="UML:SimpleSemanticModelElement[@typeInfo='DeploymentDiagram']" mode="deploymentDiagram">
        <UML:SimpleSemanticModelElement xmi.id="{@xmi.id}" presentation="{@presentation}" typeInfo="ComponentDiagram"/>
    </xsl:template>
    <xsl:template match="node()|@*" priority="-10" mode="deploymentDiagram">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" mode="deploymentDiagram"/>
        </xsl:copy>
    </xsl:template>
    <!-- fix DI  for Node|NodeInstance and ComponentInstance -->
    <xsl:template
            match="UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element[UML:Node|UML:ComponentInstance|UML:NodeInstance|UML:Object[key('is-not-collaboration-object', @xmi.idref)]]]"
            mode="deploymentDiagram">
        <UML:GraphNode>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates mode="deploymentDiagram" select="child::node()[name()!='UML:GraphElement.contained']"/>
        </UML:GraphNode>
        <xsl:for-each
                select="UML:GraphElement.contained/UML:GraphNode[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='BodyCompartment']]/UML:GraphElement.contained/*">
            <xsl:apply-templates select="current()" mode="deploymentDiagram"/>
        </xsl:for-each>
    </xsl:template>
    <!-- xsl:template match="//UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element[UML:Node|UML:ComponentInstance|UML:NodeInstance|UML:Object]]/UML:GraphElement.contained/UML:GraphNode[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='BodyCompartment']]/UML:GraphElement.contained/*" mode="deploymentDiagram"/ -->
    <xsl:template match="UML:GraphNode[key('is-need-fix-position', @xmi.id)]/UML:GraphElement.position" mode="deploymentDiagram">
        <UML:GraphElement.position>
            <xsl:variable name="position-x">
                <xsl:call-template name="convertFieldToGlobal">
                    <xsl:with-param name="graphNode" select=".."/>
                    <xsl:with-param name="index" select="1"/>
                </xsl:call-template>
            </xsl:variable>
            <xsl:variable name="position-y">
                <xsl:call-template name="convertFieldToGlobal">
                    <xsl:with-param name="graphNode" select=".."/>
                    <xsl:with-param name="index" select="2"/>
                </xsl:call-template>
            </xsl:variable>
            <XMI.field>
                <xsl:value-of select="$position-x"/>
            </XMI.field>
            <XMI.field>
                <xsl:value-of select="$position-y"/>
            </XMI.field>
        </UML:GraphElement.position>
    </xsl:template>
    <xsl:template name="convertFieldToGlobal">
        <xsl:param name="graphNode"/>
        <xsl:param name="index"/>
        <xsl:variable name="parentGraphNode" select="$graphNode/../../UML:GraphElement.position"/>
        <xsl:variable name="parent-value">
            <xsl:choose>
                <xsl:when test="exists($parentGraphNode)">
                    <xsl:call-template name="convertFieldToGlobal">
                        <xsl:with-param name="graphNode" select="$graphNode/../.."/>
                        <xsl:with-param name="index" select="$index"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="value" select="number($parent-value) + number($graphNode/UML:GraphElement.position/XMI.field[$index])"/>
        <xsl:value-of select="$value"/>
    </xsl:template>
    <!-- Fix Di for Interface-->
    <xsl:template
            match="UML:GraphNode/UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge[UML:Uml1SemanticModelBridge.element/UML:Interface and @presentation = 'Ball']"
            mode="deploymentDiagram">
        <UML:Uml1SemanticModelBridge xmi.id="{@xmi.id}" presentation="">
            <xsl:apply-templates select="child::node()" mode="deploymentDiagram"/>
        </UML:Uml1SemanticModelBridge>
    </xsl:template>
    <!-- Fix ref to Sm Elements-->
    <xsl:template match="UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element" mode="deploymentDiagram">
        <UML:Uml1SemanticModelBridge.element>
            <xsl:apply-templates select="child::node()" mode="deploymentElementReference"/>
        </UML:Uml1SemanticModelBridge.element>
    </xsl:template>
    <xsl:template match="UML:Component[@xmi.idref]" mode="deploymentElementReference">
        <UML2:Component xmi.idref="{@xmi.idref}"/>
    </xsl:template>
    <xsl:template match="UML:Attribute[key('is-port-key', @xmi.idref)]" mode="deploymentElementReference">
        <UML2:Port xmi.idref="{@xmi.idref}"/>
    </xsl:template>
    <!-- fix DI and SM references -->
    <xsl:template match="UML:Abstraction[key('is-realization', @xmi.idref)]">
        <UML2:Realization xmi.idref="{@xmi.idref}"/>
    </xsl:template>
    <xsl:template
            match="UML:NodeInstance[@xmi.idref]|UML:ComponentInstance[@xmi.idref]|UML:Object[@xmi.idref and key('is-not-collaboration-object', @xmi.idref)]"
            mode="deploymentElementReference">
        <UML2:InstanceSpecification xmi.idref="{@xmi.idref}"/>
    </xsl:template>
    <xsl:template match="node()|@*" priority="-10" mode="deploymentElementReference">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" mode="deploymentElementReference"/>
        </xsl:copy>
    </xsl:template>
    <!-- SM Component-->
    <xsl:template match="UML:Component[@xmi.id]">
        <xsl:variable name="component-xmi.id" select="@xmi.id"/>
        <UML2:Component>
            <xsl:copy-of select="@*"/>
            <xsl:if test="key('classXmiIdRef', @xmi.id) or key('activityXmiIdRef', @xmi.id)">
                <xsl:call-template name="stateMachineFound"/>
            </xsl:if>
            <xsl:apply-templates select="child::node()" mode="innerComponentElements"/>
            <!-- UML2:Component.ownedElement>
               <xsl:copy-of select="//UML:Component.residentElement/UML:ElementResidence/UML:ElementResidence.resident/*"/>
           </UML2:Component.ownedElement -->
            <!-- UML:ModelElement.clientDependency>
                <xsl:copy-of select="UML:ModelElement.clientDependency/*"/>
                <xsl:for-each select="UML:Component.residentElement/UML:ElementResidence">
                     <UML2:Realization xmi.idref="{@xmi.id}"/>
                </xsl:for-each>
           </UML:ModelElement.clientDependency -->
        </UML2:Component>
        <xsl:for-each select="UML:Component.residentElement/UML:ElementResidence">
            <UML2:Realization xmi.id="{@xmi.id}" isSpecification="false">
                <UML:Dependency.client>
                    <xsl:copy-of select="UML:ElementResidence.resident/*"/>
                </UML:Dependency.client>
                <UML:Dependency.supplier>
                    <UML2:Component xmi.idref="{$component-xmi.id}"/>
                </UML:Dependency.supplier>
            </UML2:Realization>
        </xsl:for-each>
    </xsl:template>
    <xsl:template match="UML:Component.residentElement" mode="innerComponentElements"/>
    <xsl:template match="UML:Component.deploymentLocation" mode="innerComponentElements"/>
    <xsl:template match="UML:ModelElement.clientDependency" mode="innerComponentElements"/>
    <xsl:template match="UML:Namespace.ownedElement" mode="innerComponentElements"/>
    <xsl:template match="UML:Attribute[key('is-port-key', @xmi.id)]" mode="innerComponentElements">
        <UML2:Port>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="child::node()" mode="innerComponentElements"/>
            <UML2:ConnectableElement.end>
                <xsl:variable name="port_xmi.id" select="@xmi.id"/>
                <xsl:variable name="type_xmi.id"
                              select="UML:StructuralFeature.type/UML:Class/@xmi.idref|UML2:TypedElement.type/UML:Class/@xmi.idref"/>
                <xsl:for-each
                        select="//UML:Abstraction[UML:Dependency.client/UML:Class[@xmi.idref=$type_xmi.id]]/UML:Dependency.supplier/UML:Interface[key('is-provided-interface-in-assembly-connector', @xmi.idref)]">
                    <UML2:ConnectorEnd xmi.idref="{$port_xmi.id}_{current()/@xmi.idref}_provided"/>
                </xsl:for-each>
                <xsl:for-each
                        select="//UML:Dependency[UML:Dependency.client/UML:Class[@xmi.idref=$type_xmi.id]]/UML:Dependency.supplier/UML:Interface[key('is-reqired-interface-in-assembly-connector', @xmi.idref)]">
                    <UML2:ConnectorEnd xmi.idref="{$port_xmi.id}_{current()/@xmi.idref}_reqired"/>
                </xsl:for-each>
            </UML2:ConnectableElement.end>
        </UML2:Port>
    </xsl:template>
    <!-- Instance spesificatilon -->
    <xsl:template
            match="UML:NodeInstance[@xmi.idref]|UML:ComponentInstance[@xmi.idref]|UML:Object[@xmi.idref and key('is-not-collaboration-object', @xmi.idref)]">
        <UML2:InstanceSpecification xmi.idref="{@xmi.idref}"/>
    </xsl:template>

    <xsl:template
            match="UML:NodeInstance[@xmi.id]|UML:ComponentInstance[@xmi.id]|UML:Object[@xmi.id and key('is-not-collaboration-object', @xmi.id)]">
        <UML2:InstanceSpecification>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="child::node()" mode="innerComponentElements"/>
        </UML2:InstanceSpecification>
        <xsl:apply-templates select="UML:Instance.ownedLink/*" mode="innerComponentElements"/>
    </xsl:template>
    <xsl:template match="UML:Instance.linkEnd" mode="innerComponentElements">
        <UML2:InstanceSpecification.linkEnd>
            <xsl:apply-templates select="child::node()" mode="innerComponentElements"/>
        </UML2:InstanceSpecification.linkEnd>
    </xsl:template>
    <xsl:template match="UML:Instance.ownedLink" mode="innerComponentElements"/>
    <xsl:template match="UML:LinkEnd.instance" mode="innerComponentElements">
        <UML:LinkEnd.instanceSpecification>
            <xsl:apply-templates select="child::node()"/>
        </UML:LinkEnd.instanceSpecification>
    </xsl:template>
    <xsl:template match="UML:Instance.classifier" mode="innerComponentElements">
        <UML2:InstanceSpecification.classifier>
            <xsl:apply-templates select="child::node()"/>
        </UML2:InstanceSpecification.classifier>
    </xsl:template>
    <xsl:template match="UML:Instance.componentInstance|UML:ComponentInstance.resident|UML:NodeInstance.resident|UML:ComponentInstance.nodeInstance"
                  mode="innerComponentElements"/>
    <!--<xsl:template match="UML:Stimulus[UML:Stimulus.communicationLink/UML:Link]"/>-->
    <!--<xsl:template match="UML:CallAction[key('is-stimulus-action', @xmi.id)]"/>-->
    <!-- Copy stereotypes -->
    <xsl:template match="UML:ModelElement.stereotype" mode="innerComponentElements" priority="-5">
        <xsl:copy-of select="."/>
    </xsl:template>
    <!-- Copy tagget values -->
    <xsl:template match="UML:ModelElement.taggedValue" mode="innerComponentElements" priority="-5">
        <xsl:copy-of select="."/>
    </xsl:template>
    <!-- Copy other elements -->
    <xsl:template match="node()|@*" priority="-10" mode="innerComponentElements">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" mode="innerComponentElements"/>
        </xsl:copy>
    </xsl:template>
    <!-- 	Node 	-->
    <xsl:template match="UML:Node[@xmi.id]/UML:Node.deployedComponent"/>
    <!-- Assebly Connector -->
    <xsl:template match="UML:Dependency[key('is-assembly-connector', @xmi.idref)]"/>
    <xsl:template match="UML:Dependency[key('is-assembly-connector', @xmi.idref)]" mode="deploymentElementReference">
        <UML2:Connector xmi.idref="{@xmi.idref}"/>
    </xsl:template>
    <xsl:template match="UML:Dependency[key('is-assembly-connector', @xmi.id)]">
        <UML2:Connector isOrdered="false" isUnique="false" upper="-1" lower="1" visibility="public" kind="assembly">
            <xsl:copy-of select="@*"/>
            <xsl:if test="count(@name)=0">
                <xsl:attribute name="name"/>
            </xsl:if>
            <UML2:Connector.end>
                <xsl:variable name="provided.xmi.id" select="UML:Dependency.client/UML:Interface/@xmi.idref"/>
                <xsl:variable name="provided.port.xmi.id"
                              select="//UML:Attribute[key('is-port-key', @xmi.id)][UML:StructuralFeature.type/UML:Class[@xmi.idref=//UML:Abstraction[UML:Dependency.supplier/UML:Interface[@xmi.idref=$provided.xmi.id]]/UML:Dependency.client/UML:Class/@xmi.idref]|UML2:TypedElement.type/UML:Class[@xmi.idref=//UML:Abstraction[UML:Dependency.supplier/UML:Interface[@xmi.idref=$provided.xmi.id]]/UML:Dependency.client/UML:Class/@xmi.idref]]/@xmi.id"/>
                <UML2:ConnectorEnd xmi.id="{$provided.port.xmi.id}_{$provided.xmi.id}_provided" isOrdered="false" isUnique="true" upper="1" lower="-1"
                                   name="" visibility="public" isSpecification="false">
                    <UML2:ConnectorEnd.role>
                        <UML2:Port xmi.idref="{$provided.port.xmi.id}"/>
                    </UML2:ConnectorEnd.role>
                </UML2:ConnectorEnd>
                <xsl:variable name="reqired.xmi.id" select="UML:Dependency.supplier/UML:Interface/@xmi.idref"/>
                <xsl:variable name="reqired.port.xmi.id"
                              select="//UML:Attribute[key('is-port-key', @xmi.id)][UML:StructuralFeature.type/UML:Class[@xmi.idref=//UML:Dependency[UML:Dependency.supplier/UML:Interface[@xmi.idref=$reqired.xmi.id]]/UML:Dependency.client/UML:Class/@xmi.idref]|UML2:TypedElement.type/UML:Class[@xmi.idref=//UML:Dependency[UML:Dependency.supplier/UML:Interface[@xmi.idref=$reqired.xmi.id]]/UML:Dependency.client/UML:Class/@xmi.idref]]/@xmi.id"/>
                <UML2:ConnectorEnd xmi.id="{$reqired.port.xmi.id}_{$reqired.xmi.id}_required" isOrdered="false" isUnique="true" upper="1" lower="-1"
                                   name="" visibility="public" isSpecification="false">
                    <UML2:ConnectorEnd.role>
                        <UML2:Port xmi.idref="{$reqired.port.xmi.id}"/>
                    </UML2:ConnectorEnd.role>
                </UML2:ConnectorEnd>
            </UML2:Connector.end>
        </UML2:Connector>
    </xsl:template>
    <!-- Abstraction -->
    <xsl:template match="UML:Abstraction[key('is-realization', @xmi.id)]">
        <UML2:Realization>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="child::node()" mode="innerAbstractionElements"/>
        </UML2:Realization>
    </xsl:template>
    <xsl:template match="UML:Stereotype[@xmi.idref=/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement/UML:Stereotype[@name='realize']/@xmi.id]"
                  mode="innerAbstractionElements"/>
    <xsl:template match="node()|@*" priority="-10" mode="innerAbstractionElements">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" mode="innerAbstractionElements"/>
        </xsl:copy>
    </xsl:template>
    <!-- Remove unessary di structure-->
    <xsl:template
            match="//UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Attribute[key('is-port-key', @xmi.idref)]]"
            mode="deploymentDiagram">
        <xsl:apply-templates select="." mode="deploymentElementReference"/>
    </xsl:template>
    <xsl:template
            match="//UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Component]/UML:GraphElement.contained/node()[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement/@typeInfo!='BodyCompartment']"
            mode="deploymentDiagram" priority="-1"/>
    <xsl:template
            match="//UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Node]/UML:GraphElement.contained/*"
            mode="deploymentDiagram" priority="-1"/>
    <xsl:template
            match="//UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:ComponentInstance]/UML:GraphElement.contained/*"
            mode="deploymentDiagram"/>
    <xsl:template
            match="//UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:NodeInstance]/UML:GraphElement.contained/*"
            mode="deploymentDiagram"/>
    <xsl:template
            match="//UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Object[key('is-not-collaboration-object', @xmi.idref)]]/UML:GraphElement.contained/*"
            mode="deploymentDiagram"/>
    <xsl:template
            match="//UML:GraphEdge[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Abstraction[key('is-realization', @xmi.idref)]]/UML:GraphElement.contained/*"
            mode="deploymentDiagram"/>
    <xsl:template
            match="//UML:GraphEdge[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Link]/UML:GraphElement.contained/*"
            mode="deploymentDiagram"/>
    <!-- [key('is-port-key', @xmi.idref)] -->
    <xsl:template
            match="//UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Attribute[key('is-port-key', @xmi.idref)]]/UML:GraphElement.contained"
            mode="deploymentElementReference">
        <UML:GraphElement.contained>
            <xsl:for-each
                    select="UML:GraphNode[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='ProvidedInterfaceNode']]/UML:GraphElement.contained/*">
                <!-- Skip if it is part of assebly connector -->
                <xsl:if test="count(current()/UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Interface[key('is-provided-interface-in-assembly-connector', @xmi.idref)])=0">
                    <xsl:apply-templates select="current()" mode="fixChildPositionDeploymentDiagram">
                        <xsl:with-param name="typeInfo" select="'ProvidedInterfaceNode'"/>
                    </xsl:apply-templates>
                </xsl:if>
            </xsl:for-each>
            <xsl:for-each
                    select="UML:GraphNode[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='RequiredInterfaceNode']]/UML:GraphElement.contained/*">
                <!-- Skip if it is part of assebly connector -->
                <xsl:if test="count(current()/UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Interface[key('is-reqired-interface-in-assembly-connector', @xmi.idref)])=0">
                    <xsl:apply-templates select="current()" mode="fixChildPositionDeploymentDiagram">
                        <xsl:with-param name="typeInfo" select="'RequiredInterfaceNode'"/>
                    </xsl:apply-templates>
                </xsl:if>
            </xsl:for-each>
            <xsl:for-each select="UML:GraphEdge[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='ProvidedInterfaceEdge']]">
                <xsl:variable name="current-xmi.id" select="current()/@xmi.id"/>
                <xsl:variable name="test-value" select="count(
current()/../UML:GraphNode/UML:GraphElement.contained/UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Interface[key('is-provided-interface-in-assembly-connector', @xmi.idref)]]/UML:GraphElement.anchorage/UML:GraphConnector/UML:GraphConnector.graphEdge/UML:GraphEdge[@xmi.idref=$current-xmi.id])=0"/>
                <!-- Skip if it is part of assebly connector -->
                <xsl:if test="$test-value">
                    <xsl:apply-templates select="current()" mode="deploymentDiagram"/>
                </xsl:if>
            </xsl:for-each>
            <xsl:for-each select="UML:GraphEdge[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='RequiredInterfaceEdge']]">
                <xsl:variable name="current-xmi.id" select="current()/@xmi.id"/>
                <xsl:variable name="test-value" select="count(
current()/../UML:GraphNode/UML:GraphElement.contained/UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Interface[key('is-reqired-interface-in-assembly-connector', @xmi.idref)]]/UML:GraphElement.anchorage/UML:GraphConnector/UML:GraphConnector.graphEdge/UML:GraphEdge[@xmi.idref=$current-xmi.id])=0"/>
                <!-- Skip if it is part of assebly connector -->
                <xsl:if test="$test-value">
                    <xsl:apply-templates select="current()" mode="deploymentDiagram"/>
                </xsl:if>
            </xsl:for-each>
        </UML:GraphElement.contained>
    </xsl:template>
    <xsl:template
            match="UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Interface]/UML:GraphElement.position"
            mode="fixChildPositionDeploymentDiagram">
        <xsl:param name="typeInfo"/>
        <xsl:comment>
            <xsl:value-of select="$typeInfo"/>
        </xsl:comment>
        <UML:GraphElement.position>
            <xsl:comment>fixed</xsl:comment>
            <xsl:variable name="parent-x"
                          select="../../../../UML:GraphNode[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement/@typeInfo=$typeInfo]/UML:GraphElement.position/XMI.field[1]"/>
            <xsl:variable name="parent-y"
                          select="../../../../UML:GraphNode[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement/@typeInfo=$typeInfo]/UML:GraphElement.position/XMI.field[2]"/>
            <xsl:variable name="x" select="number($parent-x) + number(XMI.field[1])"/>
            <xsl:variable name="y" select="number($parent-y) + number(XMI.field[2])"/>
            <XMI.field>
                <xsl:value-of select="$x"/>
            </XMI.field>
            <XMI.field>
                <xsl:value-of select="$y"/>
            </XMI.field>
        </UML:GraphElement.position>
    </xsl:template>
    <xsl:template
            match="UML:GraphEdge[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Dependency[key('is-assembly-connector', @xmi.idref)]]/UML:GraphElement.contained"
            mode="deploymentDiagram"/>
    <xsl:template
            match="UML:GraphEdge[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Dependency[key('is-assembly-connector', @xmi.idref)]]/UML:GraphEdge.anchor"
            mode="deploymentDiagram"/>
    <xsl:template
            match="UML:GraphEdge[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Dependency[key('is-assembly-connector', @xmi.idref)]]/UML:GraphEdge.waypoints"
            mode="deploymentDiagram"/>
    <xsl:template match="UML:SimpleSemanticModelElement[@typeInfo='ProvidedInterfaceEdge']" mode="deploymentDiagram">
        <UML:SimpleSemanticModelElement xmi.id="{@xmi.id}" presentation="" typeInfo="ProvidedInterfaceLink"/>
    </xsl:template>
    <xsl:template match="UML:SimpleSemanticModelElement[@typeInfo='RequiredInterfaceEdge']" mode="deploymentDiagram">
        <UML:SimpleSemanticModelElement xmi.id="{@xmi.id}" presentation="" typeInfo="RequiredInterfaceLink"/>
    </xsl:template>
    <xsl:template match="node()|@*" priority="-10" mode="fixChildPositionDeploymentDiagram">
        <xsl:param name="typeInfo"/>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" mode="fixChildPositionDeploymentDiagram">
                <xsl:with-param name="typeInfo" select="$typeInfo"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>
</xsl:transform>
