<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstra�e 12, 20357 Hamburg, Germany
-->

<xsl:transform version="1.0" xmlns:UML="org.omg.xmi.namespace.UML" xmlns:UML2="org.omg.xmi.namespace.UML2"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!-- throw away all graph nodes contained in a transition edge adornment -->

    <xsl:key match="//UML2:State" name="uml2State" use="@xmi.id"/>
    <!-- UML:Diagram/UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='StateDiagram']/../..//UML:GraphElement.contained/* -->
    <xsl:key
            match="UML:Diagram[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='StateDiagram'] and UML:Diagram.owner/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element[UML:StateMachine]]//UML:GraphElement.contained/*"
            name="elementsUnderStateDiagram" use="@xmi.id"/>

    <!--<xsl:template match="//UML:GraphEdge[boolean(key('elementsUnderStateDiagram', @xmi.id))]|//UML:GraphNode[boolean(key('elementsUnderStateDiagram', @xmi.id))]">-->
    <!--<xsl:apply-templates select="node()" mode="innerElements"/>-->
    <!--</xsl:template>-->

    <xsl:template
            match="//UML:GraphEdge[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element[UML:Transition]]/UML:GraphElement.contained/UML:GraphNode/UML:GraphElement.contained/*"/>

    <xsl:template
            match="//UML:GraphElement.contained/UML:GraphNode[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='InternalTransitionCompartment']]"/>

    <xsl:template
            match="//UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element[UML:SimpleState|UML:CompositeState]]/UML:GraphElement.contained/UML:GraphNode[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='CompartmentSeparator']]"/>

    <xsl:template
            match="//UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element[UML:SynchState]]/UML:GraphElement.contained/UML:GraphNode[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='Name' or @typeInfo='StereotypeCompartment']]"/>

    <xsl:template
            match="//UML:GraphEdge[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element[UML:Transition]]/UML:GraphElement.contained//UML:GraphNode/UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='TransitionDescription']">
        <xsl:call-template name="generateSimpleTypeInfo">
            <xsl:with-param name="typeInfo">StateTransitionDescription</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="UML:SimpleSemanticModelElement[@typeInfo='ActivityDescription']">
        <UML:SimpleSemanticModelElement>
            <xsl:for-each select="@*">
                <xsl:variable name="elementName" select="name()"/>
                <xsl:choose>
                    <xsl:when test="$elementName = 'typeInfo'">
                        <xsl:attribute name="typeInfo">OpaqueBehaviorDescription</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:copy-of select="current()"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </UML:SimpleSemanticModelElement>
    </xsl:template>

    <xsl:template match="//UML:GraphNode[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='SubStateCompartment']]">
        <xsl:element name="UML:GraphNode">
            <xsl:attribute name="isVisible">true</xsl:attribute>
            <xsl:attribute name="xmi.id">
                <xsl:value-of select="@xmi.id"/>
            </xsl:attribute>
            <xsl:copy-of select="UML:GraphElement.position"/>
            <xsl:copy-of select="UML:GraphNode.size"/>
            <xsl:element name="UML:GraphElement.semanticModel">
                <xsl:call-template name="generateSimpleTypeInfo">
                    <xsl:with-param name="typeInfo">RegionCompartment</xsl:with-param>
                </xsl:call-template>
            </xsl:element>
            <xsl:element name="UML:GraphElement.contained">
                <xsl:element name="UML:GraphNode">
                    <xsl:attribute name="isVisible">true</xsl:attribute>
                    <xsl:attribute name="xmi.id">
                        <xsl:call-template name="generateXmiId"/>
                    </xsl:attribute>

                    <xsl:copy-of select="UML:GraphElement.position"/>
                    <xsl:copy-of select="UML:GraphNode.size"/>
                    <xsl:element name="UML:GraphElement.semanticModel">
                        <xsl:element name="UML:Uml1SemanticModelBridge">
                            <xsl:attribute name="presentation"/>
                            <xsl:attribute name="xmi.id">
                                <xsl:call-template name="generateXmiId"/>
                            </xsl:attribute>
                            <xsl:element name="UML:Uml1SemanticModelBridge.element">
                                <xsl:element name="UML2:Region">
                                    <xsl:attribute name="xmi.idref">
                                        <xsl:variable name="stateXmiId">
                                            <xsl:value-of
                                                    select="../../UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element//@xmi.idref"/>
                                        </xsl:variable>
                                        <xsl:value-of select="key('uml2State', $stateXmiId)/UML2:State.region/UML2:Region/@xmi.id"/>
                                    </xsl:attribute>
                                </xsl:element>
                            </xsl:element>
                        </xsl:element>
                    </xsl:element>
                    <xsl:element name="UML:GraphElement.contained">
                        <xsl:apply-templates select="UML:GraphElement.contained/*"/>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <xsl:template name="generateSimpleTypeInfo">
        <xsl:param name="typeInfo"/>
        <xsl:element name="UML:SimpleSemanticModelElement">
            <xsl:attribute name="xmi.id">
                <xsl:call-template name="generateXmiId"/>
            </xsl:attribute>
            <xsl:attribute name="presentation"/>
            <xsl:attribute name="typeInfo">
                <xsl:value-of select="$typeInfo"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

</xsl:transform>
