<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstra�e 12, 20357 Hamburg, Germany
-->

<xsl:transform version="1.0" xmlns:UML="org.omg.xmi.namespace.UML" xmlns:UML2="org.omg.xmi.namespace.UML2"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:key match="/XMI/XMI.content//*" name="allElementsWithXmid" use="@xmi.id"/>


    <xsl:template match="node()" mode="copyElementChangeXmiId">
        <xsl:variable name="elementName">
            <xsl:value-of select="name()"/>
        </xsl:variable>
        <xsl:variable name="xmiId">
            <xsl:value-of select="@xmi.id"/>
        </xsl:variable>

        <xsl:element name="{$elementName}">
            <xsl:if test="boolean(@xmi.id)">
                <xsl:attribute name="xmi.idref">
                    <xsl:value-of select="@xmi.id"/>
                </xsl:attribute>
            </xsl:if>
        </xsl:element>
    </xsl:template>

    <xsl:template
            match="UML:ClassifierInState.inState/UML:CompositeState[boolean(key('allElementsWithXmid', @xmi.idref)[local-name() != 'State']) and @xmi.idref]">
        <xsl:variable name="xmiIdRef" select="@xmi.idref"/>
        <xsl:apply-templates select="key('allElementsWithXmid', $xmiIdRef)/../.." mode="copyElementChangeXmiId"/>
    </xsl:template>
    <!-- Convert references to the newly converted elements -->
    <xsl:key match="//UML:DeleteMe" name="deleteMeWithId" use="@id"/>

    <xsl:template match="*[@xmi.idref and local-name()!='TagDefinition' and local-name()!='Message' and empty(key('deleteMeWithId', @xmi.idref))]"
                  priority="-20">
        <xsl:variable name="xmiIdRef" select="@xmi.idref"/>
        <xsl:variable name="applyedElements" select="key('allElementsWithXmid', $xmiIdRef)"/>

        <xsl:choose>
            <xsl:when test="count($applyedElements) = 1">
                <xsl:apply-templates select="$applyedElements" mode="copyElementChangeXmiId"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="$applyedElements[1]" mode="copyElementChangeXmiId"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:transform>
