<?xml version="1.0" encoding="ISO-8859-1"?>

<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstra�e 12, 20357 Hamburg, Germany
-->
<xsl:transform version="1.0" xmlns:UML="org.omg.xmi.namespace.UML" xmlns:UML2="org.omg.xmi.namespace.UML2"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="UML:Model/UML:Namespace.ownedElement">
        <xsl:copy>
            <xsl:choose>
                <xsl:when test="not($parameterVoidXmiIdFound)">
                    <xsl:call-template name="addJavaPackage"/>
                    <xsl:apply-templates select="*[not(local-name()='Package' and @name='java')]"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:copy>
    </xsl:template>

    <xsl:template name="addJavaPackage">
        <xsl:choose>
            <xsl:when test="not(UML:Package[@name='java'])">
                <xsl:call-template name="addMessage">
                    <xsl:with-param name="message">
                        <xsl:text>Package java will be generated.</xsl:text>
                    </xsl:with-param>
                </xsl:call-template>
                <xsl:element name="UML:Package">
                    <xsl:attribute name="xmi.id">
                        <xsl:call-template name="generateXmiId"/>
                    </xsl:attribute>
                    <xsl:attribute name="name">java</xsl:attribute>
                    <xsl:call-template name="addCommonAttributes"/>

                    <xsl:element name="UML:Namespace.ownedElement">
                        <xsl:call-template name="addLangPackage"/>
                    </xsl:element>
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="@*"/>
                <xsl:apply-templates select="UML:Package[@name='java']" mode="addPackage"/>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <xsl:template match="UML:Package[@name='java'][1]" mode="addPackage">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:element name="UML:Namespace.ownedElement">
                <xsl:choose>
                    <xsl:when test="UML:Namespace.ownedElement">
                        <xsl:apply-templates select="UML:Namespace.ownedElement" mode="addPackage"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="addLangPackage"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>

            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>

    <xsl:template name="addLangPackage" match="UML:Namespace.ownedElement" mode="addPackage">
        <xsl:choose>
            <xsl:when test="not(UML:Package[@name='lang'])">
                <xsl:element name="UML:Package">
                    <xsl:attribute name="xmi.id">
                        <xsl:call-template name="generateXmiId"/>
                    </xsl:attribute>
                    <xsl:attribute name="name">lang</xsl:attribute>
                    <xsl:call-template name="addCommonAttributes"/>
                    <xsl:element name="UML:Namespace.ownedElement">
                        <xsl:call-template name="addVoidDataType"/>
                    </xsl:element>
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="@*"/>
                <xsl:apply-templates mode="addPackage"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="UML:Package[@name='lang'][1]" mode="addPackage">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:element name="UML:Namespace.ownedElement">
                <xsl:choose>
                    <xsl:when test="UML:Namespace.ownedElement">
                        <xsl:apply-templates select="UML:Namespace.ownedElement" mode="addVoidDataTypeMode"/>
                        <xsl:apply-templates select="UML:Namespace.ownedElement/*"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="addVoidDataType"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>

        </xsl:copy>
    </xsl:template>

    <xsl:template name="addVoidDataType" match="node()" mode="addVoidDataTypeMode">
        <xsl:if test="not(UML:DataType[@name='void'])">
            <xsl:element name="UML:DataType">
                <xsl:attribute name="xmi.id">
                    <xsl:value-of select="$parameterVoidXmiId"/>
                </xsl:attribute>
                <xsl:attribute name="name">void</xsl:attribute>
                <xsl:call-template name="addCommonAttributes"/>
            </xsl:element>
        </xsl:if>
    </xsl:template>
</xsl:transform>
