<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstra�e 12, 20357 Hamburg, Germany
-->
<xsl:transform version="1.0"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               xmlns:UML="org.omg.xmi.namespace.UML"
               xmlns:UML2="org.omg.xmi.namespace.UML2"
               xmlns:IntermediateInteraction="java:com.gentleware.poseidon.uml.model_conversion.sequence_diagrams.IntermediateInteraction"
               xmlns:IntermediateLifeline="java:com.gentleware.poseidon.uml.model_conversion.sequence_diagrams.IntermediateLifeline"
               xmlns:IntermediateMessage="java:com.gentleware.poseidon.uml.model_conversion.sequence_diagrams.IntermediateMessage"
               xmlns:IntermediateInteractionConverter="java:com.gentleware.poseidon.uml.model_conversion.sequence_diagrams.IntermediateInteractionConverter">

    <xsl:key name="modelElementWithXmiId" match="UML:*" use="@xmi.id"/>

    <xsl:template match="UML:Model/UML:Namespace.ownedElement[//UML:CreateAction]">
        <!--<xsl:if test="function-available('IntermediateMessage:getCreateStereotypeXmiId')">-->
        <xsl:element name="UML:Namespace.ownedElement">
            <xsl:element name="UML:Stereotype">
                <xsl:attribute name="xmi.id" select="IntermediateMessage:getCreateStereotypeXmiId()"/>
                <xsl:attribute name="name">create</xsl:attribute>
            </xsl:element>
            <xsl:apply-templates/>
        </xsl:element>
        <!--</xsl:if>-->
    </xsl:template>

    <xsl:template match="UML:Collaboration/UML:Namespace.ownedElement[UML:CollaborationInstanceSet]">
        <xsl:for-each select="UML:CollaborationInstanceSet">
            <xsl:variable name="diagramOwnerXmiId" select="@xmi.id"/>
            <xsl:element name="UML2:BehavioredClassifier.ownedBehavior">
                <xsl:variable name="sequenceDiagrams"
                              select="//UML:Diagram[UML:Diagram.owner/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:CollaborationInstanceSet[@xmi.idref=$diagramOwnerXmiId]]"/>

                <xsl:choose>
                    <xsl:when test="count($sequenceDiagrams) > 1">
                        <xsl:apply-templates select="$sequenceDiagrams[1]" mode="convertSemanticModel"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="$sequenceDiagrams" mode="convertSemanticModel"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>
        </xsl:for-each>
        <xsl:element name="UML:Namespace.ownedElement">
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UML:Diagram[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='SequenceDiagram']]"
                  mode="convertSemanticModel">
        <xsl:variable name="diagramOwnerXmiId"
                      select="UML:Diagram.owner/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:CollaborationInstanceSet/@xmi.idref"/>
        <xsl:element name="UML:DeleteMe">
            <xsl:attribute name="id" select="$diagramOwnerXmiId"/>
        </xsl:element>
        <xsl:variable name="name" select="@name"/>

        <xsl:if test="function-available('IntermediateInteractionConverter:logTransformMessage')">
            <xsl:variable name="intermediateInteraction"
                          select="IntermediateInteractionConverter:createIntermediateInteraction($diagramOwnerXmiId, $name)"/>

            <xsl:apply-templates mode="createIntermediateLifelines">
                <xsl:with-param name="intermediateInteraction" select="$intermediateInteraction"/>
            </xsl:apply-templates>

            <xsl:apply-templates mode="createIntermediateMessages">
                <xsl:with-param name="intermediateInteraction" select="$intermediateInteraction"/>
            </xsl:apply-templates>

            <xsl:sequence select="IntermediateInteractionConverter:convertToUml2Interaction($intermediateInteraction)"/>
            <xsl:variable name="intermediateInteractionDocument" select="document(concat('convert://Uml2Interaction', $diagramOwnerXmiId))"/>
            <xsl:sequence select="$intermediateInteractionDocument/*"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="UML:Diagram[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='SequenceDiagram']]">
        <UML:Diagram>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates mode="removeUnneccessaaryDi"/>
        </UML:Diagram>
    </xsl:template>

    <xsl:template
            match="UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Object]/UML:GraphElement.contained/*"
            mode="removeUnneccessaaryDi"/>

    <xsl:template match="UML:GraphEdge[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Link]"
                  mode="removeUnneccessaaryDi"/>

    <xsl:template
            match="UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Object]/UML:GraphElement.anchorage/UML:GraphConnector[key('modelElementWithXmiId', 'UML:GraphConnector.graphEdge/UML:GraphEdge/@xmi.idref')/UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element]"
            mode="removeUnneccessaaryDi"/>

    <xsl:template match="node()|@*" priority="-1" mode="removeUnneccessaaryDi">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" mode="removeUnneccessaaryDi"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Object]"
                  mode="createIntermediateLifelines">
        <xsl:param name="intermediateInteraction"/>

        <xsl:variable name="xmiId"
                      select="UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Object/@xmi.idref"/>
        <xsl:element name="UML:DeleteMe">
            <xsl:attribute name="id" select="$xmiId"/>
        </xsl:element>
        <xsl:variable name="object" select="key('modelElementWithXmiId', $xmiId)"/>
        <xsl:variable name="name" select="$object/@name"/>
        <xsl:variable name="typeXmiId" select="$object/UML:Instance.classifier//@xmi.idref"/>
        <xsl:variable name="typeMetaClass" select="local-name($object/UML:Instance.classifier/UML:*)"/>
        <xsl:variable name="objectStereotypes" select="$object/UML:ModelElement.stereotype/UML:Stereotype"/>

        <xsl:variable name="intermediateLifeline"
                      select="IntermediateInteractionConverter:createIntermediateLifeline($intermediateInteraction, $xmiId, $name, $typeXmiId, $typeMetaClass)"/>

        <xsl:for-each select="$objectStereotypes">
            <xsl:sequence select="IntermediateLifeline:addStereotypeXmiId($intermediateLifeline, @xmi.idref)"/>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="UML:GraphEdge[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Link]"
                  mode="createIntermediateMessages">
        <xsl:param name="intermediateInteraction"/>

        <xsl:variable name="diagram" select="//UML:Diagram[UML:GraphElement.contained/.]"/>
        <xsl:variable name="linkXmiId"
                      select="UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Link/@xmi.idref"/>
        <xsl:variable name="stimulus" select="//UML:Stimulus[UML:Stimulus.communicationLink/UML:Link[@xmi.idref=$linkXmiId]]"/>
        <xsl:variable name="stimulusXmiId" select="$stimulus/@xmi.id"/>
        <xsl:variable name="messages" select="//UML:Message[UML:Message.conformingStimulus/UML:Stimulus[@xmi.idref=$stimulusXmiId]]"/>

        <xsl:for-each select="$messages">
            <xsl:if test="not(UML:Message.predecessor)">
                <xsl:call-template name="addIntermediateMessage">
                    <xsl:with-param name="intermediateInteraction" select="$intermediateInteraction"/>
                    <xsl:with-param name="message" select="."/>
                    <xsl:with-param name="diagram" select="$diagram"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="addIntermediateMessage">
        <xsl:param name="intermediateInteraction"/>
        <xsl:param name="message"/>
        <xsl:param name="diagram"/>

        <xsl:if test="local-name($message)='Message'">
            <xsl:call-template name="createIntermediateMessage">
                <xsl:with-param name="intermediateInteraction" select="$intermediateInteraction"/>
                <xsl:with-param name="message" select="$message"/>
            </xsl:call-template>

            <xsl:variable name="predecessorMessages" select="//UML:Message[UML:Message.predecessor/UML:Message[@xmi.idref=$message/@xmi.id]]"/>
            <xsl:for-each select="$predecessorMessages">
                <xsl:choose>
                    <xsl:when
                            test="$diagram/UML:GraphElement.contained/UML:GraphEdge/UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Message[@xmi.idref=@xmi.id]">
                        <xsl:call-template name="addIntermediateMessage">
                            <xsl:with-param name="intermediateInteraction" select="$intermediateInteraction"/>
                            <xsl:with-param name="message" select="."/>
                            <xsl:with-param name="diagram" select="$diagram"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="UML:DeleteMe">
                            <xsl:attribute name="id" select="@xmi.id"/>
                        </xsl:element>

                        <xsl:variable name="stimulusXmiId" select="./UML:Message.conformingStimulus/UML:Stimulus/@xmi.idref"/>
                        <xsl:element name="UML:DeleteMe">
                            <xsl:attribute name="id" select="$stimulusXmiId"/>
                        </xsl:element>
                        <xsl:variable name="stimulus" select="key('modelElementWithXmiId', $stimulusXmiId)"/>

                        <xsl:variable name="linkXmiId" select="$stimulus/UML:Stimulus.communicationLink/UML:Link/@xmi.idref"/>
                        <xsl:element name="UML:DeleteMe">
                            <xsl:attribute name="id" select="$linkXmiId"/>
                        </xsl:element>

                        <xsl:variable name="senderXmiId" select="$stimulus/UML:Stimulus.sender/UML:Object/@xmi.idref"/>
                        <xsl:element name="UML:DeleteMe">
                            <xsl:attribute name="id" select="$senderXmiId"/>
                        </xsl:element>

                        <xsl:variable name="receiverXmiId" select="$stimulus/UML:Stimulus.receiver/UML:Object/@xmi.idref"/>
                        <xsl:element name="UML:DeleteMe">
                            <xsl:attribute name="id" select="$receiverXmiId"/>
                        </xsl:element>

                        <xsl:variable name="dispatchActionXmiId" select="$stimulus/UML:Stimulus.dispatchAction//@xmi.idref"/>
                        <xsl:element name="UML:DeleteMe">
                            <xsl:attribute name="id" select="$dispatchActionXmiId"/>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>

    <xsl:template name="createIntermediateMessage">
        <xsl:param name="intermediateInteraction"/>
        <xsl:param name="message"/>

        <xsl:variable name="xmiId" select="$message/@xmi.id"/>
        <xsl:element name="UML:DeleteMe">
            <xsl:attribute name="id" select="$xmiId"/>
        </xsl:element>

        <xsl:variable name="stimulusXmiId" select="$message/UML:Message.conformingStimulus/UML:Stimulus/@xmi.idref"/>
        <xsl:element name="UML:DeleteMe">
            <xsl:attribute name="id" select="$stimulusXmiId"/>
        </xsl:element>
        <xsl:variable name="stimulus" select="key('modelElementWithXmiId', $stimulusXmiId)"/>
        <xsl:variable name="stimulusName" select="$stimulus/@name"/>

        <xsl:variable name="linkXmiId" select="$stimulus/UML:Stimulus.communicationLink/UML:Link/@xmi.idref"/>
        <xsl:element name="UML:DeleteMe">
            <xsl:attribute name="id" select="$linkXmiId"/>
        </xsl:element>
        <xsl:variable name="link" select="key('modelElementWithXmiId', $linkXmiId)"/>
        <xsl:variable name="linkStereotypes" select="$link/UML:ModelElement.stereotype/UML:Stereotype"/>

        <xsl:variable name="senderXmiId" select="$stimulus/UML:Stimulus.sender/UML:Object/@xmi.idref"/>
        <xsl:element name="UML:DeleteMe">
            <xsl:attribute name="id" select="$senderXmiId"/>
        </xsl:element>

        <xsl:variable name="receiverXmiId" select="$stimulus/UML:Stimulus.receiver/UML:Object/@xmi.idref"/>
        <xsl:element name="UML:DeleteMe">
            <xsl:attribute name="id" select="$receiverXmiId"/>
        </xsl:element>

        <xsl:variable name="dispatchActionXmiId" select="$stimulus/UML:Stimulus.dispatchAction//@xmi.idref"/>
        <xsl:element name="UML:DeleteMe">
            <xsl:attribute name="id" select="$dispatchActionXmiId"/>
        </xsl:element>

        <xsl:variable name="dispatchAction" select="key('modelElementWithXmiId', $dispatchActionXmiId)"/>
        <xsl:variable name="operationXmiId" select="$dispatchAction/UML:CallAction.operation/UML:Operation/@xmi.idref"/>
        <xsl:variable name="operation" select="key('modelElementWithXmiId', $operationXmiId)"/>
        <xsl:variable name="actionName" select="$dispatchAction/@name"/>
        <xsl:variable name="actionExpression" select="$dispatchAction/UML:Action.script/UML:ActionExpression/@body"/>

        <xsl:variable name="actionType" select="local-name($dispatchAction)"/>
        <xsl:variable name="isCall" select="$actionType='CallAction'"/>
        <xsl:variable name="isCreate" select="$actionType='CreateAction'"/>
        <xsl:variable name="isReturn" select="$actionType='ReturnAction'"/>
        <xsl:variable name="isDestroy" select="$actionType='DestroyAction'"/>
        <xsl:variable name="isSynchronous" select="$dispatchAction/@isAsynchronous='false'"/>

        <xsl:choose>
            <xsl:when test="$operationXmiId">
                <xsl:variable name="name" select="$operation/@name"/>
                <xsl:variable name="intermediateMessage"
                              select="IntermediateInteractionConverter:createIntermediateCallMessage($intermediateInteraction, $xmiId, $name, $senderXmiId, $receiverXmiId, $isSynchronous, $operationXmiId)"/>
                <xsl:for-each select="$dispatchAction/UML:Action.actualArgument/*">
                    <xsl:variable name="expression" select="UML:Argument.value/UML:Expression"/>
                    <xsl:variable name="language" select="$expression/@language"/>
                    <xsl:variable name="body" select="$expression/@body"/>
                    <xsl:sequence select="IntermediateInteractionConverter:createIntermediateExpression($intermediateMessage, $language, $body)"/>
                </xsl:for-each>
                <xsl:for-each select="$linkStereotypes">
                    <xsl:sequence select="IntermediateMessage:addStereotypeXmiId($intermediateMessage, @xmi.idref)"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="viewedActionName"
                              select="if ($actionName and string-length($actionName)=0) then $actionExpression else $actionName"/>
                <xsl:variable name="messageName" select="string-join(($stimulusName, $viewedActionName), ':')"/>
                <xsl:variable name="intermediateMessage"
                              select="IntermediateInteractionConverter:createIntermediateMessage($intermediateInteraction, $xmiId, $messageName, $senderXmiId, $receiverXmiId, $isSynchronous, $isCall, $isReturn, $isDestroy, $isCreate)"/>
                <xsl:for-each select="$linkStereotypes">
                    <xsl:sequence select="IntermediateMessage:addStereotypeXmiId($intermediateMessage, @xmi.idref)"/>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:transform>