<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstra�e 12, 20357 Hamburg, Germany
-->

<xsl:transform version="1.0" xmlns:UML="org.omg.xmi.namespace.UML" xmlns:UML2="org.omg.xmi.namespace.UML2"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <!-- Rename State and process all subelements-->
    <xsl:template name="addUml2State" match="UML:StateMachine/UML:StateMachine.top//UML:SimpleState|/XMI/XMI.content/UML:SimpleState[@xmi.id]">
        <xsl:element name="UML2:State">
            <xsl:call-template name="apply-others"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UML:StateMachine/UML:StateMachine.top//UML:SynchState">
        <xsl:call-template name="addMessage">
            <xsl:with-param name="message">
                <xsl:text>Found SynchState:</xsl:text>
                <xsl:value-of select="@name"/>
                <xsl:call-template name="line-break"/>
                <xsl:text>SynchState is converted to an UML2 State, because it does not exist anymore in
                    the UML2 language specification.</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
        <xsl:call-template name="addUml2State"/>
    </xsl:template>

    <xsl:template match="UML:StateMachine/UML:StateMachine.top//UML:StateVertex.outgoing">
        <xsl:element name="UML2:Vertex.outgoing">
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UML:StateMachine/UML:StateMachine.top//UML:StateVertex.incoming">
        <xsl:element name="UML2:Vertex.incoming">
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UML:StateMachine/UML:StateMachine.top//UML:State.entry |
												 UML:StateMachine/UML:StateMachine.top//UML:State.exit | 
												 UML:StateMachine/UML:StateMachine.top//UML:State.doActivity">
        <xsl:variable name="localName2" select="local-name()"/>
        <xsl:element name="UML2:{$localName2}">
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UML:StateMachine/UML:StateMachine.top//UML:SynchState/@bound"/>

    <xsl:template match="UML:StateMachine/UML:StateMachine.top//UML:FinalState">
        <xsl:element name="UML2:FinalState">
            <xsl:call-template name="apply-others"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UML:StateMachine/UML:StateMachine.top//UML:Pseudostate">
        <xsl:element name="UML2:Pseudostate">
            <xsl:call-template name="apply-others"/>
        </xsl:element>
    </xsl:template>
</xsl:transform>
