<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstra�e 12, 20357 Hamburg, Germany
-->
<xsl:transform version="1.0" xmlns:UML="org.omg.xmi.namespace.UML" xmlns:UML2="org.omg.xmi.namespace.UML2"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <!--xsl:import href="utilities.xsl"/-->

    <xsl:key match="/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement/UML:TagDefinition" name="tagDefinitionName" use="@name"/>

    <xsl:template match="UML:StateMachine//UML:CallAction[@xmi.id]">
        <!-- Change CallAction to OpaqueBehavior -->
        <xsl:call-template name="insertOpaqueBehavior">
            <xsl:with-param name="callAction" select="."/>
        </xsl:call-template>
    </xsl:template>

    <!--<xsl:template match="UML:StateMachine//UML:CallAction[@xmi.id]/UML:ModelElement.taggedValue"/>-->
    <xsl:template match="UML:StateMachine//UML:CallAction[@xmi.id]/UML:Action.script"/>

    <xsl:template name="addTaggedValue" match="UML:StateMachine//UML:CallAction[@xmi.id]" mode="tagged-value-single">
        <xsl:param name="value"/>
        <xsl:param name="tagKey"/>

        <xsl:element name="UML:ModelElement.taggedValue">
            <xsl:choose>
                <!-- If the UML:ModelElement.taggedValue already exists, select the node
											so that all the contained tag values are copied.
											Otherwise just create the tagged value.-->
                <xsl:when test="UML:ModelElement.taggedValue">
                    <xsl:apply-templates select="UML:ModelElement.taggedValue" mode="tagged-value-single">
                        <xsl:with-param name="value" select="$value"/>
                        <xsl:with-param name="tagKey" select="$tagKey"/>
                    </xsl:apply-templates>
                    <xsl:apply-templates select="UML:ModelElement.taggedValue/*"/>

                </xsl:when>

                <xsl:otherwise>
                    <xsl:call-template name="addTaggedValue2">
                        <xsl:with-param name="value" select="$value"/>
                        <xsl:with-param name="tagKey" select="$tagKey"/>

                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>

    <!-- This template adds a TagDefinition and a TaggedValue to the actual node-->
    <xsl:template name="addTaggedValue2" mode="tagged-value-single" match="node()">
        <xsl:param name="value"/>
        <xsl:param name="tagKey"/>

        <xsl:element name="UML:TaggedValue">
            <xsl:attribute name="xmi.id">
                <xsl:call-template name="generateXmiId"/>
            </xsl:attribute>
            <xsl:attribute name="isSpecification">false</xsl:attribute>
            <xsl:element name="UML:TaggedValue.dataValue">
                <xsl:value-of select="$value"/>
            </xsl:element>
            <xsl:element name="UML:TaggedValue.type">
                <xsl:element name="UML:TagDefinition">
                    <xsl:choose>
                        <!--Prove if tagged definition already exists-->
                        <xsl:when test="key('tagDefinitionName', $tagKey)">
                            <xsl:attribute name="xmi.idref">
                                <xsl:value-of select="key('tagDefinitionName', $tagKey)/@xmi.id"/>
                            </xsl:attribute>
                        </xsl:when>

                        <!--Create tagged definition-->
                        <xsl:otherwise>
                            <xsl:variable name="tagDefId">
                                <xsl:call-template name="generateXmiId"/>
                            </xsl:variable>

                            <xsl:attribute name="xmi.idref">
                                <xsl:value-of select="$tagDefId"/>
                            </xsl:attribute>

                            <xsl:call-template name="addTagDefinition">
                                <xsl:with-param name="tagKey" select="$tagKey"/>
                                <xsl:with-param name="tagDefId" select="$tagDefId"/>
                            </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <!-- This template will add a tag definition to the current node-->
    <xsl:template name="addTagDefinition">
        <xsl:param name="tagKey"/>
        <xsl:param name="tagDefId"/>

        <xsl:element name="UML:TagDefinition">
            <xsl:attribute name="xmi.id">
                <xsl:value-of select="$tagDefId"/>
            </xsl:attribute>
            <xsl:attribute name="name">
                <xsl:value-of select="$tagKey"/>
            </xsl:attribute>
            <xsl:attribute name="isSpecification">false</xsl:attribute>

            <xsl:element name="UML:TagDefinition.multiplicity">

                <xsl:element name="UML:Multiplicity">
                    <xsl:attribute name="xmi.id">
                        <xsl:call-template name="generateXmiId"/>
                    </xsl:attribute>

                    <xsl:element name="UML:Multiplicity.range">
                        <xsl:element name="UML:MultiplicityRange">
                            <xsl:attribute name="xmi.id">
                                <xsl:call-template name="generateXmiId"/>
                            </xsl:attribute>
                            <xsl:attribute name="lower">1</xsl:attribute>
                            <xsl:attribute name="upper">1</xsl:attribute>
                        </xsl:element>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <xsl:template
            match="UML2:StateMachine//UML2:State.entry/UML2:Activity|
            UML2:StateMachine//UML2:State.doActivity/UML2:Activity|
            UML2:StateMachine//UML2:State.exit/UML2:Activity|
            UML2:StateMachine//UML2:Transition.effect/UML2:Activity">
        <xsl:call-template name="insertOpaqueBehavior">
            <xsl:with-param name="callAction" select="node()"/>
        </xsl:call-template>
    </xsl:template>

</xsl:transform>
