<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstra�e 12, 20357 Hamburg, Germany
-->
<xsl:transform version="1.0" xmlns:UML="org.omg.xmi.namespace.UML" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               xmlns:UML2="org.omg.xmi.namespace.UML2">
    <xsl:output indent="yes" method="xml" encoding="UTF-8"/>
    <!-- xsl:preserve-space elements="* @*"/-->
    <!-- Copy nodes or attributes -->
    <xsl:template match="node()|@*" priority="-20">
        <xsl:copy>
            <xsl:apply-templates select="node()|@*"/>
        </xsl:copy>
    </xsl:template>
    <xsl:template name="line-break">
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>
    <xsl:template name="apply-others">
        <xsl:apply-templates select="@*"/>
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template name="addMessage">
        <xsl:param name="message"/>
        <xsl:if test="function-available('GW:logTransformMessage')" xmlns:GW="com.gentleware.poseidon.uml.model_conversion.XmiXsltConverter">
            <xsl:value-of select="GW:logTransformMessage($message)" xmlns:GW="com.gentleware.poseidon.uml.model_conversion.XmiXsltConverter"/>
        </xsl:if>
    </xsl:template>
    <xsl:template name="generateXmiId">
        <xsl:if test="function-available('Id:createNewXmiId')" xmlns:Id="com.gentleware.jboogie.kernel.Id">
            <xsl:value-of select="Id:createNewXmiId()" xmlns:Id="com.gentleware.jboogie.kernel.Id"/>
        </xsl:if>
    </xsl:template>
    <xsl:template name="addCommonAttributes">
        <xsl:attribute name="isSpecification">false</xsl:attribute>
        <xsl:attribute name="isRoot">false</xsl:attribute>
        <xsl:attribute name="isLeaf">false</xsl:attribute>
        <xsl:attribute name="isAbstract">false</xsl:attribute>
    </xsl:template>
    <xsl:template name="insertOpaqueBehavior">
        <xsl:param name="callAction"/>
        <xsl:element name="UML2:OpaqueBehavior">
            <xsl:copy-of select="$callAction/@xmi.id"/>
            <xsl:copy-of select="$callAction/@name"/>
            <xsl:for-each select="$callAction/@*">
                <xsl:variable name="elementName" select="name($callAction)"/>
                <xsl:choose>
                    <xsl:when test="$elementName = 'body' or $elementName = 'language'"/>
                    <xsl:when test="$elementName = 'isAsynchronous'">
                        <xsl:variable name="isAsynchronous" select="."/>
                        <xsl:apply-templates select=".." mode="tagged-value-single">
                            <xsl:with-param name="value" select="$isAsynchronous"/>
                            <xsl:with-param name="tagKey" select="$elementName"/>
                        </xsl:apply-templates>
                    </xsl:when>
                    <xsl:otherwise>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <xsl:element name="UML2:OpaqueBehavior.body">
                <xsl:value-of select="$callAction/UML:Action.script/UML:ActionExpression/@body"/>
            </xsl:element>
            <xsl:element name="UML2:OpaqueBehavior.language">
                <xsl:value-of select="$callAction/UML:Action.script/UML:ActionExpression/@language"/>
            </xsl:element>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
    <xsl:template name="insertOpaqueExpression">
        <xsl:param name="callAction"/>
        <xsl:param name="elementWithName"/>
        <xsl:element name="UML2:OpaqueExpression">
            <xsl:copy-of select="$callAction/@*"/>
            <xsl:if test="$elementWithName">
                <xsl:copy-of select="$elementWithName/@name"/>
            </xsl:if>
        </xsl:element>
    </xsl:template>
    <xsl:template name="add-xmi-id-attribute">
        <xsl:attribute name="xmi.id">
            <xsl:call-template name="generateXmiId"/>
        </xsl:attribute>
    </xsl:template>
</xsl:transform>
