#!/usr/bin/env python

from distutils.core import setup

#  get the revision from the netstring package
import string
dict = {}
execfile('netstring.py', {}, dict)
version = string.split(dict['revision'])[1]

setup(
		name = 'python-netstring',
		version = version,
		py_modules = [ 'netstring' ],
		url = 'ftp://ftp.tummy.com/pub/tummy/Python/netstring/',
		author = 'Sean Reifschneider',
		author_email = '<jafo-netstring@tummy.com>',
		description = 'Functions for manipulation of net strings.  '\
				'(ftp://koobera.math.uic.edu/www/proto/netstrings.txt)',
		long_description = \
'''Functions for manipulation of net strings.

Netstrings (as described in ftp://koobera.math.uic.edu/www/proto/netstrings.txt)
are strings of the form "<length in bytes>:<string>,".  They allow the
programmer to allocate an appropriately sized buffer ahead of time, and also
to ensure that an entire string has been received (instead of relying on
parsing strings on CR-LF markers).''',
		)
