#--------------------------------------------------------------------------
#Copyright 2002, Jyrki Alakuijala and Hannu Helminen.
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 2 
#as published by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#--------------------------------------------------------------------------

class Personality:
  def __init__(m, **kw):
    # setup default values
    m.plys = 2
    m.pawnstructure = 1
    m.activityknight = 1
    m.activitybishop = 1
    m.activityrook = 1
    m.activityqueen = 1
    m.attack = 1
    m.center = 1
    m.randomness = 0.25

    m.randomize = ("pawnstructure", "activityknight", "activitybishop",
      "activityrook", "activityqueen", "attack", "center")
    for key in kw.keys():
      setattr(m, key, kw[key])
    m.origvalue = {}
    for keyword in m.randomize:
      m.origvalue[keyword] = getattr(m, keyword)

  def Randomize(m):
    from random import gauss 
    # a slightly different game
    for keyword in m.randomize:
      v = m.origvalue[keyword] * gauss(1.0, m.randomness)
      setattr(m, keyword, max(v, 0))

# These fictious names here are not associated with any real life persons.
# Even if they were, similarities between the playing style and
# their real-life character are purely coincidential.

persons = {
  "William" : Personality(plys = 0),
  "Craig" : Personality(plys=1, attack=3, activityqueen=3),
  "Ray" : Personality(plys=1, randomness=0.5),
  "Tim" : Personality(plys=1),
  "John" : Personality(plys=1, center=2.0),
  "Philip" : Personality(plys=1, center=2.0),
  "Larry" : Personality(plys=1, randomness=0.45),
  "Dennis" : Personality(plys=2, activityrook=1.5),
  "Linus" : Personality(plys=2, pawnstructure=1.6, attack=0.4, center=0),
  "Guido" : Personality(plys=2),
  "Richard" : Personality(plys=2,activityknight=2, attack=1.7),
  "Eric" : Personality(plys=2,activityrook=3, activityqueen=3, attack=2.2),
  "Jarkko" : Personality(plys=3, center=1.5, activityRook=1.5),
  "Ken" : Personality(plys=4)
}
