/* hamming.q: the Hamming problem adapted from Bird/Wadler */

/* Klaus Barthelmann 05-08-1994 */

include print;

merge (bin X Xs) (bin Y Ys)
			= bin X (merge Xs (bin Y Ys)) if X<Y;
			= bin Y (merge (bin X Xs) Ys) if X>Y;
			= bin X (merge Xs Ys) otherwise;

hamming			= bin 1 (merge (map (2*) hamming)
				 (merge (map (3*) hamming)
				  (map (5*) hamming)));
