
/* perms.q: generate a stream of permutations 05-07-1993 AG */

include print;

/* perms Xs: generate the stream of all permutations of the list Xs.
   For instance, say `print (perms (nums 1 6))'. */

perms []		= stream [[]];
perms Xs		= streamof [Y|Ys]
			  (Y in stream Xs, Ys in perms (filter (neq Y) Xs));

/* The same implemented directly, without using stream comprehensions.
   Essentially, this just saves one nested map and hence is a bit faster,
   but also less readable and not as straightforward to write. */

fastperms []		= stream [[]];
fastperms Xs		= streamcat (map (lambda X (map (cons X) (fastperms
			  (filter (neq X) Xs)))) (stream Xs)) otherwise;
