
/* scan.q: more accumulator functions on lists 05-01-00 AG */

public scanl F A Xs, scanl1 F Xs;
public scanr F A Xs, scanr1 F Xs;
public prepl F Xs X, prepr F X Xs;

/* scanl/scanl1 is a tail-recursive version of scan/scan1 */

scanl F A Xs:List	= reverse (foldl (prepl F) [A] Xs);
scanl1 F Xs:List	= scanl F (hd Xs) (tl Xs) if not null Xs;
			= [] otherwise;

/* scanr/scanr1 accumulates from right to left */

scanr F A Xs:List	= foldr (prepr F) [A] Xs;
scanr1 F Xs:List	= scanr F (last Xs) (init Xs) if not null Xs;
			= [] otherwise;

/* prepl/prepr prepends the next result computed from the given element
   and the head of the results computed so far */

prepl F Xs:List X	= [F (hd Xs) X|Xs];
prepr F X Xs:List	= [F X (hd Xs)|Xs];
