
/* regexamp.q: some examples for regular expression matching (see the
   clib documentation for details) */

/* convenience functions for splitting strings and performing replacements */

private regsplit OPTS REGEX S;

regsplit OPTS REGEX S	 = regex OPTS REGEX S regskip ++ [regskip];

special regsub ~OPTS ~REGEX ~S EXPR;

regsub OPTS REGEX S EXPR = strcat (regex OPTS REGEX S (regskip++EXPR)) ++
			   regskip;

/* environment parser example */

env         = regex "gn" "^([^=]+)=(.*)$" envget (reg 1,reg 2);

envget      = fget (popen "set" "r");

/* tiny lexical analyzer example */

def SYN	    = "([[:alpha:]][[:alnum:]]*)|(-?[[:digit:]]+)|([^[:space:]])";
def TOK     = (none,ident,num,id);

toks S      = regex "g" SYN S ((TOK!(hd regs)) (reg (hd regs)));
