
/* select.q: demonstration of the select function (UNIX only) */

/* check whether input is available from a file: */

avail F			= not null (select ([F],[],[],0)!0);

/* process input from a set of files, one line at a time */

loop FILES		= loop (proc FILES F)
			    where ([F|_],_,_) = select (FILES,[],[])
			    if not null FILES;
			= () otherwise;

proc FILES F		= // done with this file, get rid of it
			  filter (neq F) FILES
			    if feof F;
			= // process a line
			  writes (fgets F) || FILES;
