
/* $Id: bufdemo.q,v 1.2 2003/12/23 01:15:02 agraef Exp $

   bufdemo.q: Little alpha buffer demo, draws random boxes or lines with
   transparency until the user hits a key. Say `box_demo' or `line_demo' to
   run. */

import ggi;

/* Set the default visual and mode. */

def VIS = ggi_open (),
  _ = ggi_set_mode VIS "600x400.A8";

/* Determine visual geometry. */

def (W,H) = sscanf (ggi_get_mode VIS) "%dx%d";

/* Build a palette of color values. */

def COL = map color (nums 0 255), BLACK = hd COL, WHITE = last COL;

color I		= (shr I 5 and 7 * 0xffff div 7,
		   shr I 2 and 7 * 0xffff div 7,
		   I and 3 * 0xffff div 3);

/* Draw a box with the given color and transparency. */

draw_box P DIM C
		= ggi_set_foreground VIS C ||
		  ggi_draw_box VIS P DIM;

/* Draw a random box with random color and alpha. */

draw_rand_box	= draw_box (X,Y) (W,H) (R,G,B,A)
		    where X = rand 10 (W-100),
		      Y = rand 10 (H-100),
		      W = rand 30 (min (W div 2) (W-X-10)),
		      H = rand 30 (min (H div 2) (H-Y-10)),
		      (R,G,B) = COL!rand 1 255,
		      A = rand 1 0xffff;

/* Draw a line with the given color and transparency. */

draw_line P Q C	= ggi_set_foreground VIS C ||
		  ggi_draw_line VIS P Q;

/* Draw a random line with random color and alpha. */

draw_rand_line	= draw_line (X1,Y1) (X2,Y2) (R,G,B,A)
		    where X1 = rand 10 (W-10),
		      Y1 = rand 10 (H-10),
		      X2 = rand 10 (W-10),
		      Y2 = rand 10 (H-10),
		      (R,G,B) = COL!rand 1 255,
		      A = rand 1 0xffff;

rand MIN MAX	= MIN + random mod (MAX-MIN+1);

/* Draw random boxes until the user hits a key. */

box_demo	= show_msg || box_loop || hide_msg;

box_loop	= ggi_getc VIS || () if ggi_kbhit VIS;
		= draw_rand_box || box_loop otherwise;

/* Draw random lines until the user hits a key. */

line_demo	= show_msg || line_loop || hide_msg;

line_loop	= ggi_getc VIS || () if ggi_kbhit VIS;
		= draw_rand_line || line_loop otherwise;

def MSG = "Running, hit a key to stop";

show_msg	= ggi_clear VIS ||
		  ggi_set_foreground VIS WHITE ||
		  ggi_puts VIS (0,H-D) MSG
		    where (_,D) = ggi_get_string_size VIS MSG;

hide_msg	= ggi_set_foreground VIS BLACK ||
		  ggi_puts VIS (0,H-D) MSG
		    where (_,D) = ggi_get_string_size VIS MSG;
