
/* tk.q: interface to Tcl/Tk (AG Oct 20 2000) */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Basic operations *********************************************************/

/* The tk function executes a Tcl/Tk command line, and returns the result as a
   string value (or () if the result string is empty). In case of an error
   condition, `tk_error MSG' is returned, where MSG is the error message
   returned by the interpreter. (The calling Q script may provide a definition
   for tk_error to implement error handling as appropriate.)

   The tk function automatically starts a new instance of the interpreter if
   currently no interpreter is running in the current thread; if the
   interpreter for some reason cannot be started, an appropriate error message
   is passed to `tk_error'. When started, the interpreter creates the main
   window `.', which is required by Tk applications. (You can hide this window
   using the `tk "wm withdraw ."' command, and redisplay it with tk `"wm
   deiconify ."' when you need it.) The interpreter exits as soon as the main
   window is destroyed, or the hosting Q interpreter exits. You can also
   terminate the interpreter explicitly with the tk_quit function. */

public tk_error MSG;

/* tk CMD:String: execute a Tcl/Tk command */

public extern tk CMD;

/* tk_set NAME:String VAL:String, tk_unset NAME:String, tk_get NAME:String:
   set, unset and retrieve global variable values in the Tcl interpreter */

public extern tk_set NAME VAL, tk_unset NAME, tk_get NAME;

/* tk_quit: exit the current instance of the Tcl interpreter */

public extern tk_quit;

/* Event and callback processing ********************************************/

/* The tk module maintains an internal queue of "callback" messages sent back
   by the Tcl interpreter using the special `q' command. This (Tcl) command
   takes any number of arguments, concatenates them (with intervening spaces)
   to a single string, and queues that string for later processing. The
   following operations are used to check whether the interpreter is still up
   and running, whether any messages are available, and to access queued
   messages in a FIFO fashion. They also take care of event processing in the
   Tcl interpreter. */

/* tk_ready: check whether an interpreter is running */

public extern tk_ready;

/* tk_check: check whether a callback message is available */

public extern tk_check;

/* tk_reads: return the string of a callback message */

public extern tk_reads;

/* tk_read: read and evaluate a callback message (the message must denote a
   legal Q expression) */

public tk_read;

tk_read		= val tk_reads;

/* tk_readq: read a callback message and return it as a quoted expression */

public tk_readq;

tk_readq	= valq tk_reads;
