
/*  Q eQuational Programming System
    Copyright (c) 1991-2002 by Albert Graef
    <ag@muwiinfa.geschichte.uni-mainz.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* interface to the Q machine */

#include <stdio.h>

/* expression data structure */

typedef struct expr {
  int		refc;	/* reference count */
  short         fno;	/* function symbol/opcode */
  short		type;	/* type (0 if none) */
  short		argc;	/* expected arg count */
  unsigned int	red:1;	/* reducible-flag */
  unsigned int	pipe:1;	/* pipe flag */
#ifdef USE_THREADS
  unsigned int	sticky:1;	/* "sticky" bit */
  int		thrid:11;	/* id of owning thread */
#endif
  union {
    /* INTVALOP: */
    mpz_t		z;	/* big integer value */
    /* FLOATVALOP: */
    double              f;	/* floating point value */
    /* STRVALOP: */
    char	       *s;	/* string value */
    /* FILEVALOP: */
    FILE	       *fp;	/* file value */
    /* USRVALOP: */
    void	       *vp;	/* external value */
    /* VECTOP: */
    struct {
      int		n;	/* size */
      struct expr       **xv;	/* elements */
    } vect;
    /* CONSOP, PAIROP, APPOP: */
    struct {
      unsigned long	argv;	/* keep track of special forms */
      struct expr      *x1, *x2;/* arguments */
    } args;
    /* heap management */
    struct expr	       *xp;
  } data;
} EXPR;
