
/*  Q eQuational Programming System
    Copyright (c) 1991-2002 by Albert Graef
    <ag@muwiinfa.geschichte.uni-mainz.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/*

Q code instruction format:

Any Q code instruction consists of an opcode optionally followed
by some arguments. This format is implemented by the structure
described below. Here is a table of the different opcodes, their
meanings and mnemonics, and the arguments they take:

opcode		arguments	mnemonic    	meaning
-----------	---------------	-----------	-------------------------------
RETOP				!RET		return from rule
LVALOP      	lval		ofs$p1$p2...	push a lhs value
QUERYOP				?		abort rule if not true
MATCHOP		m		?MATCH #m	match (pattern binding)
INFOP		info		!INFO mno lno	source module and line no
POPOP				!POP		pop expression from stack
INTVALOP	iv		<number>	push an int constant
FLOATVALOP	fv		<number>	push a float constant
STRVALOP	sv		<string>	push a string constant
CONSOP                          [|]             construct a list node
PAIROP                          (|)             construct a pair node
APPOP                           @               apply

Other positive opcodes (ADDOP..) represent built-in and user-defined
symbols. Each instruction also contains a "mode" flag which is used to handle
special forms at runtime.

*/

enum opcodes {

/* reserved opcodes of the Q machine: */

        RETOP, LVALOP, QUERYOP, MATCHOP, DEFOP, UNDEFOP, INFOP, POPOP,
	INTVALOP, FLOATVALOP, STRVALOP, FILEVALOP, BADFILEVALOP, VECTOP,
	USRVALOP,

/* binary symbols: */

	CONSOP, PAIROP, APPOP,

/* built-in constants: */

	FALSEOP, TRUEOP, NILOP, VOIDOP,

/* operator symbols: */

	CATOP, ADDOP, MINOP, MULOP, FDIVOP, DIVOP, MODOP,
	POWOP, IDXOP, UMINOP, HASHOP, QUOTEOP, UNQUOTEOP, FORCEOP,

	OROP, ANDOP, ORELSEOP, ANDTHENOP, NOTOP,

	LEOP, GROP, EQOP, LEQOP, GEQOP, NEQOP, INOP, IDOP,

	SEQOP,

/* other predefined function symbols: */

	SHLOP, SHROP, PREDOP, SUCCOP,

	EXPOP, LNOP, SQRTOP, SINOP, COSOP, ATANOP, ATAN2OP, RANDOMOP, SEEDOP,

	SUBOP, SUBSTROP, POSOP,

	INTOP, FRACOP, TRUNCOP, ROUNDOP, FLOATOP, HASHNUMOP, ORDOP, CHROP,
	LISTOP, TUPLEOP, STROP, VALOP, STRQOP, VALQOP,

	ISSPECIALOP, ISCONSTOP, ISFUNOP, ISVAROP, ISDEFOP, FLIPOP,

	READOP, READQOP, READCOP, READSOP,
	WRITEOP, WRITEQOP, WRITECOP, WRITESOP,

	FREADOP, FREADQOP, FREADCOP, FREADSOP,
	FWRITEOP, FWRITEQOP, FWRITECOP, FWRITESOP,

	FOPENOP, POPENOP, FCLOSEOP, EOFOP, FEOFOP, FLUSHOP, FFLUSHOP,

	VERSIONOP, SYSINFOOP, WHICHOP, HALTOP, QUITOP, BREAKOP,
	CATCHOP, THROWOP, TRAPOP, FAILOP, SYSERROP,
	TIMEOP, SLEEPOP,
	
/* predefined variable symbols: */

	INPUTOP, OUTPUTOP, ERROROP, ARGSOP, DEFVAROP,

/* predefined type symbols: */

	NUMTYPE, INTTYPE, FLOATTYPE, STRTYPE, CHARTYPE, FILETYPE, LISTTYPE,
	TUPLETYPE, BOOLTYPE, EXCEPTTYPE, SYSEXCEPTTYPE,

/* built-in symbols stop here: */

	BUILTIN,

/* reserved symbols stop here: */

	RESERVED = CONSOP,

/* binary symbols stop here: */

	BINARY = FALSEOP,

/* operator symbols start and stop here */

	OPERATOR1 = CATOP, OPERATOR2 = SHLOP,

/* the following is reserved for use in the Q compiler: */

	VAROP = -1

};
