
/* sys.h: basic definitions and system-dependent stuff */

/*  Q eQuational Programming System
    Copyright (c) 1991-2002 by Albert Graef
    <ag@muwiinfa.geschichte.uni-mainz.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* Assumes a POSIXish system. Old-fashioned UNIX systems surely will need
   some work. */

#if defined (HAVE_CONFIG_H)
#  include "config.h"
#else
#  ifdef __MINGW32__
#    include "mingw.h"
#  endif
#endif

/* mangle internal function names in the interpreter, s.t. user modules
   do not accidentially call those on systems supporting back-linking */

#include "mangle.h"

/* system headers */

#ifdef USE_THREADS
/* make sure we also get the SUSV2 stuff (PTHREAD_MUTEX_RECURSIVE etc.) */
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE 500
#endif
#endif

/* we need various non-STDC stuff from Solaris */
#define __EXTENSIONS__

#ifdef HAVE_BACKTRACE
#ifdef HAVE_EXECINFO_H
#include <execinfo.h>
#endif
#endif

#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <math.h>

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

/* check for standard C headers */
#if STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr (), *strrchr ();
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include <sys/types.h>
#include <sys/stat.h>
#if HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
# define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
# define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

/* multithreading support */

#ifdef USE_THREADS
#include <pthread.h>
#endif

#ifndef _WIN32

/* libtool dlopen library */
#include "ltdl.h"

#else

/* simplistic "emulation" of lt_dlopen and friends with the Windows API */
#define LTDL_SET_PRELOADED_SYMBOLS() 
typedef void *lt_dlhandle, *lt_ptr;
extern int lt_dlinit(void), lt_dlexit(void), lt_dlclose(lt_dlhandle handle),
  lt_dlsetsearchpath(char *path);
extern lt_dlhandle lt_dlopen(char *filename), lt_dlopenext(char *filename);
extern lt_ptr lt_dlsym(lt_dlhandle handle, char *symbol);
extern char *lt_dlerror(void);

#endif

/* GNU readline, gmp and getopt */

#ifdef USE_READLINE
#ifdef READLINE_LIBRARY
#include "readline.h"
#include "history.h"
#else
#include <readline/readline.h>
#include <readline/history.h>
#endif
#endif
#include "gmp.h"
#if __GNU_MP_VERSION < 3
#error "Sorry, this program requires GMP V3 or later!"
#endif
/* work around a bug in some gmp versions */
#define my_mpz_fits_slong_p(z) (mpz_size(z) == 0 || mpz_fits_slong_p(z))
#include "getopt.h"

/* dmalloc support */

#ifdef DMALLOC
#include <dmalloc.h>
#endif

/* check for specific compilers */

/* make sure the _WIN32 symbol is defined for windows compilation */
#if defined(__MINGW32__) || defined(_MSC_VER)
#ifndef _WIN32
#define _WIN32 1
#endif
#endif

/* defines/includes for native win32 port using the MS libraries */

#ifdef _WIN32

#include <process.h>
#ifndef MSDOS
#define MSDOS 1
#endif

#endif

/* default QPATH */

#ifndef QPATH
#define QPATH ".:/usr/local/share/q/lib"
#endif

/* host system type (hardware-vendor-os) */

#ifndef SYSINFO
#define SYSINFO "unknown"
#endif

typedef unsigned char bool;
typedef unsigned char byte;

/* yytext declaration */

#ifndef YYTEXT_POINTER
#define YYTEXT_POINTER 0
#endif

#if YYTEXT_POINTER
#define DECLARE_YYTEXT extern char *yytext;
#else
#define DECLARE_YYTEXT extern char yytext[];
#endif

/* signal stuff: */

#ifndef RETSIGTYPE
#define RETSIGTYPE void
#endif

#if RETSIGTYPE == void
#define SIGHANDLER_RETURN(status) return
#else
#define SIGHANDLER_RETURN(status) return status
#endif

#ifdef MUST_REINSTALL_SIGHANDLERS
#define SIGHANDLER_RESTORE(sig,handler) syssignal(sig,handler)
#else
#define SIGHANDLER_RESTORE(sig,handler) /* nop */
#endif

/* functions */

#ifndef remove
#define remove unlink
#endif

typedef RETSIGTYPE (*sighandler_t)();
extern sighandler_t syssignal(int sig, sighandler_t handler);
extern void save_sigmask(void), restore_sigmask(void);

#ifndef sigint
#define sigint(handler) syssignal(SIGINT, handler)
#endif

#ifndef sigterm
#define sigterm(handler) syssignal(SIGTERM, handler)
#endif

#ifndef sighup
#ifdef SIGHUP
#define sighup(handler) syssignal(SIGHUP, handler)
#else
#define sighup(handler) SIG_IGN
#endif
#endif

#ifndef checkbrk
#define checkbrk (brkflag||quitflag)
#endif

#ifndef HAVE_STRDUP
extern char *strdup(char *s);
#endif

#ifndef HAVE_STRSTR
extern char *strstr(char *s, char *t);
#endif

#ifndef HAVE_MEMCPY
#if __GNUC__ > 1
#define memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else
extern void memcpy(char *to, char *from, int count);
#endif
#endif

#ifndef HAVE_MEMMOVE
#if __GNUC__ > 1
#define memmove(TO,FROM,COUNT)	__builtin_memmove(TO,FROM,COUNT)
#else
extern void memmove(char *to, char *from, int count);
#endif
#endif

#ifndef HAVE_MEMSET
#if __GNUC__ > 1
#define memset(S,C,COUNT)	__builtin_memset(S,C,COUNT)
#else
extern void memset(char *to, int c, int count);
#endif
#endif

#ifndef HAVE_MEMCMP
#if __GNUC__ > 1
#define memcmp(S1,S2,COUNT)	__builtin_memcmp(S1,S2,COUNT)
#else
extern int memcmp(char *s1, char *s2, int count);
#endif
#endif

#ifndef HAVE_SETLINEBUF
#define setlinebuf(fp) setvbuf(fp, NULL, _IOLBF, BUFSIZ)
#endif

extern double systime(void);
extern void syssleep(double t);

/* Filename parsing tokens. The generic syntax we assume is
   [<vol><vol-sep>]{<dir><dir-sep>}<name>.<ext> where <vol>, <dir> and <name>
   are arbitrary strings not containing any of the delimiters <vol-sep>,
   <dir-sep> and `.', which denote, respectively, the volume name, path and
   basename (without extension <ext>) of the file. Furthermore, it is assumed
   that `.' as a <dir> may denotes the current directory. The set of
   characters for <col-sep>|<dir-sep> and <vol-sep> are specified using the
   strings DIRSTR and VOLSTR, respectively. If your system has a different
   filename syntax, you will have to change the filename parsing and
   construction code in qbase.c. */

#ifndef DIRSTR
/* pathname (including volume) separators, first token should be standard
   <dir-sep> which is used for resolving pathnames */
#ifdef MSDOS
#define DIRSTR "/\\:"
#else /* UNIX */
#define DIRSTR "/"
#endif
#endif /* DIRSTR */

#ifndef VOLSTR
/* volume separators */
#ifdef MSDOS
#define VOLSTR ":"
#else /* UNIX */
#define VOLSTR ""
#endif
#endif /* VOLSTR */

/* PATHDELIM: delimiter for search path (: on UNIX, ; on MSDOS systems) */

#ifndef PATHDELIM
#ifdef MSDOS
#define PATHDELIM ';'
#else
#define PATHDELIM ':'
#endif
#endif
