
/* cond.q: conditional expressions 10-27-1993, revised 11-24-99, 12-7-00,
   7-24-01, 03-02-02, 03-22-02, 09-18-02 AG */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

include stdlib, lambda;

public special ifelse ~P X Y, matchp P ~X;

public switch CASES, match X CASES;

public special const case X Y, default X;

/* ifelse: Simple conditional expression. */

ifelse P:Bool X Y	= X if P;
			= Y otherwise;

/* matchp: Match a pattern against an expression. */

matchp [X1|Y1] [X2|Y2]	= matchp X1 X2 and then matchp Y1 Y2;
matchp (X1|Y1) (X2|Y2)	= matchp X1 X2 and then matchp Y1 Y2;
matchp (X1 Y1) (X2 Y2)	= matchp X1 X2 and then matchp Y1 Y2;
matchp X _		= true if isvar X;
matchp X X		= true;
matchp _ _		= false otherwise;

/* switch: General conditional expression, similar to Lisp's cond. */

switch (case P X)	= X if P;
			= () otherwise;
switch (case P X|CASES)	= X if P;
			= switch CASES otherwise;
switch (default X)	= X;
switch (default X|CASES)
			= X;
switch ()		= ();

/* match: Pattern-matching conditional expression. */

match X (case P Y)	= lambda P Y X if matchp P X;
			= () otherwise;
match X (case P Y|CASES)
			= lambda P Y X if matchp P X;
			= match X CASES otherwise;
match X (default Y)	= Y;
match X (default Y|CASES)
			= Y;
match X ()		= ();
