
/* string.q: additional string functions
   09-17-1992 AG, revised 03-30-1993, 10-19-93, 11-24-93, 03-02-02 AG */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

include stdlib;

/* chars. Split a string into a list of individual characters: */

public chars S;
private chars2 I L S;

chars S:String		= chars2 0 (#S) S;

chars2 I L S		= [] if I>=L;
			= [S!I|chars2 (I+1) L S] otherwise;
			
/* join. Concatenate a list of strings, interpolating the given DELIM string
   between each pair of consecutive strings in the list: */

public join DELIM Xs;

join DELIM:String []	= "";
join DELIM:String [X:String]
			= X;
join DELIM:String [X:String|Xs]
			= X++DELIM++join DELIM Xs;

/* split. Split a string into a list of substrings delimited by characters
   in the given DELIM string: */

public split DELIM S;
private split2 DELIM S L I J;

split DELIM:String S:String
			= split2 DELIM S (#S) 0 0;

split2 DELIM S L I J	= []
				if I>=L;
			= split2 DELIM S L I (J+1)
				if (J<L) and then (pos (S!J) DELIM < 0);
			= [substr S I (J-I),""]
				if J=L-1; // trailing delimiter
			= [substr S I (J-I)|split2 DELIM S L (J+1) (J+1)]
				otherwise;

/* strcat. Concatenate a list of strings: */

public strcat Xs;

strcat Xs:List		= foldl (++) "" Xs;
