
/* typec.q: type-checking predicates 11-09-02 AG */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* The following predicates check whether their argument is of the
   corresponding type. */

public isbool X;	// truth values
public ischar X;	// characters
public isexcept X;	// exceptions
public isfile X;	// files
public isfloat X;	// floating point numbers
public isint X;		// integers
public islist X;	// lists
public isnum X;		// numbers
public isstr X;		// strings
public special issym X;	// function and variable symbols
public istuple X;	// tuples

isbool _:Bool		= true;
isbool _		= false otherwise;

ischar _:Char		= true;
ischar _		= false otherwise;

isexcept _:Exception	= true;
isexcept _		= false otherwise;

isfile _:File		= true;
isfile _		= false otherwise;

isfloat _:Float		= true;
isfloat _		= false otherwise;

isint _:Int		= true;
isint _			= false otherwise;

islist _:List		= true;
islist _		= false otherwise;

isnum _:Num		= true;
isnum _			= false otherwise;

isstr _:String		= true;
isstr _			= false otherwise;

issym X			= isfun X or else isvar X;

istuple _:Tuple		= true;
istuple _		= false otherwise;
