
/* list and stream comprehension example (see also Abelson/Sussman:
   Structure and Interpretation of Computer Programs, MIT Press, 1985)
   05-04-1993 AG */

include print;

/*

prime_sum_pairs N: return the list of all (I,J,I+J) s.t. 1<=J<I<=N and
I+J is a prime number. This is equivalent to the following:

prime_sum_pairs N
		= cat (map (lambda I
 			    (cat (map (lambda J
 			    	       (ifelse (isprime (I+J)) [(I,J,I+J)] []))
 			     (nums 1 (I-1)))))
 		       (nums 1 N));

*/

prime_sum_pairs N	= listof (I,J,I+J)
			  (I in nums 1 N, J in nums 1 (I-1), isprime (I+J));

isprime N		= (N>1) and then prime_test N 2;
prime_test N M		= true if M*M>N;
			= false if N mod M = 0;
			= prime_test N (M+1) otherwise;

/*

all_prime_sum_pairs: generate the stream of all (I,J,I+J) s.t. 1<=J<I and
I+J is prime. To print, say `print all_prime_sum_pairs'.

*/

all_prime_sum_pairs	= streamof (I,J,I+J)
			  (I in numstream 1, J in nums 1 (I-1),
			   isprime (I+J));
