
/* trees.q: polymorphic programming example (11-07-1993, revised 03-02-2002
   AG) */

/*

This script implements an abstract supertype SearchTree together with two
concrete subtypes BinTree (cf. bintree.q) and AVLTree (cf. avltree.q) which
share the same set of basic operations: members, insert, delete and member.

The BinTree type implements search trees as ordinary binary trees, while
AVLTree provides a balanced tree data structure. Their common supertype
SearchTree supplies some generic operations for search tree types sharing the
members/insert/delete/member interface: union, diff, intersect and subeq (see
searchtree.q). Please refer to Section [Types] in the Q language documentation
for further explanation.

For instance, you might wish to try the following:

==> def T1 = mkavltree [1,7,12]

==> def T2 = mkbintree [3,12,14]

==> members (union T1 T2)
[1,3,7,12,14]

==> members (intersect T1 T2)
[12]

*/

include searchtree, bintree, avltree;
