#!/bin/sh

# Mangle global internal symbols in the interpreter. I usually run this once
# before release, in order to prevent name clashes between the interpreter and
# external modules on systems which support back-linking.

# Relies on the libglobs.a target in src/Makefile.am. I don't know whether
# this works on anything else but Linux, is there a portable way to do this??

if (cd src && make clean && rm -f mangle.h && touch mangle.h &&
    make libglobs.a)
then
  cd src
  echo '/* mangle.h: created' `date` 'by mangle.sh */' >> mangle.h
  echo '' >> mangle.h
  nm -B libglobs.a | sed -n -e 's/^.*[ 	]\([ABCDGISTW][ABCDGISTW]*\)[ 	][ 	]*\(\)\([_A-Za-z][_A-Za-z0-9]*\)$/\1 \2\3 \3/p' | sed 's/.* //' | sort | uniq | grep -v '^\(yy.*\|main\)$' | sed -e 's/^.*$/#define \0 __qq__\0/g' >> mangle.h
  make clean all
fi
echo '***' mangle done '***'
