
/* gdbm.q: GNU dbm interface (AG May 05 2003). */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* This module provides an interface to the GNU database management library.
   See gdbm(3). */

import clib;

/* Manifest constants. These flag values are used with the gdbm_open and
   gdbm_store functions. */

public var const
  // gdbm_open flags
  GDBM_READER, GDBM_WRITER, GDBM_WRCREAT, GDBM_NEWDB,
  // the followinf can be or'ed bitwise with the above
  GDBM_FAST /* obsolete */, GDBM_SYNC, GDBM_NOLOCK,
  // gdbm_store flags
  GDBM_INSERT, GDBM_REPLACE;

private extern gdbm_vars;
def (GDBM_READER, GDBM_WRITER, GDBM_WRCREAT, GDBM_NEWDB,
     GDBM_FAST, GDBM_SYNC, GDBM_NOLOCK,
     GDBM_INSERT, GDBM_REPLACE) = gdbm_vars;

/* Library version and error codes. */

public extern gdbm_version;
public extern gdbm_errno, gdbm_seterrno N, gdbm_strerror N;

/* Database files. Objects of this type are returned by the gdbm_open function
   and taken as arguments (denoted DBF in the following) by the other gdbm
   operations. */

public extern type GdbmFile;

/* Open and close a database. The MODE argument denotes the mode a new
   database file should be created with (e.g., 0666). You can also retrieve
   the file descriptor associated with a database file with the gdbm_fdesc
   function. */

public extern gdbm_open NAME BLOCK_SIZE FLAGS MODE;
public extern gdbm_close DBF;
public extern gdbm_fdesc DBF;

/* Operations to update and query the database. Both keys and data in the
   database files are represented using byte strings (clib::ByteStr). */

public extern gdbm_store DBF KEY DATA FLAG;
public extern gdbm_delete DBF KEY;
public extern gdbm_fetch DBF KEY;
public extern gdbm_exists DBF KEY;

/* Traverse all keys in the database. The traversal is done in an apparently
   random order (not sorted by keys). Note that gdbm_delete might rearrange
   the order of items in the database, so you shouldn't use this function
   during a traversal. */

public extern gdbm_firstkey DBF;
public extern gdbm_nextkey DBF KEY;

/* Database maintenance operations. The gdbm_sync function commits all changes
   to the disk file immediately. The gdbm_reorganize function can be used to
   shrink the database by eliminating space left over from gdbm_delete
   operations. */

public extern gdbm_sync DBF;
public extern gdbm_reorganize DBF;
