
/* octave.q: interface to the Octave interpreter (AG Sep 05 00) */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* This is a simple interface which enables you to exchange variable values
   between Q and Octave, and to pass commands to the Octave interpreter. */

/* OCTAVE variable: command to run octave with; edit this as needed */

public var OCTAVE;
def OCTAVE = "octave -q -i -H";

/*

octave: Submit a command string to the octave interpreter.

- The interpreter is started automatically upon the first call to this
  function.
- Results printed by the octave interpreter are echoed on stdout.
- The interpreter is run asynchronously through a pipe and hence the command
  may still be in progress (possibly producing output) when this function
  returns.
- The function returns () unless an error is encountered while setting up
  the pipe or communicating with the interpreter (in which case the rule
  fails).

*/

public extern octave CMD;

/*

octave_quit: Exit the interpreter. Next time the octave function is run again
a new interpreter will be started automatically. Calling the function when no
octave interpreter is running does not do any harm. This function is also
executed automatically when the Q interpreter terminates.

*/

public extern octave_quit;

/*

octave_get/octave_set: Get or set a variable in the octave interpreter.

- Supported variable types are integers, reals, complex numbers (translate
  to Octave scalar values), lists and lists of lists of scalars (translate to
  Octave vectors and matrices).
- Structures and strings are *not* supported (yet).
- The given NAME string is assumed to denote a legal Octave variable
  identifier.

*/

public extern octave_get NAME, octave_set NAME X;
