
/*  Q eQuational Programming System
    Copyright (c) 1991-2002 by Albert Graef
    <ag@muwiinfa.geschichte.uni-mainz.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "qbase.h"

char *prompt = PROMPT, *prompt2 = "> ", *prompt3 = ": ", *qpath = NULL,
  *histfile = HISTFILE, *initrc = INITRC, *exitrc = EXITRC,
  *prelude = "prelude.q";
char fformat[30];
char version[] = VERSION, year[] = YEAR, sysinfo[] = SYSINFO,
  dirstr[] = DIRSTR, volstr[] = VOLSTR;
int histmax = HISTMAX, memmax = MEMMAX, stackmax = STACKMAX,
  imode = 0, fmode = 0, fprec = 15;

char outid[MAXSTRLEN];
int mainno;
int codespsz;
int strspsz;
int limbspsz;
int hashtbsz = HASHTBSZ;
int symtbsz;
int statetbsz;
int transtbsz;
int roffstbsz;
int matchtbsz;
int inittbsz;
int modtbsz;
int imptbsz;

OPREC *codesp;
char *strsp;
mp_limb_t *limbsp;
int *hashtb;
SYMREC *symtb;
STATEREC *statetb;
TRANSREC *transtb;
int *roffstb;
int *matchtb;
int *inittb;
int *modtb;
int *fnametb;
int *imports;
int *imptb;
byte *impib;

byte *globs;

char           *
charstr(char *s, char c)
{
  s[0] = c;
  s[1] = '\0';
  return (s);
}

char           *
substr(char *s, char *t, int n)
{
  *s = 0;
  strncat(s, t, n);
  s[n] = 0;
  return (s);
}

char           *
pchar(char *s, char c)
{
  switch (c) {
  case '\t':
    return (strcpy(s, "\\t"));
  case '\b':
    return (strcpy(s, "\\b"));
  case '\f':
    return (strcpy(s, "\\f"));
  case '\n':
    return (strcpy(s, "\\n"));
  case '\r':
    return (strcpy(s, "\\r"));
  case '\\':
    return (strcpy(s, "\\\\"));
  case '\"':
    return (strcpy(s, "\\\""));
  default:
    if (isprint(c)) {
      sprintf(s, "%c", c);
      return (s);
    } else {
      sprintf(s, "\\%d", (int) ((unsigned char) c));
      return (s);
    }
  }
}

char           *
pstr(char *s1, char *s2)
{
  char           *s;

  *s1 = '\0';
  for (s = s1; *s2; s2++)
    s += strlen(pchar(s, *s2));
  return (s1);
}

char *
pmpz(char *s, mpz_t z)
{
  bool neg = z->_mp_size < 0;
  char *_s = s;
  if (neg) {
    z->_mp_size = -z->_mp_size;
    *_s++ = '-';
  }
  switch (imode) {
  case 1:
    strcpy(_s, "0x");
    mpz_get_str(_s+2, 16, z);
    break;
  case 2:
    strcpy(_s, "0");
    mpz_get_str(_s+1, 8, z);
    break;
  default:
    mpz_get_str(_s, 10, z);
    break;
  }
  if (neg) z->_mp_size = -z->_mp_size;
  return s;
}

char *
pfloat(char *s, double f)
{
  char *t;
  sprintf(s, fformat, f);
#ifdef _WIN32
  if (!strcmp(s, "1.#INF")) strcpy(s, "inf");
#endif
  if (!isalpha(s[0]) && (s[0] != '-' || !isalpha(s[1]))) {
    /* not inf or nan */
    if (!(t = strchr(s, 'e')) && !(t = strchr(s, 'E')) &&
	!(t = strchr(s, '.')))
      /* looks like an int, add decimal point */
      strcat(s, ".0");
  }
  return s;
}

char *
pname(char *s, int fno)
{
  if (fno < BINARY || fno >= OPERATOR1 && fno < OPERATOR2 ||
      visible(fno) && unique(fno))
    strcpy(s, strsp + symtb[fno].pname);
  else if (symtb[fno].modno == NONE)
    sprintf(s, "::%s", strsp + symtb[fno].pname);
  else
    sprintf(s, "%s::%s", strsp + modtb[symtb[fno].modno],
	    strsp + symtb[fno].pname);
  return s;
}

static char
scanchar(char **s)
{
  char            c;
  long            strtol();

  /* scan character at the head of *s, advance s accordingly: */

 scan:
  if (!**s)
    return (0);
  else if ((c = *(*s)++) == '\\') {
    switch (c = *(*s)++) {
    case 't':
      return ('\t');
    case 'b':
      return ('\b');
    case 'f':
      return ('\f');
    case 'n':
      return ('\n');
    case 'r':
      return ('\r');
    default:
      if ('0' <= c && c <= '9')
	return ((char) strtol(--*s, s, 0));
      else
	return (c);
    }
  } else
    return (c);
}

char           *
scanstr(char *s1, char *s2)
{
  char           *s = s1;

  while (*s2)
    *(s++) = scanchar(&s2);
  *s = '\0';
  return (s1);
}

static char	       *
home(void)
{
  static char *homedir = NULL;
  if (!homedir && !(homedir = getenv("HOME"))) {
    homedir = strdup("/");
    *homedir = *dirstr;
  }
  return homedir;
}

#define tilde(s) (s[0] == '~' && (!s[1] || strchr(dirstr, s[1]) && !strchr(volstr, s[1])))

int
absolute(char *s)
{
  char *t = s;
  if (!s || !*s)
    return 0;
  else if (tilde(s))
    return 1;
  else {
    while (*s && !strchr(dirstr, *s)) ++s;
    return *s && (s == t || strchr(volstr, *s));
  }
}

char *
dirname(char *t, char *s)
{
  char *s1, *s2 = NULL;
  for (s1 = s; *s1; s1++)
    if (strchr(dirstr, *s1))
      s2 = s1+1;
  if (s2) {
    strncpy(t, s, s2-s);
    t[s2-s] = 0;
  } else
    *t = 0;
  return t;
}

char *
basename(char *t, char *s, char c)
{
  char *s1, *s2;
  for (s1 = s2 = s; *s1; s1++)
    if (strchr(dirstr, *s1))
      s2 = s1+1;
  if ((s1 = strchr(strcpy(t, s2), c)))
    *s1 = 0;
  return t;
}

char *
absname(char *t, char *s)
{
  if (absolute(s))
    strcpy(t, s);
  else {
    if (!getcwd(t, MAXSTRLEN))
      strcpy(t, s);
    else {
      int l = strlen(t);
      if (l <= 1 || !strchr(dirstr, t[l-1]))
	t[l++] = *dirstr;
      strcpy(t+l, s);
    }
  }
  return t;
}

char           *
expand(char *s1, char *s2)
{
  if (tilde(s2)) {
    char *h = home();
    int l = strlen(h);
    strcpy(s1, h);
    if (l > 0 && strchr(dirstr, h[l-1]))
      strcpy(s1+l, s2+2);
    else
      strcpy(s1+l, s2+1);
  } else
    strcpy(s1, s2);
  return s1;
}

int
chkfile(char *s)
{
  struct stat st;
  return !stat(s, &st) && !S_ISDIR(st.st_mode);
}

char           *
searchlib(char *s1, char *s2)
{
  char           *s, *t;

  if (tilde(s2))
    return expand(s1, s2);
  else if (absolute(s2))
    return strcpy(s1, s2);
  for (s = qpath; *s; s = t) {
    int l;
    char p[MAXSTRLEN];
    if (!(t = strchr(s, PATHDELIM)))
      t = strchr(s, 0);
    if (s == t) goto next;
    if (s[0] == '.')
      if (t == s+1)
	s = t;
      else if (strchr(dirstr, s[1]) &&
	       !strchr(volstr, s[1]))
	s += 2;
    l = t-s;
    strncpy(p, s, l);
    p[l] = 0;
    expand(s1, p);
    l = strlen(s1);
    if (l > 0 && (!strchr(dirstr, s1[l-1]) || 
		  strchr(volstr, s1[l-1])))
      s1[l] = *dirstr, l++;
    strcpy(s1+l, s2);
    if (chkfile(s1))
      return s1;
  next:
    if (*t) t++;
  }
  return strcpy(s1, s2);
}

void
setpath(PATH *p, int i, int v)
{
  if (v)
    *p = *p | ((PATH) 1 << i);
  else
    *p = *p & ~((PATH) 1 << i);
}

int
getint(mpz_t z, int len, int l)
{
  int sz = (len>=0)?len:-len;
  mpz_init(z);
  if (z->_mp_d)
    if (sz > 0) {
      mpz_t z1;
      memcpy(z1, z, sizeof(mpz_t));
      if (_mpz_realloc(z, sz)) {
	memcpy(z->_mp_d, limbsp+l, sz*sizeof(mp_limb_t));
	z->_mp_size = len;
	return 1;
      } else {
	mpz_clear(z1);
	return 0;
      }
    } else
      return 1;
  else
    return 0;
}

void *
arealloc(void *ptr, int nelems, int newelems, int size)
{
  if (size == 0 || newelems == 0)
    return ptr;
  else if (nelems > INT_MAX - newelems || nelems + newelems > INT_MAX/size)
    return NULL;
  else if (ptr)
    return (void*) realloc(ptr, (nelems + newelems) * size);
  else
    return (void*) malloc((nelems + newelems) * size);
}

void init_qpath(char *s)
{
  if (!s) return;
  if (qpath) free(qpath);
  qpath = strdup(s);
}

void change_qpath(char *s)
{
  char *qpath1;
  int l;
  if (!s) return;
  if (!qpath) {
    init_qpath(s);
    return;
  }
  if (*s == PATHDELIM) {
    qpath1 = malloc(strlen(s)+strlen(qpath)+1);
    if (!qpath1) return;
    strcat(strcpy(qpath1, qpath), s);
    free(qpath);
    qpath = qpath1;
  }
  else if ((l = strlen(s)) > 0 && s[l-1] == PATHDELIM) {
    qpath1 = malloc(strlen(s)+strlen(qpath)+1);
    if (!qpath1) return;
    strcat(strcpy(qpath1, s), qpath);
    free(qpath);
    qpath = qpath1;
  } else
    init_qpath(s);
}
