
/* qcdefs.h: header file for the Q compiler */

/*  Q eQuational Programming System
    Copyright (c) 1991-2002 by Albert Graef
    <ag@muwiinfa.geschichte.uni-mainz.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "qbase.h"

/* Q compiler error and warning messages */

extern char    *qcmsg[];

enum qcmsgno {

  FILE_NOT_FOUND, CODE_FILE_ERR, TOO_MANY_FILES,

  SYNTAX_ERROR, DCL_ERROR, DOUBLE_TYPE_DCL, DOUBLE_DCL, MISM_DCL,
  MISS_DCL, AMBIG_IMP, INVALID_TYPE, INCOMPATIBLE_TYPE, INVALID_DEF,
  INVALID_VAR,
  OPEN_COMMENT, OPEN_STRING,
  INVALID_PRIO,

  LIMBSP_OVF, STRSP_OVF, SYMTB_OVF, EXPRTB_OVF, CODETB_OVF, MEM_OVF,
  
  UNKNOWN_REF, AMBIG_REF, CYCLIC_REF, UNBOUND_VAR

};

/* tables used by the Q compiler */

/* implementation limits: */

#define MAXFILES 8192		/* maximum number of files in compile */

#define VARTBSZ 3011		/* var table size (prime number!) */
#define EXPRTBSZ 102400		/* expression table size */
#define TMPSPSZ 102400		/* size of temporary string space */
#define TCODESPSZ 102400	/* temporary code space size */
#define LIMBSPSZ 5120		/* limb space size (adjusted dynamically) */
#define STRSPSZ 20480		/* string space size (adjusted dynamically) */
#define SYMTBSZ 2048		/* sym table size (adjusted dynamically) */
#define INITTBSZ 512		/* init table size (adjusted dynamically) */
#define MATCHTBSZ 2048		/* match table size (adjusted dynamically) */

/* global data: */

extern char    *code;		/* the code file name (default: "q.out") */
extern bool     hflag, nflag, vflag, wflag;
				/* compilation flags */
extern int	nerrs;		/* error count */
extern int	modno;		/* current module number */
extern int	prio;		/* current rule priority level */
extern FILE    *codefp;		/* the code file */

/* The temporary code space is used to store the code for a single rule: */

extern int	tcodespsz;
extern OPREC	tcodesp[TCODESPSZ];

/* expression structure used in the compiler: */

typedef struct expr {
	int             fno;	/* symbol */
	int		type;	/* type (0 = default type, NONE = unknown) */
	short		argc;	/* arg count in application */
	short		expc;	/* expected arg count */
	struct expr    *x1, *x2;	/* arguments */
	union {
		/* VAROP: */
		int             vno;	/* variable number */
		/* INTVALOP: */
		mpz_t		iv;	/* integer value */
		/* FLOATVALOP: */
		double          fv;	/* float value */
		/* STRVALOP: */
		int             sv;	/* string value */
	}               tag;
}               EXPR;

/* data structure for representing qualifier lists */

typedef struct qual { EXPR *x; int start, end; } QUAL;
typedef struct clause { EXPR *l, *r; } CLAUSE;

/* expression table: */

extern int 	exprtbsz;
extern EXPR	exprtb[EXPRTBSZ];

/* compiler tables (qctables.c): */

extern void inittables(void);
extern void clear(void);
extern int putlimbs(mpz_t z);
extern int putstr(char *s);
extern int puttmp(char *s);
extern void putimp(int mno, int b);
extern void putinc(int mno, int b);
extern void saveimps(void);
extern void restoreimps(void);
extern int mkfun(char *s);
extern int newfun(char *s, int fno);
extern void asfun(int fno, int fno2, byte argc, unsigned long argv,
		  byte flags);
extern int dclfun(int fno, int type, byte argc, unsigned long argv,
		  byte flags);
extern int mkfvar(char *s);
extern int newfvar(char *s, int vno);
extern void asfvar(int vno, int vno2, byte flags);
extern int dclfvar(int vno, byte flags);
extern int mktype(char *s);
extern int newtype(char *s, int type);
extern void astype(int type, int type2, byte flags);
extern int dcltype(int type, int supertype, byte flags);
extern int checktype(int type);
extern int mkvar(char *s);
extern int mkvarsym(int vno);

/* expr constructors */

extern EXPR
  *intexpr(mpz_t iv),
  *floatexpr(double fv),
  *strexpr(int sv),
  *varexpr(int vno),
  *consexpr(EXPR *x1, EXPR *x2),
  *pairexpr(EXPR *x1, EXPR *x2),
  *appexpr(EXPR *x1, EXPR *x2),
  *funexpr(int fno),
  *binexpr(int fno, EXPR *x1, EXPR *x2),
  *unexpr(int fno, EXPR *x1);

/* code generation */

extern void genop(int opcode);
extern void genlval(byte offs, byte plen, PATH p, int vsym);
extern void genmatch(int m);
extern void geninfop(int modno, int lineno);
extern void fixinfop(int modno, int lineno);
extern void genintval(mpz_t iv);
extern void genfloatval(double fv);
extern void genstrval(int sv);
extern void set_mode(void);
extern void add_init(int offs);
extern void write_header(void);
extern void write_code(void);
extern void write_strsp(void);
extern void write_limbsp(void);
extern void write_hashtb(void);
extern void write_symtb(void);
extern void write_state(int ntrans, int trans, int nrules, int roffs);
extern void write_trans(int type, int fno, int next);
extern void write_roffs(int roffs);
extern void write_rmno(int rmno);
extern void write_matchtb(void);
extern void write_inittb(void);
extern void write_modtb(void);
extern void fix_header(void);

/* rule compiler (qcrules.c): */

extern void debug_info(void);
extern void fix_debug_info(void);
extern void left_hand_side(EXPR *x);
extern void queries(EXPR *x);
extern void mark1(void);
extern void mark2(void);
extern void right_hand_side(EXPR *x);
extern void qualifier(EXPR *x);
extern void where_clause(EXPR *x, EXPR *y);
extern void init_def(void);
extern void definition(EXPR *x, EXPR *y);
extern void expression(EXPR *x);
extern void write_TA(void);

/* the var symbol table is used to hash variable symbols: */

typedef struct varrec {
  bool            dflag;	/* set for defined entries */
  int		  type;		/* type (0 if none) */
  int             pname;	/* index into temporary string space */
  int             pname_s;	/* index into permanent string space */
  byte            offs;		/* var offset */
  byte            plen;		/* var path */
  PATH            p;
}               VARREC;

extern VARREC   vartb[VARTBSZ];

/* temporary string space: */

extern char     tmpsp[TMPSPSZ];
extern int	tmpspsz;

/* break handler: */

extern RETSIGTYPE break_handler();
