
/* assert.q: print diagnostics 03-30-1993, revised 02-24-02, 03-02-02 AG */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

include stdlib, error;

/* The function assert returns () if the given expression evaluates to
   true; otherwise it invokes error to print an error message of the form
   	assertion (P) failed, value (value of P). */

public special assert P;

assert P		= error ("assertion ("++strq 'P++") failed, "++
			         "value ("++str X++")") if neq true X
			  where X = P;
			= () otherwise;
