
/* comp.q: comparisons of lists and tuples 11-09-02 AG */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Equality for lists and tuples, and lexicographic list ordering. */

/* Lists: */

([] = [])		= true;
([] = [X|Xs])		= false;
([X|Xs] = [])		= false;
([X|Xs] = [Y|Ys])	= (X=Y) and then (Xs=Ys);

[] <> []		= false;
[] <> [X|Xs]		= true;
[X|Xs] <> []		= true;
[X|Xs] <> [Y|Ys]	= (X<>Y) or else (Xs<>Ys);

[] < []			= false;
[] < [X|Xs]		= true;
[X|Xs] < []		= false;
[X|Xs] < [Y|Ys]		= (X<Y) or else (X=Y) and then (Xs<Ys);

[] > []			= false;
[] > [X|Xs]		= false;
[X|Xs] > []		= true;
[X|Xs] > [Y|Ys]		= (X>Y) or else (X=Y) and then (Xs>Ys);

[] <= []		= true;
[] <= [X|Xs]		= true;
[X|Xs] <= []		= false;
[X|Xs] <= [Y|Ys]	= (X<Y) or else (X=Y) and then (Xs<=Ys);

[] >= []		= true;
[] >= [X|Xs]		= false;
[X|Xs] >= []		= true;
[X|Xs] >= [Y|Ys]	= (X>Y) or else (X=Y) and then (Xs>=Ys);

/* Tuples: */

(() = ())		= true;
(() = (X|Xs))		= false;
((X|Xs) = ())		= false;
((X|Xs) = (Y|Ys))	= (X=Y) and then (Xs=Ys);

() <> ()		= false;
() <> (X|Xs)		= true;
(X|Xs) <> ()		= true;
(X|Xs) <> (Y|Ys)	= (X<>Y) or else (Xs<>Ys);
