
/* list.q: list comprehensions 10-20-1993, revised 03-02-2002, 09-18-02 AG */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

include stdlib, cond, lambda;

public type ListComp : Lambda = special listof A Cs;

private special listofx A Cs;

lambdax (listof A Cs)	= listofx A Cs;

listof A Cs		= `(listofx A Cs);

listofx A ()		= '[A];
listofx A (X in Xs|Cs)	= '(cat (map (lambda X `(listofx A Cs))
				 (filter (matchp X) Xs)));
listofx A (X in Xs)	= '(cat (map (lambda X [A]) (filter (matchp X) Xs)));
listofx A (P|Cs)	= '(ifelse P `(listofx A Cs) []);
listofx A P		= '(ifelse P [A] []);
